/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.cpm;

import com.emv.qrcode.core.configuration.DecodersCpmMap;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.decoder.cpm.DecodeCpmIterator;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public abstract class DecoderCpm<T> {
    private static final Map<Class<?>, Constructor<? extends DecoderCpm<?>>> ctorMap = new ConcurrentHashMap();
    protected final Iterator<byte[]> iterator;

    protected DecoderCpm(byte[] source) {
        this.iterator = new DecodeCpmIterator(source);
    }

    protected abstract T decode() throws PresentedModeException;

    protected static <C, T> Map.Entry<Class<?>, BiConsumer<C, ?>> consumerTagLengthValue(Class<T> clazz, BiConsumer<C, T> consumer) {
        return new AbstractMap.SimpleEntry(clazz, consumer);
    }

    public static final <T> T decode(String source, Class<T> clazz) throws PresentedModeException {
        return DecoderCpm.decode(Base64.getDecoder().decode(source), clazz);
    }

    public static final <T> T decode(byte[] source, Class<T> clazz) throws PresentedModeException {
        try {
            Class<DecoderCpm<?>> parserClass = DecodersCpmMap.getDecoder(clazz);
            if (!ctorMap.containsKey(clazz)) {
                ctorMap.put(clazz, parserClass.getConstructor(byte[].class));
            }
            Constructor<DecoderCpm<?>> ctor = ctorMap.get(clazz);
            DecoderCpm<?> parser = ctor.newInstance(new Object[]{source});
            return clazz.cast(parser.decode());
        }
        catch (PresentedModeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

