/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.cpm;

import com.emv.qrcode.core.exception.DuplicateTagException;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.core.model.cpm.BERTLAlphanumeric;
import com.emv.qrcode.core.model.cpm.BERTLBinary;
import com.emv.qrcode.core.model.cpm.BERTLCompressedNumeric;
import com.emv.qrcode.core.model.cpm.BERTLNumeric;
import com.emv.qrcode.core.model.cpm.BERTag;
import com.emv.qrcode.core.utils.BERUtils;
import com.emv.qrcode.decoder.cpm.DecoderCpm;
import com.emv.qrcode.model.cpm.AdditionalData;
import com.emv.qrcode.model.cpm.CommonDataTemplate;
import com.emv.qrcode.model.cpm.CommonDataTransparentTemplate;
import com.emv.qrcode.model.cpm.constants.ConsumerPresentedModeFieldCodes;
import com.emv.qrcode.model.cpm.constants.TagTransactionProcessingCodes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.codec.binary.Hex;

public final class CommonDataTemplateDecoder
extends DecoderCpm<CommonDataTemplate> {
    private static final Map.Entry<Class<?>, BiConsumer<CommonDataTemplate, ?>> defaultEntry = CommonDataTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData);
    private static final Map<BERTag, Map.Entry<Class<?>, BiConsumer<CommonDataTemplate, ?>>> mapConsumers = new HashMap();

    public CommonDataTemplateDecoder(byte[] source) {
        super(BERUtils.valueOf(source));
    }

    @Override
    protected CommonDataTemplate decode() throws PresentedModeException {
        HashSet<BERTag> tags = new HashSet<BERTag>();
        CommonDataTemplate result = new CommonDataTemplate();
        while (this.iterator.hasNext()) {
            byte[] value = (byte[])this.iterator.next();
            BERTag tag = new BERTag(BERUtils.valueOfTag(value));
            if (tags.contains(tag)) {
                throw new DuplicateTagException("CommonDataTemplate", tag.toString(), Hex.encodeHexString((byte[])value, (boolean)false));
            }
            tags.add(tag);
            Map.Entry<Class<?>, BiConsumer<CommonDataTemplate, ?>> entry = mapConsumers.getOrDefault(tag, defaultEntry);
            Class<?> clazz = entry.getKey();
            BiConsumer<CommonDataTemplate, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderCpm.decode(value, clazz));
        }
        return result;
    }

    static {
        mapConsumers.put(ConsumerPresentedModeFieldCodes.ID_COMMON_DATA_TRANSPARENT_TEMPLATE, CommonDataTemplateDecoder.consumerTagLengthValue(CommonDataTransparentTemplate.class, CommonDataTemplate::setCommonDataTransparentTemplate));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_DEFINITION_FILE_NAME, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_LABEL, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_TRACK_2_EQUIVALENT_DATA, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_PAN, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLCompressedNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_CARDHOLDER_NAME, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_LANGUAGE_PREFERENCE, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_ISSUER_URL, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_VERSION_NUMBER, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_TOKEN_REQUESTOR_ID, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_PAYMENT_ACCOUNT_REFERENCE, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_LAST_4_DIGITS_OF_PAN, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_CRYPTOGRAM_INFORMATION_DATA, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_TRANSACTION_COUNTER, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_CRYPTOGRAM, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_ISSUER_APPLICATION_DATA, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_UNPREDICTABLE_NUMBER, CommonDataTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
    }
}

