/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.decoder.cpm;

import com.emv.qrcode.core.exception.DuplicateTagException;
import com.emv.qrcode.core.exception.PresentedModeException;
import com.emv.qrcode.core.model.cpm.BERTLAlphanumeric;
import com.emv.qrcode.core.model.cpm.BERTLBinary;
import com.emv.qrcode.core.model.cpm.BERTLCompressedNumeric;
import com.emv.qrcode.core.model.cpm.BERTLNumeric;
import com.emv.qrcode.core.model.cpm.BERTag;
import com.emv.qrcode.core.utils.BERUtils;
import com.emv.qrcode.decoder.cpm.DecoderCpm;
import com.emv.qrcode.model.cpm.AdditionalData;
import com.emv.qrcode.model.cpm.ApplicationSpecificTransparentTemplate;
import com.emv.qrcode.model.cpm.ApplicationTemplate;
import com.emv.qrcode.model.cpm.constants.ConsumerPresentedModeFieldCodes;
import com.emv.qrcode.model.cpm.constants.TagTransactionProcessingCodes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.codec.binary.Hex;

public final class ApplicationTemplateDecoder
extends DecoderCpm<ApplicationTemplate> {
    private static final Map.Entry<Class<?>, BiConsumer<ApplicationTemplate, ?>> defaultEntry = ApplicationTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData);
    private static final Map<BERTag, Map.Entry<Class<?>, BiConsumer<ApplicationTemplate, ?>>> mapConsumers = new HashMap();

    public ApplicationTemplateDecoder(byte[] source) {
        super(BERUtils.valueOf(source));
    }

    @Override
    protected ApplicationTemplate decode() throws PresentedModeException {
        HashSet<BERTag> tags = new HashSet<BERTag>();
        ApplicationTemplate result = new ApplicationTemplate();
        while (this.iterator.hasNext()) {
            byte[] value = (byte[])this.iterator.next();
            BERTag tag = new BERTag(BERUtils.valueOfTag(value));
            if (tags.contains(tag)) {
                throw new DuplicateTagException("ApplicationTemplate", tag.toString(), Hex.encodeHexString((byte[])value, (boolean)false));
            }
            tags.add(tag);
            Map.Entry<Class<?>, BiConsumer<ApplicationTemplate, ?>> entry = mapConsumers.getOrDefault(tag, defaultEntry);
            Class<?> clazz = entry.getKey();
            BiConsumer<ApplicationTemplate, ?> consumer = entry.getValue();
            consumer.accept(result, DecoderCpm.decode(value, clazz));
        }
        return result;
    }

    static {
        mapConsumers.put(ConsumerPresentedModeFieldCodes.ID_APPLICATION_SPECIFIC_TRANSPARENT_TEMPLATE, ApplicationTemplateDecoder.consumerTagLengthValue(ApplicationSpecificTransparentTemplate.class, ApplicationTemplate::setApplicationSpecificTransparentTemplate));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_DEFINITION_FILE_NAME, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_LABEL, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_TRACK_2_EQUIVALENT_DATA, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_PAN, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLCompressedNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_CARDHOLDER_NAME, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_LANGUAGE_PREFERENCE, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_ISSUER_URL, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_VERSION_NUMBER, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_TOKEN_REQUESTOR_ID, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_PAYMENT_ACCOUNT_REFERENCE, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLAlphanumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_LAST_4_DIGITS_OF_PAN, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_CRYPTOGRAM_INFORMATION_DATA, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_TRANSACTION_COUNTER, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLNumeric.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_APPLICATION_CRYPTOGRAM, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_ISSUER_APPLICATION_DATA, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
        mapConsumers.put(TagTransactionProcessingCodes.ID_UNPREDICTABLE_NUMBER, ApplicationTemplateDecoder.consumerTagLengthValue(BERTLBinary.class, AdditionalData::addAdditionalData));
    }
}

