/*
 * Decompiled with CFR 0.152.
 */
package com.emv.qrcode.core.utils;

import com.emv.qrcode.core.model.cpm.BERTag;
import java.util.Arrays;

public final class BERUtils {
    private static final int MAX_BYTE_VALUE = 128;
    private static final int NUMBER_OF_BYTES_MASK = 127;

    private BERUtils() {
    }

    public static final byte[] valueOfTag(byte[] source) {
        return BERUtils.valueOfTag(source, 0);
    }

    public static final byte[] valueOfTag(byte[] source, Integer from) {
        return Arrays.copyOfRange(source, (int)from, (int)BERUtils.countBytesOfTag(source));
    }

    public static final Integer valueOfLength(byte[] source) {
        return BERUtils.valueOfLength(source, 0);
    }

    public static final Integer valueOfLength(byte[] source, Integer from) {
        Integer countBytesOfTag = BERUtils.countBytesOfTag(source, from);
        Integer countBytesOfLength = BERUtils.countBytesOfLength(source, from);
        Integer skipFirstByte = countBytesOfLength > 1 ? 1 : 0;
        Integer numberOfBytes = countBytesOfLength - skipFirstByte;
        byte[] bytes = new byte[2];
        for (int i = 0; i < numberOfBytes; ++i) {
            bytes[2 - numberOfBytes.intValue() + i] = source[from + countBytesOfTag + skipFirstByte + i];
        }
        return (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
    }

    public static final byte[] valueOf(byte[] source) {
        return BERUtils.valueOf(source, 0);
    }

    public static final byte[] valueOf(byte[] source, Integer from) {
        int numberOfBytesTag = BERUtils.countBytesOfTag(source, from);
        int numberOfBytesLength = BERUtils.countBytesOfLength(source, from);
        int start = from + numberOfBytesTag + numberOfBytesLength;
        int end = start + BERUtils.valueOfLength(source, from);
        return Arrays.copyOfRange(source, start, end);
    }

    public static final byte[] chunk(byte[] source, Integer from) {
        int numberOfBytesTag = BERUtils.countBytesOfTag(source, from);
        int numberOfBytesLength = BERUtils.countBytesOfLength(source, from);
        int start = from + numberOfBytesTag + numberOfBytesLength;
        int end = start + BERUtils.valueOfLength(source, from);
        return Arrays.copyOfRange(source, (int)from, end);
    }

    public static final byte[] lengthOfValue(Integer value) {
        if (value > 127) {
            Integer numberOfBytes = BERUtils.countBytes(value);
            if (numberOfBytes > 2) {
                throw new IllegalStateException("Encode the length is more then 2 bytes (65535)");
            }
            byte[] bytes = new byte[numberOfBytes + 1];
            bytes[0] = (byte)(128 + numberOfBytes);
            for (int i = 0; i < numberOfBytes; ++i) {
                bytes[numberOfBytes.intValue() - i] = (byte)(value >> i * 8);
            }
            return bytes;
        }
        return new byte[]{value.byteValue()};
    }

    private static final Integer countBytes(Integer value) {
        if (value == 0) {
            return 0;
        }
        return BERUtils.countBytes(value >> 8) + 1;
    }

    public static final Integer countBytesOfTag(byte[] source) {
        return BERUtils.countBytesOfTag(source, 0);
    }

    public static final Integer countBytesOfTag(byte[] source, Integer from) {
        Integer n;
        Integer n2;
        Integer count = 0;
        boolean hasNextByte = BERTag.hasNextByte(source[from + count]);
        if (hasNextByte) {
            n2 = count;
            n = count = Integer.valueOf(count + 1);
        }
        while (hasNextByte && BERTag.isNotLastByte(source[from + count])) {
            n2 = count;
            n = count = Integer.valueOf(count + 1);
        }
        return count + 1;
    }

    public static final Integer countBytesOfLength(byte[] source) {
        return BERUtils.countBytesOfLength(source, 0);
    }

    public static final Integer countBytesOfLength(byte[] source, Integer from) {
        Integer countBytesOfTag = BERUtils.countBytesOfTag(source, from);
        if ((source[from + countBytesOfTag] & 0x80) == 128) {
            int numberOfBytes = source[from + countBytesOfTag] & 0x7F;
            if (numberOfBytes > 2) {
                throw new IllegalStateException("Decode the length is more then 2 bytes (65535)");
            }
            return numberOfBytes + 1;
        }
        return 1;
    }
}

