/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.logging;

import com.ibm.mqlight.api.logging.Logger;
import java.lang.reflect.Constructor;

public abstract class LoggerFactory {
    public static final String LOGGER_FACTORY_IMPL_CLASS_NAME = "com.ibm.mqlight.api.impl.logging.LoggerFactoryImpl";
    private static final LoggerFactory impl;

    public static Logger getLogger(Class<?> clazz) {
        return impl.getLoggerImpl(clazz);
    }

    public static Logger getLogger(org.slf4j.Logger logger) {
        return impl.getLoggerImpl(logger);
    }

    protected abstract Logger getLoggerImpl(Class<?> var1);

    protected abstract Logger getLoggerImpl(org.slf4j.Logger var1);

    static {
        LoggerFactory loggerFactoryImpl;
        try {
            Class<?> classToInstantiate = Class.forName(LOGGER_FACTORY_IMPL_CLASS_NAME);
            Constructor<?> constructor = classToInstantiate.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            loggerFactoryImpl = (LoggerFactory)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error(exception.toString());
        }
        impl = loggerFactoryImpl;
    }
}

