/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.timer;

import com.ibm.mqlight.api.Promise;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import com.ibm.mqlight.api.timer.TimerService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TimerServiceImpl
implements TimerService {
    private static final Logger logger = LoggerFactory.getLogger(TimerServiceImpl.class);
    private static final int idleKeepAliveTimeMs = 500;
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(0, new TimerServiceThreadFactory());
    private int timerCount = 0;
    private static final ConcurrentHashMap<Promise<Void>, Timer> promiseToTimer;

    @Override
    public void schedule(long delay, Promise<Void> promise) {
        String methodName = "schedule";
        logger.entry(this, "schedule", delay, promise);
        Timer timer = new Timer(this, promise, promiseToTimer);
        this.incrementUsage();
        timer.future = TimerServiceImpl.executor.schedule(timer, delay, TimeUnit.MILLISECONDS);
        promiseToTimer.put(promise, timer);
        logger.exit(this, "schedule");
    }

    @Override
    public void cancel(Promise<Void> promise) {
        String methodName = "cancel";
        logger.entry(this, "cancel", promise);
        Timer timer = promiseToTimer.get(promise);
        if (timer != null && timer.future.cancel(false)) {
            promiseToTimer.remove(promise);
            promise.setFailure(null);
            this.decrementUsage();
        }
        logger.exit(this, "cancel");
    }

    private synchronized void decrementUsage() {
        if (--this.timerCount == 0) {
            executor.setKeepAliveTime(500L, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void incrementUsage() {
        if (++this.timerCount == 1) {
            executor.setKeepAliveTime(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
    }

    static {
        executor.setKeepAliveTime(500L, TimeUnit.MILLISECONDS);
        executor.setRemoveOnCancelPolicy(true);
        promiseToTimer = new ConcurrentHashMap();
    }

    private static class Timer
    implements Runnable {
        private static final Logger logger = LoggerFactory.getLogger(Timer.class);
        private final TimerServiceImpl service;
        private final Promise<Void> promise;
        private final ConcurrentHashMap<Promise<Void>, Timer> promiseToTimer;
        private ScheduledFuture<?> future;

        private Timer(TimerServiceImpl service, Promise<Void> promise, ConcurrentHashMap<Promise<Void>, Timer> promiseToTimer) {
            String methodName = "<init>";
            logger.entry(this, "<init>", service, promise, promiseToTimer);
            this.service = service;
            this.promise = promise;
            this.promiseToTimer = promiseToTimer;
            logger.exit(this, "<init>");
        }

        @Override
        public void run() {
            String methodName = "run";
            logger.entry(this, "run");
            this.promiseToTimer.remove(this.promise);
            this.promise.setSuccess(null);
            this.service.decrementUsage();
            logger.exit(this, "run");
        }
    }

    static class TimerServiceThreadFactory
    implements ThreadFactory {
        final ThreadFactory factory = Executors.defaultThreadFactory();

        TimerServiceThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.factory.newThread(r);
            t.setName(TimerServiceImpl.class.getSimpleName() + "-" + t.getName());
            return t;
        }
    }
}

