/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.StatusPrinter;
import com.ibm.mqlight.api.ClientRuntimeException;
import com.ibm.mqlight.api.impl.logging.Version;
import com.ibm.mqlight.api.impl.logging.logback.LogFilter;
import com.ibm.mqlight.api.impl.logging.logback.TraceFilter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogbackLoggingImpl {
    protected static final Class<LogbackLoggingImpl> cclass = LogbackLoggingImpl.class;
    private static final String outputEncoding = System.getProperty("file.encoding", "UTF-8");
    private static final com.ibm.mqlight.api.logging.Logger logger = com.ibm.mqlight.api.logging.LoggerFactory.getLogger(cclass);
    private static final String pid;
    private static AtomicBoolean setup;
    private static String defaultRequiredMQLightLogLevel;
    private static String logbackConfigResource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup() {
        LoggerContext context;
        ILoggerFactory loggerFactory;
        if (!setup.getAndSet(true) && (loggerFactory = LoggerFactory.getILoggerFactory()) instanceof LoggerContext && !(context = (LoggerContext)loggerFactory).isStarted()) {
            Logger rootLogger = context.getLogger("ROOT");
            Level mqlightLogLevel = LogbackLoggingImpl.getMQLightLogLevel();
            if (mqlightLogLevel != null) {
                InputStream logbackConfigResourceStream = null;
                try {
                    logbackConfigResourceStream = ClassLoader.class.getResourceAsStream(logbackConfigResource);
                    if (logbackConfigResourceStream == null) {
                        System.err.println("ERROR: MQ Light '" + logbackConfigResource + "' is missing.");
                    } else {
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext((Context)context);
                        context.reset();
                        configurator.doConfigure(logbackConfigResourceStream);
                    }
                }
                catch (JoranException e) {
                }
                finally {
                    if (logbackConfigResourceStream != null) {
                        try {
                            logbackConfigResourceStream.close();
                        }
                        catch (IOException e) {
                            rootLogger.error("WARNING: Failed to close " + logbackConfigResource + ", reason: " + e.getLocalizedMessage());
                        }
                    }
                }
                rootLogger.setLevel(mqlightLogLevel);
                LoggerOutput logOutput = LogbackLoggingImpl.getMQLightLogOutput();
                OutputStreamAppender<ILoggingEvent> logAppender = LogbackLoggingImpl.createAppender(context, new LogFilter(), logOutput, "log.pattern", "log");
                rootLogger.addAppender(logAppender);
                LoggerOutput traceOutput = LogbackLoggingImpl.getMQLightTraceOutput();
                if (traceOutput.equals(logOutput)) {
                    traceOutput = logOutput;
                }
                OutputStreamAppender<ILoggingEvent> traceAppender = LogbackLoggingImpl.createAppender(context, new TraceFilter(), traceOutput, "trace.pattern", "trace");
                rootLogger.addAppender(traceAppender);
                if (rootLogger.isTraceEnabled()) {
                    LogbackLoggingImpl.writeTraceHeaderInfo(traceOutput.getPrintStream());
                    logger.data("setup", "Trace level set to: " + mqlightLogLevel);
                }
                StatusPrinter.setPrintStream((PrintStream)logOutput.getPrintStream());
                StatusPrinter.print((Context)context);
            } else if (ClassLoader.class.getResource("/logback.groovy") == null && ClassLoader.class.getResource("/logback-test.xml") == null && ClassLoader.class.getResource("/logback.xml") == null) {
                rootLogger.setLevel(Level.WARN);
            }
        }
    }

    private static OutputStreamAppender<ILoggingEvent> createAppender(LoggerContext context, Filter<ILoggingEvent> filter, LoggerOutput logOutput, String patternProperty, String name) {
        OutputStreamAppender appender;
        PatternLayoutEncoder patternLayoutEncoder = LogbackLoggingImpl.createPatternLayoutEncoder(context, patternProperty);
        if (logOutput.isConsole()) {
            appender = new OutputStreamAppender();
            appender.setContext((Context)context);
            appender.setEncoder((Encoder)patternLayoutEncoder);
            appender.setOutputStream((OutputStream)logOutput.getPrintStream());
            appender.setName(name);
            appender.addFilter(filter);
            appender.start();
        } else {
            RollingFileAppender rAppender = new RollingFileAppender();
            rAppender.setContext((Context)context);
            rAppender.setEncoder((Encoder)patternLayoutEncoder);
            rAppender.setFile(logOutput.getOutputName() + "." + logOutput.getOutputType());
            rAppender.setName(name);
            rAppender.addFilter(filter);
            FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
            rollingPolicy.setContext((Context)context);
            rollingPolicy.setParent((FileAppender)rAppender);
            rollingPolicy.setFileNamePattern(logOutput.getOutputName() + "%i." + logOutput.getOutputType());
            rollingPolicy.setMinIndex(1);
            rollingPolicy.setMaxIndex(logOutput.getFileCount());
            rollingPolicy.start();
            SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
            triggeringPolicy.setContext((Context)context);
            triggeringPolicy.setMaxFileSize(logOutput.getFileLimit());
            triggeringPolicy.start();
            rAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
            rAppender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
            rAppender.start();
            appender = rAppender;
        }
        return appender;
    }

    private static PatternLayoutEncoder createPatternLayoutEncoder(LoggerContext context, String patternProperty) {
        String pattern = context.getProperty(patternProperty);
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setContext((Context)context);
        patternLayoutEncoder.setPattern(pattern);
        patternLayoutEncoder.start();
        return patternLayoutEncoder;
    }

    private static Level getMQLightLogLevel() {
        String requiredMQLightLogLevel = System.getenv("MQLIGHT_JAVA_LOG");
        if (requiredMQLightLogLevel == null || requiredMQLightLogLevel.length() == 0) {
            requiredMQLightLogLevel = defaultRequiredMQLightLogLevel;
        }
        Level mqlightLogLevel = null;
        if (requiredMQLightLogLevel != null && (mqlightLogLevel = Level.toLevel((String)requiredMQLightLogLevel, null)) == null) {
            System.err.println("ERROR: MQ Light log level '" + requiredMQLightLogLevel + "' is invalid");
        }
        return mqlightLogLevel;
    }

    private static LoggerOutput getMQLightOutput(String defaultOutput, String type) {
        LoggerOutput result;
        String requiredOutput = System.getenv("MQLIGHT_JAVA_LOG_STREAM");
        if (requiredOutput == null || requiredOutput.trim().length() == 0) {
            requiredOutput = defaultOutput;
        }
        if (requiredOutput.equals("stdout")) {
            result = new LoggerOutput(requiredOutput, "", System.out);
        } else if (requiredOutput.equals("stderr")) {
            result = new LoggerOutput(requiredOutput, "", System.err);
        } else {
            String logFileCount = System.getenv("MQLIGHT_JAVA_LOG_FILE_COUNT");
            String logFileLimit = System.getenv("MQLIGHT_JAVA_LOG_FILE_LIMIT");
            PrintStream outputStream = null;
            try {
                outputStream = new PrintStream(new File(requiredOutput + "." + type), outputEncoding);
            }
            catch (FileNotFoundException | UnsupportedEncodingException e) {
                ClientRuntimeException exception = new ClientRuntimeException("Unable to log to file: '" + requiredOutput + "." + type + "': " + e.getLocalizedMessage());
                throw exception;
            }
            result = new LoggerOutput(requiredOutput, type, outputStream, logFileCount, logFileLimit);
        }
        return result;
    }

    private static LoggerOutput getMQLightLogOutput() {
        return LogbackLoggingImpl.getMQLightOutput("stdout", "log");
    }

    private static LoggerOutput getMQLightTraceOutput() {
        return LogbackLoggingImpl.getMQLightOutput("stderr", "trc");
    }

    public static void setDefaultRequiredMQLightLogLevel(String value) {
        defaultRequiredMQLightLogLevel = value;
    }

    static void setLogbackConfigResource(String value) {
        logbackConfigResource = value;
    }

    static String getLogbackConfigResource() {
        return logbackConfigResource;
    }

    private static void writeTraceHeaderInfo(PrintStream out) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz YYYY");
        out.println("Date: " + dateFormat.format(new Date()));
        out.println("\nProcess ID: " + pid);
        out.println("\nSystem properties:");
        Properties sysProps = System.getProperties();
        int maxPropNameLength = 0;
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            maxPropNameLength = Math.max(maxPropNameLength, ((String)entry.getKey()).length());
        }
        String propNameStringFormat = "%-" + maxPropNameLength + "." + maxPropNameLength + "s";
        for (Map.Entry<Object, Object> entry : sysProps.entrySet()) {
            String prop = String.format(propNameStringFormat, entry.getKey());
            String value = (String)entry.getValue();
            out.println("|   " + prop + "  :-  " + value);
        }
        out.println("\nRuntime properties:");
        out.println("Available processors: " + Runtime.getRuntime().availableProcessors());
        out.println("Total memory in bytes (now): " + Runtime.getRuntime().totalMemory());
        out.println("Free memory in bytes (now): " + Runtime.getRuntime().freeMemory());
        out.println("Max memory in bytes: " + Runtime.getRuntime().maxMemory());
        out.println("\nStack trace of initiating call:");
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            for (StackTraceElement element : exception.getStackTrace()) {
                out.println("  " + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")");
            }
            out.println("\nVersion: " + Version.getVersion());
            out.println("\nTimeStamp    TID  ClientId     ObjectId  Class                                                                                      Data");
            out.println("======================================================================================================================================================================");
            out.flush();
            return;
        }
    }

    public static void stop() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            LoggerContext context = (LoggerContext)loggerFactory;
            context.stop();
        }
        setup.getAndSet(false);
    }

    static {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        pid = processName.split("@")[0];
        setup = new AtomicBoolean(false);
        defaultRequiredMQLightLogLevel = null;
        logbackConfigResource = "/com/ibm/mqlight/api/resources/mqlight-logback.xml";
    }

    private static class LoggerOutput {
        private static final String defaultFileCount = "5";
        private static final String defaultFileLimit = "20MB";
        private final String outputName;
        private final String outputType;
        private final PrintStream printStream;
        private final int fileCount;
        private final String fileLimit;

        public LoggerOutput(String outputName, String outputType, PrintStream printStream) {
            this(outputName, outputType, printStream, defaultFileCount, defaultFileLimit);
        }

        public LoggerOutput(String outputName, String outputType, PrintStream printStream, String fileCount, String fileLimit) {
            this.outputName = outputName;
            this.outputType = outputType;
            this.printStream = printStream;
            try {
                this.fileCount = Integer.parseInt(fileCount == null || fileCount.trim().length() == 0 ? defaultFileCount : fileCount);
            }
            catch (NumberFormatException e) {
                ClientRuntimeException exception = new ClientRuntimeException("Invalid file count value '" + fileCount + "' specified");
                throw exception;
            }
            this.fileLimit = fileLimit == null || fileLimit.trim().length() == 0 ? defaultFileLimit : fileLimit;
        }

        public String getFileLimit() {
            return this.fileLimit;
        }

        public int getFileCount() {
            return this.fileCount;
        }

        public PrintStream getPrintStream() {
            return this.printStream;
        }

        public boolean isConsole() {
            return this.outputName.equals("stdout") || this.outputName.equals("stderr");
        }

        public String getOutputName() {
            return this.outputName;
        }

        public String getOutputType() {
            return this.outputType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.outputName == null ? 0 : this.outputName.hashCode());
            result = 31 * result + (this.outputType == null ? 0 : this.outputType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoggerOutput other = (LoggerOutput)obj;
            if (this.outputName == null ? other.outputName != null : !this.outputName.equals(other.outputName)) {
                return false;
            }
            return !(this.outputType == null ? other.outputType != null : !this.outputType.equals(other.outputType));
        }
    }
}

