/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.logging.logback;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.ibm.mqlight.api.ClientRuntimeException;
import com.ibm.mqlight.api.impl.logging.LogMarker;
import com.ibm.mqlight.api.impl.logging.logback.TraceFilter;
import org.slf4j.Marker;

public class ArgsConverter
extends ClassicConverter {
    private static final String ARG_MAX_BYTES_ENVVAR = "MQLIGHT_JAVA_LOG_TRACE_ARG_MAX_BYTES";
    private static final int MAX_ARG_LENGTH;

    public String convert(ILoggingEvent event) {
        Marker marker = event.getMarker();
        Object[] args = event.getArgumentArray();
        int offset = TraceFilter.traceMarkerMap.containsKey(marker) ? 1 : 0;
        StringBuilder sb = new StringBuilder();
        if (args != null) {
            if (marker == LogMarker.EXIT.getValue()) {
                if (args.length > offset) {
                    String arg;
                    sb.append(" returns");
                    String string = arg = args[offset] == null ? null : args[offset].toString();
                    if (arg != null && arg.length() > MAX_ARG_LENGTH) {
                        arg = arg.substring(0, MAX_ARG_LENGTH) + "...";
                    }
                    sb.append(" [");
                    sb.append(arg);
                    sb.append("]");
                }
            } else {
                for (int i = offset; i < args.length; ++i) {
                    String arg;
                    String string = arg = args[i] == null ? null : args[i].toString();
                    if (arg != null && arg.length() > MAX_ARG_LENGTH) {
                        arg = arg.substring(0, MAX_ARG_LENGTH) + "...";
                    }
                    sb.append(" [");
                    sb.append(arg);
                    sb.append("]");
                }
            }
        }
        return sb.toString();
    }

    static {
        int max = 1024;
        String maxArgLengthStr = System.getProperty(ARG_MAX_BYTES_ENVVAR);
        if (maxArgLengthStr != null) {
            try {
                max = Integer.parseInt(maxArgLengthStr);
                if (max < 0) {
                    throw new ClientRuntimeException("Invalid MQLIGHT_JAVA_LOG_TRACE_ARG_MAX_BYTES setting. Value must be a positive integer.");
                }
            }
            catch (NumberFormatException e) {
                throw new ClientRuntimeException("Invalid MQLIGHT_JAVA_LOG_TRACE_ARG_MAX_BYTES setting. Value must be a positive integer.");
            }
        }
        MAX_ARG_LENGTH = max;
    }
}

