/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.logging;

import com.ibm.mqlight.api.impl.logging.FFDC;
import com.ibm.mqlight.api.impl.logging.LogMarker;
import com.ibm.mqlight.api.logging.FFDCProbeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class LoggerImpl
implements com.ibm.mqlight.api.logging.Logger {
    private final Logger logger;

    public LoggerImpl(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    public LoggerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setClientId(String clientId) {
        MDC.put((String)"clientid", (String)clientId);
    }

    @Override
    public void info(String message) {
        this.logger.info(LogMarker.INFO.getValue(), message);
    }

    @Override
    public void warning(String message) {
        this.logger.warn(LogMarker.WARNING.getValue(), message);
    }

    @Override
    public void error(String message) {
        this.logger.error(LogMarker.ERROR.getValue(), message);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.logger.error(LogMarker.ERROR.getValue(), message, throwable);
    }

    @Override
    public void entry(String methodName) {
        this.logger.trace(LogMarker.ENTRY.getValue(), methodName, null);
    }

    @Override
    public void entry(String methodName, Object ... objects) {
        if (this.logger.isTraceEnabled()) {
            Object[] objs = new Object[objects.length + 1];
            objs[0] = null;
            System.arraycopy(objects, 0, objs, 1, objects.length);
            this.logger.trace(LogMarker.ENTRY.getValue(), methodName, objs);
        }
    }

    @Override
    public void entry(Object source, String methodName) {
        this.logger.trace(LogMarker.ENTRY.getValue(), methodName, source);
    }

    @Override
    public void entry(Object source, String methodName, Object ... objects) {
        if (this.logger.isTraceEnabled()) {
            Object[] objs = new Object[objects.length + 1];
            objs[0] = source;
            System.arraycopy(objects, 0, objs, 1, objects.length);
            this.logger.trace(LogMarker.ENTRY.getValue(), methodName, objs);
        }
    }

    @Override
    public void exit(String methodName) {
        this.logger.trace(LogMarker.EXIT.getValue(), methodName, null);
    }

    @Override
    public void exit(String methodName, Object result) {
        this.logger.trace(LogMarker.EXIT.getValue(), methodName, null, result);
    }

    @Override
    public void exit(Object source, String methodName) {
        this.logger.trace(LogMarker.EXIT.getValue(), methodName, source);
    }

    @Override
    public void exit(Object source, String methodName, Object result) {
        this.logger.trace(LogMarker.EXIT.getValue(), methodName, source, result);
    }

    @Override
    public void data(String methodName) {
        this.logger.trace(LogMarker.DATA.getValue(), methodName, null);
    }

    @Override
    public void data(String methodName, Object ... objects) {
        if (this.logger.isTraceEnabled()) {
            Object[] objs = new Object[objects.length + 1];
            objs[0] = null;
            System.arraycopy(objects, 0, objs, 1, objects.length);
            this.logger.trace(LogMarker.DATA.getValue(), methodName, objs);
        }
    }

    @Override
    public void data(Object source, String methodName) {
        this.logger.trace(LogMarker.DATA.getValue(), methodName, source);
    }

    @Override
    public void data(Object source, String methodName, Object ... objects) {
        if (this.logger.isTraceEnabled()) {
            Object[] objs = new Object[objects.length + 1];
            objs[0] = source;
            System.arraycopy(objects, 0, objs, 1, objects.length);
            this.logger.trace(LogMarker.DATA.getValue(), methodName, objs);
        }
    }

    @Override
    public void throwing(String methodName, Throwable throwable) {
        this.logger.trace(LogMarker.THROWING.getValue(), methodName, null, (Object)throwable);
    }

    @Override
    public void throwing(Object source, String methodName, Throwable throwable) {
        this.logger.trace(LogMarker.THROWING.getValue(), methodName, source, (Object)throwable);
    }

    @Override
    public void ffdc(String methodName, FFDCProbeId probeId, Throwable throwable, Object ... data) {
        FFDC.capture(this.logger, methodName, probeId, throwable, data);
    }

    @Override
    public void ffdc(Object source, String methodName, FFDCProbeId probeId, Throwable throwable, Object ... data) {
        FFDC.capture(this.logger, source, methodName, probeId, throwable, data);
    }
}

