/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.logging;

import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

class Javacore {
    private static final Logger logger = LoggerFactory.getLogger(Javacore.class);
    private static String javacoreDirectoryPath;
    private static Method javaDumpMethod;
    private static final String endOfLineCharacter;

    Javacore() {
    }

    public static String generateJavaCore() throws Throwable {
        String filePath = javaDumpMethod != null ? Javacore.takeJavaCore() : Javacore.simulateJavaCore();
        return filePath;
    }

    private static String takeJavaCore() throws Throwable {
        String filePath;
        logger.entry("takeJavaCore");
        try {
            javaDumpMethod.invoke(null, new Object[0]);
            File javacoreFile = Javacore.getLatestJavacoreFile();
            filePath = javacoreFile.getAbsolutePath();
        }
        catch (InvocationTargetException invocationException) {
            throw invocationException.getTargetException() == null ? invocationException : invocationException.getTargetException();
        }
        logger.exit("takeJavaCore", (Object)filePath);
        return filePath;
    }

    private static File getLatestJavacoreFile() throws FileNotFoundException {
        logger.entry("getLatestJavacoreFilePath");
        File javacoreDirectory = new File(javacoreDirectoryPath);
        String[] javacoreFilePaths = javacoreDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("javacore.");
            }
        });
        String requiredJavacoreFilePath = "";
        if (javacoreFilePaths != null && javacoreFilePaths.length > 0) {
            requiredJavacoreFilePath = javacoreFilePaths[0];
            for (String filePath : javacoreFilePaths) {
                if (filePath.compareTo(requiredJavacoreFilePath) <= 0) continue;
                requiredJavacoreFilePath = filePath;
            }
        }
        if (requiredJavacoreFilePath.length() == 0) {
            FileNotFoundException exception = new FileNotFoundException("The javacore file has been generated but was not found in the expected directory: " + javacoreDirectory.getAbsolutePath());
            logger.throwing("getLatestJavacoreFilePath", exception);
            throw exception;
        }
        File result = new File(javacoreDirectory, requiredJavacoreFilePath);
        logger.exit("getLatestJavacoreFilePath", result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String simulateJavaCore() {
        logger.entry("simulateJavaCore");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd.kkmmss.SSS0.");
        String dateString = dateFormat.format(new Date());
        boolean unique = false;
        int counter = 1;
        String filename = "";
        while (!unique) {
            filename = "javacore." + dateString + String.format("%04d", counter) + ".txt";
            unique = !new File(filename).exists();
            ++counter;
        }
        StringBuilder sb = new StringBuilder("This JVM does not support com.ibm.jvm.Dump.JavaDump() method");
        sb.append(endOfLineCharacter);
        sb.append("This file was generated by WebSphere MQ Managed File Transfer");
        sb.append(endOfLineCharacter);
        sb.append(endOfLineCharacter);
        Map<Thread, StackTraceElement[]> threadToStackArrayMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadToStackArrayMap.entrySet()) {
            Thread thread = entry.getKey();
            sb.append("\"");
            sb.append(thread.getName());
            sb.append("\" ");
            sb.append("(id: ");
            sb.append(thread.getId());
            sb.append(", state: ");
            sb.append((Object)thread.getState());
            sb.append(") ");
            sb.append("priority=");
            sb.append(thread.getPriority());
            sb.append(", interrupted=");
            sb.append(thread.isInterrupted());
            sb.append(", daemon=");
            sb.append(thread.isDaemon());
            sb.append(endOfLineCharacter);
            for (StackTraceElement element : entry.getValue()) {
                sb.append("   at ");
                sb.append(element.getClassName());
                sb.append(".");
                sb.append(element.getMethodName());
                if (element.isNativeMethod()) {
                    sb.append("(Native Method)");
                } else {
                    sb.append("(");
                    sb.append(element.getFileName());
                    sb.append(":");
                    sb.append(element.getLineNumber());
                    sb.append(")");
                }
                sb.append(endOfLineCharacter);
            }
            sb.append(endOfLineCharacter);
        }
        sb.append("[EOF]");
        File outputFile = new File(filename);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            out.write(sb.toString().getBytes("UTF-8"));
        }
        catch (IOException ioException) {
            logger.error("Unable to generate diagnostic information: " + ioException.getLocalizedMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        logger.exit("simulateJavaCore", (Object)outputFile.getAbsolutePath());
        return outputFile.getAbsolutePath();
    }

    static {
        boolean isZOS = System.getProperty("os.name", "").equalsIgnoreCase("OS/390") || System.getProperty("os.name", "").equalsIgnoreCase("z/OS");
        String alternativeJavacoreDirectoryPath = isZOS ? System.getenv("_CEE_DMPTARG") : System.getenv("IBM_JAVACOREDIR");
        javacoreDirectoryPath = alternativeJavacoreDirectoryPath != null ? alternativeJavacoreDirectoryPath : System.getProperty("user.dir", "");
        endOfLineCharacter = System.getProperty("line.separator");
        logger.data("<clinit>");
        try {
            Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
            javaDumpMethod = dumpClass.getMethod("JavaDump", new Class[0]);
        }
        catch (Exception exception) {
            logger.data((Object)"<clinit>", "Can't load com.ibm.jvm.Dump");
        }
    }
}

