/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.engine;

import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.engine.CloseRequest;
import com.ibm.mqlight.api.impl.engine.Engine;
import com.ibm.mqlight.api.impl.engine.OpenRequest;
import com.ibm.mqlight.api.impl.engine.SendRequest;
import com.ibm.mqlight.api.impl.engine.SendResponse;
import com.ibm.mqlight.api.impl.timer.TimerPromiseImpl;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import com.ibm.mqlight.api.network.NetworkChannel;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;

public class EngineConnection {
    private static final Logger logger = LoggerFactory.getLogger(EngineConnection.class);
    protected final Connection connection;
    protected final Session session;
    protected final Component requestor;
    protected final LinkedList<PendingQos0Response> inflightQos0 = new LinkedList();
    protected final Transport transport;
    protected final Collector collector;
    protected final NetworkChannel channel;
    protected long deliveryTag = 0L;
    protected final HashMap<Delivery, SendRequest> inProgressOutboundDeliveries = new HashMap();
    protected final HashMap<String, SubscriptionData> subscriptionData = new HashMap();
    protected OpenRequest openRequest = null;
    protected CloseRequest closeRequest = null;
    protected TimerPromiseImpl timerPromise = null;
    protected boolean closed = false;
    protected boolean drained = true;
    protected long bytesWritten = 0L;

    protected void addInflightQos0(int delta, SendResponse response, Component component, Engine engine) {
        String methodName = "addInflightQos0";
        logger.entry(this, "addInflightQos0", delta, response, component, engine);
        this.inflightQos0.addLast(new PendingQos0Response(this.bytesWritten + (long)delta, response, component, engine));
        logger.exit(this, "addInflightQos0");
    }

    protected void notifyInflightQos0(boolean purge) {
        String methodName = "notifyInflightQos0";
        logger.entry(this, "notifyInflightQos0", purge);
        while (!this.inflightQos0.isEmpty()) {
            PendingQos0Response pendingResponse = this.inflightQos0.getFirst();
            if (!purge && pendingResponse.amount > this.bytesWritten) break;
            this.inflightQos0.removeFirst();
            pendingResponse.component.tell(pendingResponse.response, pendingResponse.engine);
        }
        logger.exit(this, "notifyInflightQos0");
    }

    protected EngineConnection(Connection connection, Session session, Component requestor, Transport transport, Collector collector, NetworkChannel channel) {
        String methodName = "<init>";
        logger.entry(this, "<init>", connection, session, requestor, transport, collector, channel);
        this.connection = connection;
        this.session = session;
        this.requestor = requestor;
        this.transport = transport;
        this.collector = collector;
        this.channel = channel;
        logger.exit(this, "<init>");
    }

    public EngineConnection() {
        String methodName = "<init>";
        logger.entry(this, "<init>");
        this.requestor = null;
        this.session = null;
        this.channel = null;
        this.connection = null;
        this.collector = null;
        this.transport = null;
        logger.exit(this, "<init>");
    }

    protected static class SubscriptionData {
        private static final Logger logger = LoggerFactory.getLogger(SubscriptionData.class);
        protected final Component subscriber;
        protected final int maxLinkCredit;
        protected final Receiver receiver;
        protected int unsettled;
        protected int settled;

        protected SubscriptionData(Component subscriber, int maxLinkCredit, Receiver receiver) {
            String methodName = "<init>";
            logger.entry(this, "<init>", subscriber, subscriber, receiver);
            this.subscriber = subscriber;
            this.maxLinkCredit = maxLinkCredit;
            this.receiver = receiver;
            this.unsettled = 0;
            this.settled = 0;
            logger.exit(this, "<init>");
        }
    }

    protected static class PendingQos0Response {
        private static final Logger logger = LoggerFactory.getLogger(PendingQos0Response.class);
        long amount;
        SendResponse response;
        Component component;
        Engine engine;

        protected PendingQos0Response(long amount, SendResponse response, Component component, Engine engine) {
            String methodName = "<init>";
            logger.entry(this, "<init>", amount, response, component, engine);
            this.amount = amount;
            this.response = response;
            this.component = component;
            this.engine = engine;
            logger.exit(this, "<init>");
        }
    }
}

