/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.endpoint;

import com.ibm.mqlight.api.ClientOptions;
import com.ibm.mqlight.api.endpoint.Endpoint;
import com.ibm.mqlight.api.endpoint.EndpointPromise;
import com.ibm.mqlight.api.impl.LogbackLogging;
import com.ibm.mqlight.api.impl.endpoint.EndpointImpl;
import com.ibm.mqlight.api.impl.endpoint.EndpointServiceImpl;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;

public class SingleEndpointService
extends EndpointServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(SingleEndpointService.class);
    private final Endpoint endpoint;
    boolean exhausted = false;
    int retryCount = 0;

    @Override
    public void lookup(EndpointPromise future) {
        String methodName = "lookup";
        logger.entry(this, "lookup", future);
        if (this.exhausted) {
            this.exhausted = false;
            future.setWait(this.calculateDelay(this.retryCount++));
        } else {
            this.exhausted = true;
            future.setSuccess(this.endpoint);
        }
        logger.exit(this, "lookup");
    }

    @Override
    public void onSuccess(Endpoint endpoint) {
        String methodName = "onSuccess";
        logger.entry(this, "onSuccess", endpoint);
        this.exhausted = false;
        this.retryCount = 0;
        logger.exit(this, "onSuccess");
    }

    public SingleEndpointService(String uri, String user, String password, ClientOptions.SSLOptions sslOptions) {
        String methodName = "<init>";
        logger.entry(this, "<init>", uri, user, "******", sslOptions);
        this.endpoint = new EndpointImpl(uri, user, password, sslOptions);
        logger.exit(this, "<init>");
    }

    static {
        LogbackLogging.setup();
    }
}

