/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl.endpoint;

import com.ibm.mqlight.api.ClientException;
import com.ibm.mqlight.api.endpoint.Endpoint;
import com.ibm.mqlight.api.endpoint.EndpointPromise;
import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.ComponentImpl;
import com.ibm.mqlight.api.impl.endpoint.EndpointResponse;
import com.ibm.mqlight.api.impl.endpoint.ExhaustedResponse;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class EndpointPromiseImpl
implements EndpointPromise {
    private static final Logger logger = LoggerFactory.getLogger(EndpointPromiseImpl.class);
    private final AtomicBoolean complete = new AtomicBoolean(false);
    private final Component component;

    public EndpointPromiseImpl(Component component) {
        String methodName = "<init>";
        logger.entry(this, "<init>", component);
        this.component = component;
        logger.exit(this, "<init>");
    }

    @Override
    public boolean isComplete() {
        return this.complete.get();
    }

    @Override
    public void setSuccess(Endpoint endpoint) throws IllegalStateException {
        String methodName = "setSuccess";
        logger.entry(this, "setSuccess", endpoint);
        if (this.complete.getAndSet(true)) {
            IllegalStateException exception = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setSuccess", exception);
            throw exception;
        }
        this.component.tell(new EndpointResponse(endpoint, null), ComponentImpl.NOBODY);
        logger.exit(this, "setSuccess");
    }

    @Override
    public void setWait(long delay) throws IllegalStateException {
        String methodName = "setWait";
        logger.entry(this, "setWait", delay);
        if (this.complete.getAndSet(true)) {
            IllegalStateException exception = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setWait", exception);
            throw exception;
        }
        this.component.tell(new ExhaustedResponse(delay), ComponentImpl.NOBODY);
        logger.exit(this, "setWait");
    }

    @Override
    public void setFailure(Exception exception) throws IllegalStateException {
        ClientException clientException;
        String methodName = "setFailure";
        logger.entry(this, "setFailure", exception);
        if (this.complete.getAndSet(true)) {
            IllegalStateException ex = new IllegalStateException("Promise already completed");
            logger.throwing(this, "setFailure", ex);
            throw ex;
        }
        if (exception instanceof ClientException) {
            clientException = (ClientException)exception;
        } else {
            clientException = new ClientException("A problem occurred when trying to locate an instance of the MQ Light server.  See linked exception for more details", exception);
            logger.data(this, "setFailure", clientException);
        }
        this.component.tell(new EndpointResponse(null, clientException), ComponentImpl.NOBODY);
        logger.exit(this, "setFailure");
    }
}

