/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.ibm.mqlight.api.Delivery;
import com.ibm.mqlight.api.JsonDelivery;
import com.ibm.mqlight.api.QOS;
import com.ibm.mqlight.api.impl.DeliveryImpl;
import com.ibm.mqlight.api.impl.NonBlockingClientImpl;
import com.ibm.mqlight.api.impl.engine.DeliveryRequest;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.lang.reflect.Type;
import java.util.Map;

public class JsonDeliveryImpl
extends DeliveryImpl
implements JsonDelivery {
    private static final Logger logger = LoggerFactory.getLogger(JsonDeliveryImpl.class);
    private final String jsonString;
    private final GsonBuilder gsonBuilder;
    private Gson gson;
    private JsonParser jsonParser;

    protected JsonDeliveryImpl(NonBlockingClientImpl client, QOS qos, String share, String topic, String topicPattern, long ttl, String data, GsonBuilder gsonBuilder, Map<String, Object> properties, DeliveryRequest deliveryRequest) {
        super(client, qos, share, topic, topicPattern, ttl, properties, deliveryRequest);
        String methodName = "<init>";
        logger.entry(this, "<init>", new Object[]{client, qos, share, topic, topicPattern, ttl, data, gsonBuilder, properties, deliveryRequest});
        this.jsonString = data;
        this.gsonBuilder = gsonBuilder;
        logger.exit(this, "<init>");
    }

    private void init() {
        if (this.gson == null) {
            this.gson = this.gsonBuilder.create();
        }
    }

    @Override
    public synchronized <T> T getData(Class<T> classOfT) throws JsonSyntaxException {
        this.init();
        return (T)this.gson.fromJson(this.jsonString, classOfT);
    }

    @Override
    public <T> T getData(Type typeOfT) throws JsonSyntaxException {
        this.init();
        return (T)this.gson.fromJson(this.jsonString, typeOfT);
    }

    @Override
    public synchronized JsonElement getData() throws JsonSyntaxException {
        if (this.jsonParser == null) {
            this.jsonParser = new JsonParser();
        }
        return this.jsonParser.parse(this.jsonString);
    }

    @Override
    public String getRawData() {
        return this.jsonString;
    }

    @Override
    public Delivery.Type getType() {
        return Delivery.Type.JSON;
    }
}

