/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api.impl;

import com.ibm.mqlight.api.impl.Component;
import com.ibm.mqlight.api.impl.Message;
import com.ibm.mqlight.api.logging.FFDCProbeId;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;
import java.util.LinkedList;

public abstract class ComponentImpl
implements Component {
    private static final Logger logger = LoggerFactory.getLogger(ComponentImpl.class);
    public static final ComponentImpl NOBODY = new ComponentImpl(){

        @Override
        public void tell(Message message, Component self) {
        }

        @Override
        protected void onReceive(Message message) {
            logger.data(this, "tell", message);
        }
    };
    private final LinkedList<Message> queue = new LinkedList();
    private boolean scheduled = false;
    protected final Object componentMonitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tell(Message message, Component self) {
        boolean execute;
        String methodName = "tell";
        logger.entry(this, "tell", message, self);
        message.setSender(self);
        LinkedList<Message> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.addLast(message);
            boolean bl = execute = !this.scheduled;
            if (execute) {
                this.scheduled = true;
            }
        }
        if (execute) {
            this.deliverMessages();
        }
        logger.exit(this, "tell");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverMessages() {
        String methodName = "deliverMessages";
        logger.entry(this, "deliverMessages");
        while (true) {
            Message message = null;
            Object object = this.queue;
            synchronized (object) {
                if (this.queue.isEmpty()) {
                    this.scheduled = false;
                    break;
                }
                message = this.queue.removeFirst();
            }
            object = this.componentMonitor;
            synchronized (object) {
                try {
                    this.onReceive(message);
                }
                catch (Throwable e) {
                    logger.ffdc("deliverMessages", FFDCProbeId.PROBE_001, e, new Object[0]);
                }
            }
        }
        logger.exit(this, "deliverMessages");
    }

    protected abstract void onReceive(Message var1);
}

