/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api;

import com.ibm.mqlight.api.QOS;
import com.ibm.mqlight.api.logging.Logger;
import com.ibm.mqlight.api.logging.LoggerFactory;

public class SendOptions {
    private static final Logger logger = LoggerFactory.getLogger(SendOptions.class);
    private final QOS qos;
    private final long ttl;
    private final boolean retainLink;

    private SendOptions(QOS qos, long ttl, boolean retainLink) {
        String methodName = "<init>";
        logger.entry(this, "<init>", new Object[]{qos, ttl});
        this.qos = qos;
        this.ttl = ttl;
        this.retainLink = retainLink;
        logger.exit(this, "<init>");
    }

    public final QOS getQos() {
        return this.qos;
    }

    public final long getTtl() {
        return this.ttl;
    }

    public final boolean getRetainLink() {
        return this.retainLink;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" [qos=").append((Object)this.qos).append(", ttl=").append(this.ttl).append(", retainLink=").append(this.retainLink).append("]");
        return sb.toString();
    }

    public static SendOptionsBuilder builder() {
        return new SendOptionsBuilder();
    }

    public static class SendOptionsBuilder {
        private QOS qos = QOS.AT_MOST_ONCE;
        private long ttl = 0L;
        private boolean retainLink = true;

        private SendOptionsBuilder() {
        }

        public SendOptionsBuilder setQos(QOS qos) throws IllegalArgumentException {
            String methodName = "setQos";
            logger.entry(this, "setQos", new Object[]{qos});
            if (qos == null) {
                IllegalArgumentException exception = new IllegalArgumentException("qos argument cannot be null");
                logger.throwing(this, "setQos", exception);
                throw exception;
            }
            this.qos = qos;
            logger.exit(this, "setQos", this);
            return this;
        }

        public SendOptionsBuilder setTtl(long ttl) throws IllegalArgumentException {
            String methodName = "setTtl";
            logger.entry(this, "setTtl", ttl);
            if (ttl < 1L || ttl > 0xFFFFFFFFL) {
                IllegalArgumentException exception = new IllegalArgumentException("ttl value '" + ttl + "' is invalid, must be an unsigned non-zero integer number");
                logger.throwing(this, "setTtl", exception);
                throw exception;
            }
            this.ttl = ttl;
            logger.exit(this, "setTtl", this);
            return this;
        }

        public SendOptionsBuilder setRetainLink(boolean retainLink) {
            String methodName = "setRetainLink";
            logger.entry(this, "setRetainLink", retainLink);
            this.retainLink = retainLink;
            logger.exit(this, "setRetainLink", this);
            return this;
        }

        public SendOptions build() {
            return new SendOptions(this.qos, this.ttl, this.retainLink);
        }
    }
}

