/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mqlight.api;

import com.google.gson.GsonBuilder;
import com.ibm.mqlight.api.ClientOptions;
import com.ibm.mqlight.api.ClientState;
import com.ibm.mqlight.api.CompletionListener;
import com.ibm.mqlight.api.DestinationListener;
import com.ibm.mqlight.api.NonBlockingClientListener;
import com.ibm.mqlight.api.SendOptions;
import com.ibm.mqlight.api.StartingException;
import com.ibm.mqlight.api.StoppedException;
import com.ibm.mqlight.api.SubscribeOptions;
import com.ibm.mqlight.api.SubscribedException;
import com.ibm.mqlight.api.UnsubscribedException;
import com.ibm.mqlight.api.callback.CallbackService;
import com.ibm.mqlight.api.endpoint.EndpointService;
import com.ibm.mqlight.api.impl.NonBlockingClientImpl;
import com.ibm.mqlight.api.network.NetworkService;
import com.ibm.mqlight.api.timer.TimerService;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Map;

public abstract class NonBlockingClient {
    protected static final ClientOptions defaultClientOptions = ClientOptions.builder().build();
    protected static final SendOptions defaultSendOptions = SendOptions.builder().build();
    protected static final SubscribeOptions defaultSubscribeOptions = SubscribeOptions.builder().build();

    public static <T> NonBlockingClient create(String service, ClientOptions options, NonBlockingClientListener<T> listener, T context) throws IllegalArgumentException {
        return new NonBlockingClientImpl(service, options, listener, context);
    }

    public static <T> NonBlockingClient create(EndpointService endpointService, CallbackService callbackService, NetworkService networkService, TimerService timerService, GsonBuilder gsonBuilder, ClientOptions options, NonBlockingClientListener<T> listener, T context) throws IllegalArgumentException {
        return new NonBlockingClientImpl(endpointService, callbackService, networkService, timerService, gsonBuilder, options, listener, context);
    }

    public static <T> NonBlockingClient create(String service, NonBlockingClientListener<T> listener, T context) {
        return NonBlockingClient.create(service, defaultClientOptions, listener, context);
    }

    public abstract String getId();

    public abstract String getService();

    public abstract ClientState getState();

    public abstract <T> boolean send(String var1, String var2, Map<String, Object> var3, SendOptions var4, CompletionListener<T> var5, T var6) throws StoppedException, IllegalArgumentException;

    public abstract <T> boolean send(String var1, ByteBuffer var2, Map<String, Object> var3, SendOptions var4, CompletionListener<T> var5, T var6) throws StoppedException, IllegalArgumentException;

    public abstract <T> boolean send(String var1, Object var2, Map<String, Object> var3, SendOptions var4, CompletionListener<T> var5, T var6) throws StoppedException, IllegalArgumentException;

    public abstract <T> boolean send(String var1, Object var2, Type var3, Map<String, Object> var4, SendOptions var5, CompletionListener<T> var6, T var7) throws StoppedException, IllegalArgumentException;

    public abstract <T> boolean sendJson(String var1, String var2, Map<String, Object> var3, SendOptions var4, CompletionListener<T> var5, T var6) throws StoppedException, IllegalArgumentException;

    public <T> boolean send(String topic, String data, Map<String, Object> properties, CompletionListener<T> listener, T context) throws StoppedException, IllegalArgumentException {
        return this.send(topic, data, properties, defaultSendOptions, listener, context);
    }

    public <T> boolean send(String topic, ByteBuffer data, Map<String, Object> properties, CompletionListener<T> listener, T context) throws StoppedException, IllegalArgumentException {
        return this.send(topic, data, properties, defaultSendOptions, listener, context);
    }

    public <T> boolean send(String topic, Object json, Map<String, Object> properties, CompletionListener<T> listener, T context) throws StoppedException, IllegalArgumentException {
        return this.send(topic, json, properties, defaultSendOptions, listener, context);
    }

    public <T> boolean send(String topic, Object json, Type type, Map<String, Object> properties, CompletionListener<T> listener, T context) throws StoppedException, IllegalArgumentException {
        return this.send(topic, json, type, properties, defaultSendOptions, listener, context);
    }

    public <T> boolean sendJson(String topic, String json, Map<String, Object> properties, CompletionListener<T> listener, T context) throws StoppedException, IllegalArgumentException {
        return this.sendJson(topic, json, properties, defaultSendOptions, listener, context);
    }

    public boolean send(String topic, String data, Map<String, Object> properties) throws StoppedException, IllegalArgumentException {
        return this.send(topic, data, properties, defaultSendOptions, null, null);
    }

    public boolean send(String topic, ByteBuffer data, Map<String, Object> properties) throws StoppedException, IllegalArgumentException {
        return this.send(topic, data, properties, defaultSendOptions, null, null);
    }

    public boolean send(String topic, Object json, Map<String, Object> properties) throws StoppedException, IllegalArgumentException {
        return this.send(topic, json, properties, defaultSendOptions, null, null);
    }

    public boolean send(String topic, Object json, Type type, Map<String, Object> properties) throws StoppedException, IllegalArgumentException {
        return this.send(topic, json, type, properties, defaultSendOptions, null, null);
    }

    public boolean sendJson(String topic, String json, Map<String, Object> properties) throws StoppedException, IllegalArgumentException {
        return this.sendJson(topic, json, properties, defaultSendOptions, null, null);
    }

    public abstract <T> NonBlockingClient start(CompletionListener<T> var1, T var2) throws StoppedException;

    public abstract <T> void stop(CompletionListener<T> var1, T var2) throws StartingException;

    public abstract <T> NonBlockingClient subscribe(String var1, SubscribeOptions var2, DestinationListener<T> var3, CompletionListener<T> var4, T var5) throws SubscribedException, StoppedException, IllegalArgumentException;

    public <T> NonBlockingClient subscribe(String topicPattern, DestinationListener<T> destListener, CompletionListener<T> compListener, T context) throws SubscribedException, StoppedException, IllegalArgumentException {
        return this.subscribe(topicPattern, defaultSubscribeOptions, destListener, compListener, context);
    }

    public abstract <T> NonBlockingClient unsubscribe(String var1, String var2, int var3, CompletionListener<T> var4, T var5) throws UnsubscribedException, StoppedException, IllegalArgumentException;

    public <T> NonBlockingClient unsubscribe(String topicPattern, int ttl, CompletionListener<T> listener, T context) throws UnsubscribedException, StoppedException, IllegalArgumentException {
        return this.unsubscribe(topicPattern, null, ttl, listener, context);
    }

    public abstract <T> NonBlockingClient unsubscribe(String var1, String var2, CompletionListener<T> var3, T var4) throws UnsubscribedException, StoppedException, IllegalArgumentException;

    public <T> NonBlockingClient unsubscribe(String topicPattern, CompletionListener<T> listener, T context) throws UnsubscribedException, StoppedException, IllegalArgumentException {
        return this.unsubscribe(topicPattern, null, listener, context);
    }
}

