package com.murgupluoglu.flagkit

/*
*  Created by Mustafa Ürgüplüoğlu on 06.01.2021.
*  Copyright © 2021 Mustafa Ürgüplüoğlu. All rights reserved.
*/

object FlagKit {

    fun getResId(flagName: String): Int {
        return getAllAvailableCodes().firstOrNull {
            it.alpha2Code.equals(
                flagName,
                true
            )
        }?.resourceId ?: R.drawable.unknown_flag
    }

    fun getAllAvailableCodes(): List<FlagModel> {
        return listOf(
            FlagModel("ad", R.drawable.ad_flag),
            FlagModel("ae", R.drawable.ae_flag),
            FlagModel("af", R.drawable.af_flag),
            FlagModel("ag", R.drawable.ag_flag),
            FlagModel("ai", R.drawable.ai_flag),
            FlagModel("al", R.drawable.al_flag),
            FlagModel("am", R.drawable.am_flag),
            FlagModel("ao", R.drawable.ao_flag),
            FlagModel("ar", R.drawable.ar_flag),
            FlagModel("as", R.drawable.as_flag),
            FlagModel("at", R.drawable.at_flag),
            FlagModel("au", R.drawable.au_flag),
            FlagModel("aw", R.drawable.aw_flag),
            FlagModel("ax", R.drawable.ax_flag),
            FlagModel("az", R.drawable.az_flag),
            FlagModel("ba", R.drawable.ba_flag),
            FlagModel("bb", R.drawable.bb_flag),
            FlagModel("bd", R.drawable.bd_flag),
            FlagModel("be", R.drawable.be_flag),
            FlagModel("bf", R.drawable.bf_flag),
            FlagModel("bg", R.drawable.bg_flag),
            FlagModel("bh", R.drawable.bh_flag),
            FlagModel("bi", R.drawable.bi_flag),
            FlagModel("bj", R.drawable.bj_flag),
            FlagModel("bl", R.drawable.bl_flag),
            FlagModel("bm", R.drawable.bm_flag),
            FlagModel("bn", R.drawable.bn_flag),
            FlagModel("bo", R.drawable.bo_flag),
            FlagModel("br", R.drawable.br_flag),
            FlagModel("bs", R.drawable.bs_flag),
            FlagModel("bt", R.drawable.bt_flag),
            FlagModel("bv", R.drawable.bv_flag),
            FlagModel("bw", R.drawable.bw_flag),
            FlagModel("by", R.drawable.by_flag),
            FlagModel("bz", R.drawable.bz_flag),
            FlagModel("ca", R.drawable.ca_flag),
            FlagModel("cc", R.drawable.cc_flag),
            FlagModel("cd", R.drawable.cd_flag),
            FlagModel("cf", R.drawable.cf_flag),
            FlagModel("cg", R.drawable.cg_flag),
            FlagModel("ch", R.drawable.ch_flag),
            FlagModel("ci", R.drawable.ci_flag),
            FlagModel("ck", R.drawable.ck_flag),
            FlagModel("cl", R.drawable.cl_flag),
            FlagModel("cm", R.drawable.cm_flag),
            FlagModel("cn", R.drawable.cn_flag),
            FlagModel("co", R.drawable.co_flag),
            FlagModel("cr", R.drawable.cr_flag),
            FlagModel("cu", R.drawable.cu_flag),
            FlagModel("cv", R.drawable.cv_flag),
            FlagModel("cw", R.drawable.cw_flag),
            FlagModel("cx", R.drawable.cx_flag),
            FlagModel("cy", R.drawable.cy_flag),
            FlagModel("cz", R.drawable.cz_flag),
            FlagModel("de", R.drawable.de_flag),
            FlagModel("dj", R.drawable.dj_flag),
            FlagModel("dk", R.drawable.dk_flag),
            FlagModel("dm", R.drawable.dm_flag),
            FlagModel("do", R.drawable.do_flag),
            FlagModel("dz", R.drawable.dz_flag),
            FlagModel("ec", R.drawable.ec_flag),
            FlagModel("ee", R.drawable.ee_flag),
            FlagModel("eg", R.drawable.eg_flag),
            FlagModel("er", R.drawable.er_flag),
            FlagModel("es", R.drawable.es_flag),
            FlagModel("et", R.drawable.et_flag),
            FlagModel("eu", R.drawable.eu_flag),
            FlagModel("fi", R.drawable.fi_flag),
            FlagModel("fj", R.drawable.fj_flag),
            FlagModel("fk", R.drawable.fk_flag),
            FlagModel("fm", R.drawable.fm_flag),
            FlagModel("fo", R.drawable.fo_flag),
            FlagModel("fr", R.drawable.fr_flag),
            FlagModel("ga", R.drawable.ga_flag),
            FlagModel("gb", R.drawable.gb_flag),
            FlagModel("gb_eng", R.drawable.gb_eng_flag),
            FlagModel("gb_nir", R.drawable.gb_nir_flag),
            FlagModel("gb_sct", R.drawable.gb_sct_flag),
            FlagModel("gb_wls", R.drawable.gb_wls_flag),
            FlagModel("gb_zet", R.drawable.gb_zet_flag),
            FlagModel("gd", R.drawable.gd_flag),
            FlagModel("ge", R.drawable.ge_flag),
            FlagModel("gf", R.drawable.gf_flag),
            FlagModel("gg", R.drawable.gg_flag),
            FlagModel("gh", R.drawable.gh_flag),
            FlagModel("gi", R.drawable.gi_flag),
            FlagModel("gl", R.drawable.gl_flag),
            FlagModel("gm", R.drawable.gm_flag),
            FlagModel("gn", R.drawable.gn_flag),
            FlagModel("gp", R.drawable.gp_flag),
            FlagModel("gq", R.drawable.gq_flag),
            FlagModel("gr", R.drawable.gr_flag),
            FlagModel("gs", R.drawable.gs_flag),
            FlagModel("gt", R.drawable.gt_flag),
            FlagModel("gu", R.drawable.gu_flag),
            FlagModel("gw", R.drawable.gw_flag),
            FlagModel("gy", R.drawable.gy_flag),
            FlagModel("hk", R.drawable.hk_flag),
            FlagModel("hm", R.drawable.hm_flag),
            FlagModel("hn", R.drawable.hn_flag),
            FlagModel("hr", R.drawable.hr_flag),
            FlagModel("ht", R.drawable.ht_flag),
            FlagModel("hu", R.drawable.hu_flag),
            FlagModel("id", R.drawable.id_flag),
            FlagModel("ie", R.drawable.ie_flag),
            FlagModel("il", R.drawable.il_flag),
            FlagModel("im", R.drawable.im_flag),
            FlagModel("in", R.drawable.in_flag),
            FlagModel("io", R.drawable.io_flag),
            FlagModel("iq", R.drawable.iq_flag),
            FlagModel("ir", R.drawable.ir_flag),
            FlagModel("is", R.drawable.is_flag),
            FlagModel("it", R.drawable.it_flag),
            FlagModel("je", R.drawable.je_flag),
            FlagModel("jm", R.drawable.jm_flag),
            FlagModel("jo", R.drawable.jo_flag),
            FlagModel("jp", R.drawable.jp_flag),
            FlagModel("ke", R.drawable.ke_flag),
            FlagModel("kg", R.drawable.kg_flag),
            FlagModel("kh", R.drawable.kh_flag),
            FlagModel("ki", R.drawable.ki_flag),
            FlagModel("km", R.drawable.km_flag),
            FlagModel("kn", R.drawable.kn_flag),
            FlagModel("kp", R.drawable.kp_flag),
            FlagModel("kr", R.drawable.kr_flag),
            FlagModel("kw", R.drawable.kw_flag),
            FlagModel("ky", R.drawable.ky_flag),
            FlagModel("kz", R.drawable.kz_flag),
            FlagModel("la", R.drawable.la_flag),
            FlagModel("lb", R.drawable.lb_flag),
            FlagModel("lc", R.drawable.lc_flag),
            FlagModel("li", R.drawable.li_flag),
            FlagModel("lk", R.drawable.lk_flag),
            FlagModel("lr", R.drawable.lr_flag),
            FlagModel("ls", R.drawable.ls_flag),
            FlagModel("lt", R.drawable.lt_flag),
            FlagModel("lu", R.drawable.lu_flag),
            FlagModel("lv", R.drawable.lv_flag),
            FlagModel("ly", R.drawable.ly_flag),
            FlagModel("ma", R.drawable.ma_flag),
            FlagModel("mc", R.drawable.mc_flag),
            FlagModel("md", R.drawable.md_flag),
            FlagModel("me", R.drawable.me_flag),
            FlagModel("mf", R.drawable.mf_flag),
            FlagModel("mg", R.drawable.mg_flag),
            FlagModel("mh", R.drawable.mh_flag),
            FlagModel("mk", R.drawable.mk_flag),
            FlagModel("ml", R.drawable.ml_flag),
            FlagModel("mm", R.drawable.mm_flag),
            FlagModel("mn", R.drawable.mn_flag),
            FlagModel("mo", R.drawable.mo_flag),
            FlagModel("mp", R.drawable.mp_flag),
            FlagModel("mq", R.drawable.mq_flag),
            FlagModel("mr", R.drawable.mr_flag),
            FlagModel("ms", R.drawable.ms_flag),
            FlagModel("mt", R.drawable.mt_flag),
            FlagModel("mu", R.drawable.mu_flag),
            FlagModel("mv", R.drawable.mv_flag),
            FlagModel("mw", R.drawable.mw_flag),
            FlagModel("mx", R.drawable.mx_flag),
            FlagModel("my", R.drawable.my_flag),
            FlagModel("mz", R.drawable.mz_flag),
            FlagModel("na", R.drawable.na_flag),
            FlagModel("nc", R.drawable.nc_flag),
            FlagModel("ne", R.drawable.ne_flag),
            FlagModel("nf", R.drawable.nf_flag),
            FlagModel("ng", R.drawable.ng_flag),
            FlagModel("ni", R.drawable.ni_flag),
            FlagModel("nl", R.drawable.nl_flag),
            FlagModel("no", R.drawable.no_flag),
            FlagModel("np", R.drawable.np_flag),
            FlagModel("nr", R.drawable.nr_flag),
            FlagModel("nu", R.drawable.nu_flag),
            FlagModel("nz", R.drawable.nz_flag),
            FlagModel("om", R.drawable.om_flag),
            FlagModel("pa", R.drawable.pa_flag),
            FlagModel("pe", R.drawable.pe_flag),
            FlagModel("pf", R.drawable.pf_flag),
            FlagModel("pg", R.drawable.pg_flag),
            FlagModel("ph", R.drawable.ph_flag),
            FlagModel("pk", R.drawable.pk_flag),
            FlagModel("pl", R.drawable.pl_flag),
            FlagModel("pm", R.drawable.pm_flag),
            FlagModel("pn", R.drawable.pn_flag),
            FlagModel("pr", R.drawable.pr_flag),
            FlagModel("ps", R.drawable.ps_flag),
            FlagModel("pt", R.drawable.pt_flag),
            FlagModel("pw", R.drawable.pw_flag),
            FlagModel("py", R.drawable.py_flag),
            FlagModel("qa", R.drawable.qa_flag),
            FlagModel("re", R.drawable.re_flag),
            FlagModel("ro", R.drawable.ro_flag),
            FlagModel("rs", R.drawable.rs_flag),
            FlagModel("ru", R.drawable.ru_flag),
            FlagModel("rw", R.drawable.rw_flag),
            FlagModel("sa", R.drawable.sa_flag),
            FlagModel("sb", R.drawable.sb_flag),
            FlagModel("sc", R.drawable.sc_flag),
            FlagModel("sd", R.drawable.sd_flag),
            FlagModel("se", R.drawable.se_flag),
            FlagModel("sg", R.drawable.sg_flag),
            FlagModel("sh", R.drawable.sh_flag),
            FlagModel("si", R.drawable.si_flag),
            FlagModel("sj", R.drawable.sj_flag),
            FlagModel("sk", R.drawable.sk_flag),
            FlagModel("sl", R.drawable.sl_flag),
            FlagModel("sm", R.drawable.sm_flag),
            FlagModel("sn", R.drawable.sn_flag),
            FlagModel("so", R.drawable.so_flag),
            FlagModel("sr", R.drawable.sr_flag),
            FlagModel("ss", R.drawable.ss_flag),
            FlagModel("st", R.drawable.st_flag),
            FlagModel("sv", R.drawable.sv_flag),
            FlagModel("sx", R.drawable.sx_flag),
            FlagModel("sy", R.drawable.sy_flag),
            FlagModel("sz", R.drawable.sz_flag),
            FlagModel("tc", R.drawable.tc_flag),
            FlagModel("td", R.drawable.td_flag),
            FlagModel("tf", R.drawable.tf_flag),
            FlagModel("tg", R.drawable.tg_flag),
            FlagModel("th", R.drawable.th_flag),
            FlagModel("tj", R.drawable.tj_flag),
            FlagModel("tk", R.drawable.tk_flag),
            FlagModel("tl", R.drawable.tl_flag),
            FlagModel("tm", R.drawable.tm_flag),
            FlagModel("tn", R.drawable.tn_flag),
            FlagModel("to", R.drawable.to_flag),
            FlagModel("tr", R.drawable.tr_flag),
            FlagModel("tt", R.drawable.tt_flag),
            FlagModel("tv", R.drawable.tv_flag),
            FlagModel("tw", R.drawable.tw_flag),
            FlagModel("tz", R.drawable.tz_flag),
            FlagModel("ua", R.drawable.ua_flag),
            FlagModel("ug", R.drawable.ug_flag),
            FlagModel("um", R.drawable.um_flag),
            FlagModel("us", R.drawable.us_flag),
            FlagModel("us_ca", R.drawable.us_ca_flag),
            FlagModel("uy", R.drawable.uy_flag),
            FlagModel("uz", R.drawable.uz_flag),
            FlagModel("va", R.drawable.va_flag),
            FlagModel("vc", R.drawable.vc_flag),
            FlagModel("ve", R.drawable.ve_flag),
            FlagModel("vg", R.drawable.vg_flag),
            FlagModel("vi", R.drawable.vi_flag),
            FlagModel("vn", R.drawable.vn_flag),
            FlagModel("vu", R.drawable.vu_flag),
            FlagModel("wf", R.drawable.wf_flag),
            FlagModel("ws", R.drawable.ws_flag),
            FlagModel("xk", R.drawable.xk_flag),
            FlagModel("ye", R.drawable.ye_flag),
            FlagModel("yt", R.drawable.yt_flag),
            FlagModel("za", R.drawable.za_flag),
            FlagModel("zm", R.drawable.zm_flag),
            FlagModel("zw", R.drawable.zw_flag)
        )
    }
}