/*
 * Decompiled with CFR 0.152.
 */
package com.mukesh.permissions;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import com.mukesh.permissions.OnPermissionListener;
import java.util.ArrayList;
import java.util.Arrays;

public class EasyPermissions {
    private final Activity activity;
    private final OnPermissionListener onPermissionListener;

    private EasyPermissions(Builder builder) {
        this.activity = builder.activity;
        this.onPermissionListener = builder.listener;
    }

    public void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] == -1) {
                deniedPermissions.add(permissions[i]);
                continue;
            }
            grantedPermissions.add(permissions[i]);
        }
        if (grantedPermissions.size() == permissions.length) {
            this.onPermissionListener.onAllPermissionsGranted(Arrays.asList(permissions));
        } else {
            this.onPermissionListener.onPermissionsGranted(grantedPermissions);
            this.onPermissionListener.onPermissionsDenied(deniedPermissions);
        }
    }

    public void request(String ... permissions) {
        ArrayList<String> permissionNeeded = new ArrayList<String>();
        for (String permission : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)this.activity, (String)permission) == 0) continue;
            permissionNeeded.add(permission);
        }
        if (permissionNeeded.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])permissionNeeded.toArray(new String[0]), (int)10002);
        }
    }

    public boolean hasPermission(String ... permissions) {
        for (String permission : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)this.activity, (String)permission) == 0) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private Activity activity;
        private OnPermissionListener listener;

        public Builder with(@NonNull Activity activity) {
            this.activity = activity;
            return this;
        }

        public Builder listener(@NonNull OnPermissionListener listener) {
            this.listener = listener;
            return this;
        }

        public EasyPermissions build() {
            return new EasyPermissions(this);
        }
    }
}

