/*
 * Decompiled with CFR 0.152.
 */
package com.mukesh.countrypicker.adapters;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.mukesh.countrypicker.R;
import com.mukesh.countrypicker.models.Country;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;

public class CountryListAdapter
extends BaseAdapter {
    private Context context;
    List<Country> countries;
    LayoutInflater inflater;

    private int getResId(String drawableName) {
        try {
            Class<R.drawable> res = R.drawable.class;
            Field field = res.getField(drawableName);
            int drawableId = field.getInt(null);
            return drawableId;
        }
        catch (Exception e) {
            Log.e((String)"CountryCodePicker", (String)"Failure to get drawable id.", (Throwable)e);
            return -1;
        }
    }

    public CountryListAdapter(Context context, List<Country> countries) {
        this.context = context;
        this.countries = countries;
        this.inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
    }

    public int getCount() {
        return this.countries.size();
    }

    public Object getItem(int arg0) {
        return null;
    }

    public long getItemId(int arg0) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Cell cell;
        View cellView = convertView;
        Country country = this.countries.get(position);
        if (convertView == null) {
            cell = new Cell();
            cellView = this.inflater.inflate(R.layout.row, null);
            cell.textView = (TextView)cellView.findViewById(R.id.row_title);
            cell.imageView = (ImageView)cellView.findViewById(R.id.row_icon);
            cellView.setTag((Object)cell);
        } else {
            cell = (Cell)cellView.getTag();
        }
        cell.textView.setText((CharSequence)country.getName());
        String drawableName = "flag_" + country.getCode().toLowerCase(Locale.ENGLISH);
        int drawableId = this.getResId(drawableName);
        country.setFlag(drawableId);
        cell.imageView.setImageResource(drawableId);
        return cellView;
    }

    static class Cell {
        public TextView textView;
        public ImageView imageView;

        Cell() {
        }
    }
}

