/*
 * Decompiled with CFR 0.152.
 */
package com.mukeshsolanki;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.view.ViewCompat;
import com.mukeshsolanki.DefaultMovementMethod;
import com.mukeshsolanki.OnOtpCompletionListener;
import com.mukeshsolanki.R;

public class OtpView
extends AppCompatEditText {
    private static final boolean DBG = false;
    private static final int BLINK = 500;
    private static final int DEFAULT_COUNT = 4;
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private static final int[] SELECTED_STATE = new int[]{0x10100A1};
    private static final int[] FILLED_STATE = new int[]{R.attr.OtpState_filled};
    private static final int VIEW_TYPE_RECTANGLE = 0;
    private static final int VIEW_TYPE_LINE = 1;
    private static final int VIEW_TYPE_NONE = 2;
    private int viewType;
    private int otpViewItemCount;
    private int otpViewItemWidth;
    private int otpViewItemHeight;
    private int otpViewItemRadius;
    private int otpViewItemSpacing;
    private final Paint paint;
    private final TextPaint animatorTextPaint = new TextPaint();
    private ColorStateList lineColor;
    private int cursorLineColor = -16777216;
    private int lineWidth;
    private final Rect textRect = new Rect();
    private final RectF itemBorderRect = new RectF();
    private final RectF itemLineRect = new RectF();
    private final Path path = new Path();
    private final PointF itemCenterPoint = new PointF();
    private ValueAnimator defaultAddAnimator;
    private boolean isAnimationEnable = false;
    private Blink blink;
    private boolean isCursorVisible;
    private boolean drawCursor;
    private float cursorHeight;
    private int cursorWidth;
    private int cursorColor;
    private int itemBackgroundResource;
    private Drawable itemBackground;
    private boolean hideLineWhenFilled;
    private boolean rtlTextDirection;
    private String maskingChar;
    private boolean isAllCaps = false;
    private OnOtpCompletionListener onOtpCompletionListener;

    public OtpView(Context context) {
        this(context, null);
    }

    public OtpView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.otpViewStyle);
    }

    public OtpView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        Resources res = this.getResources();
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.STROKE);
        this.animatorTextPaint.set(this.getPaint());
        Resources.Theme theme = context.getTheme();
        TypedArray typedArray = theme.obtainStyledAttributes(attrs, R.styleable.OtpView, defStyleAttr, 0);
        this.viewType = typedArray.getInt(R.styleable.OtpView_OtpViewType, 2);
        this.otpViewItemCount = typedArray.getInt(R.styleable.OtpView_OtpItemCount, 4);
        this.otpViewItemHeight = (int)typedArray.getDimension(R.styleable.OtpView_OtpItemHeight, (float)res.getDimensionPixelSize(R.dimen.otp_view_item_size));
        this.otpViewItemWidth = (int)typedArray.getDimension(R.styleable.OtpView_OtpItemWidth, (float)res.getDimensionPixelSize(R.dimen.otp_view_item_size));
        this.otpViewItemSpacing = typedArray.getDimensionPixelSize(R.styleable.OtpView_OtpItemSpacing, res.getDimensionPixelSize(R.dimen.otp_view_item_spacing));
        this.otpViewItemRadius = (int)typedArray.getDimension(R.styleable.OtpView_OtpItemRadius, 0.0f);
        this.lineWidth = (int)typedArray.getDimension(R.styleable.OtpView_OtpLineWidth, (float)res.getDimensionPixelSize(R.dimen.otp_view_item_line_width));
        this.lineColor = typedArray.getColorStateList(R.styleable.OtpView_OtpLineColor);
        this.isCursorVisible = typedArray.getBoolean(R.styleable.OtpView_android_cursorVisible, true);
        this.cursorColor = typedArray.getColor(R.styleable.OtpView_OtpCursorColor, this.getCurrentTextColor());
        this.cursorWidth = typedArray.getDimensionPixelSize(R.styleable.OtpView_OtpCursorWidth, res.getDimensionPixelSize(R.dimen.otp_view_cursor_width));
        this.itemBackground = typedArray.getDrawable(R.styleable.OtpView_android_itemBackground);
        this.hideLineWhenFilled = typedArray.getBoolean(R.styleable.OtpView_OtpHideLineWhenFilled, false);
        this.rtlTextDirection = typedArray.getBoolean(R.styleable.OtpView_OtpRtlTextDirection, false);
        this.maskingChar = typedArray.getString(R.styleable.OtpView_OtpMaskingChar);
        this.isAllCaps = typedArray.getBoolean(R.styleable.OtpView_android_textAllCaps, false);
        typedArray.recycle();
        if (this.lineColor != null) {
            this.cursorLineColor = this.lineColor.getDefaultColor();
        }
        this.updateCursorHeight();
        this.checkItemRadius();
        this.setMaxLength(this.otpViewItemCount);
        this.paint.setStrokeWidth((float)this.lineWidth);
        this.setupAnimator();
        this.setTextIsSelectable(false);
    }

    public void setTypeface(Typeface tf, int style) {
        super.setTypeface(tf, style);
    }

    public void setTypeface(Typeface tf) {
        super.setTypeface(tf);
        if (this.animatorTextPaint != null) {
            this.animatorTextPaint.set(this.getPaint());
        }
    }

    private void setMaxLength(int maxLength) {
        InputFilter[] inputFilterArray;
        if (maxLength >= 0) {
            InputFilter[] inputFilterArray2 = new InputFilter[1];
            inputFilterArray = inputFilterArray2;
            inputFilterArray2[0] = new InputFilter.LengthFilter(maxLength);
        } else {
            inputFilterArray = NO_FILTERS;
        }
        this.setFilters(inputFilterArray);
    }

    private void setupAnimator() {
        this.defaultAddAnimator = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f});
        this.defaultAddAnimator.setDuration(150L);
        this.defaultAddAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.defaultAddAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float scale = ((Float)animation.getAnimatedValue()).floatValue();
                int alpha = (int)(255.0f * scale);
                OtpView.this.animatorTextPaint.setTextSize(OtpView.this.getTextSize() * scale);
                OtpView.this.animatorTextPaint.setAlpha(alpha);
                OtpView.this.postInvalidate();
            }
        });
    }

    private void checkItemRadius() {
        float halfOfItemWidth;
        if (this.viewType == 1) {
            float halfOfLineWidth = (float)this.lineWidth / 2.0f;
            if ((float)this.otpViewItemRadius > halfOfLineWidth) {
                throw new IllegalArgumentException("The itemRadius can not be greater than lineWidth when viewType is line");
            }
        } else if (this.viewType == 0 && (float)this.otpViewItemRadius > (halfOfItemWidth = (float)this.otpViewItemWidth / 2.0f)) {
            throw new IllegalArgumentException("The itemRadius can not be greater than itemWidth");
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int boxHeight = this.otpViewItemHeight;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            int boxesWidth = (this.otpViewItemCount - 1) * this.otpViewItemSpacing + this.otpViewItemCount * this.otpViewItemWidth;
            width = boxesWidth + ViewCompat.getPaddingEnd((View)this) + ViewCompat.getPaddingStart((View)this);
            if (this.otpViewItemSpacing == 0) {
                width -= (this.otpViewItemCount - 1) * this.lineWidth;
            }
        }
        int height = heightMode == 0x40000000 ? heightSize : boxHeight + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(width, height);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (start != text.length()) {
            this.moveSelectionToEnd();
        }
        if (text.length() == this.otpViewItemCount && this.onOtpCompletionListener != null) {
            this.onOtpCompletionListener.onOtpCompleted(text.toString());
        }
        this.makeBlink();
        if (this.isAnimationEnable) {
            boolean isAdd;
            boolean bl = isAdd = lengthAfter - lengthBefore > 0;
            if (isAdd && this.defaultAddAnimator != null) {
                this.defaultAddAnimator.end();
                this.defaultAddAnimator.start();
            }
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.moveSelectionToEnd();
            this.makeBlink();
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (this.getText() != null && selEnd != this.getText().length()) {
            this.moveSelectionToEnd();
        }
    }

    private void moveSelectionToEnd() {
        if (this.getText() != null) {
            this.setSelection(this.getText().length());
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.lineColor == null || this.lineColor.isStateful()) {
            this.updateColors();
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        this.updatePaints();
        this.drawOtpView(canvas);
        canvas.restore();
    }

    private void updatePaints() {
        this.paint.setColor(this.cursorLineColor);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth((float)this.lineWidth);
        this.getPaint().setColor(this.getCurrentTextColor());
    }

    private void drawOtpView(Canvas canvas) {
        int nextItemToFill = this.rtlTextDirection ? this.otpViewItemCount - 1 : (this.getText() != null ? this.getText().length() : 0);
        for (int i = 0; i < this.otpViewItemCount; ++i) {
            boolean itemSelected = this.isFocused() && nextItemToFill == i;
            boolean itemFilled = i < nextItemToFill;
            int[] itemState = null;
            if (itemFilled) {
                itemState = FILLED_STATE;
            } else if (itemSelected) {
                itemState = SELECTED_STATE;
            }
            this.paint.setColor(itemState != null ? this.getLineColorForState(itemState) : this.cursorLineColor);
            this.updateItemRectF(i);
            this.updateCenterPoint();
            canvas.save();
            if (this.viewType == 0) {
                this.updateOtpViewBoxPath(i);
                canvas.clipPath(this.path);
            }
            this.drawItemBackground(canvas, itemState);
            canvas.restore();
            if (itemSelected) {
                this.drawCursor(canvas);
            }
            if (this.viewType == 0) {
                this.drawOtpBox(canvas, i);
            } else if (this.viewType == 1) {
                this.drawOtpLine(canvas, i);
            }
            if (this.rtlTextDirection) {
                int reversedPosition = this.otpViewItemCount - i;
                if (this.getText().length() >= reversedPosition) {
                    this.drawInput(canvas, i);
                    continue;
                }
                if (TextUtils.isEmpty((CharSequence)this.getHint()) || this.getHint().length() != this.otpViewItemCount) continue;
                this.drawHint(canvas, i);
                continue;
            }
            if (this.getText().length() > i) {
                this.drawInput(canvas, i);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)this.getHint()) || this.getHint().length() != this.otpViewItemCount) continue;
            this.drawHint(canvas, i);
        }
        if (this.isFocused() && this.getText() != null && this.getText().length() != this.otpViewItemCount && this.viewType == 0) {
            int index = this.getText().length();
            this.updateItemRectF(index);
            this.updateCenterPoint();
            this.updateOtpViewBoxPath(index);
            this.paint.setColor(this.getLineColorForState(SELECTED_STATE));
            this.drawOtpBox(canvas, index);
        }
    }

    private void drawInput(Canvas canvas, int i) {
        if (this.maskingChar != null && (OtpView.isNumberInputType(this.getInputType()) || OtpView.isPasswordInputType(this.getInputType()))) {
            this.drawMaskingText(canvas, i, Character.toString(this.maskingChar.charAt(0)));
        } else if (OtpView.isPasswordInputType(this.getInputType())) {
            this.drawCircle(canvas, i);
        } else {
            this.drawText(canvas, i);
        }
    }

    private int getLineColorForState(int ... states) {
        return this.lineColor != null ? this.lineColor.getColorForState(states, this.cursorLineColor) : this.cursorLineColor;
    }

    private void drawItemBackground(Canvas canvas, int[] backgroundState) {
        if (this.itemBackground == null) {
            return;
        }
        float delta = (float)this.lineWidth / 2.0f;
        int left = Math.round(this.itemBorderRect.left - delta);
        int top = Math.round(this.itemBorderRect.top - delta);
        int right = Math.round(this.itemBorderRect.right + delta);
        int bottom = Math.round(this.itemBorderRect.bottom + delta);
        this.itemBackground.setBounds(left, top, right, bottom);
        if (this.viewType != 2) {
            this.itemBackground.setState(backgroundState != null ? backgroundState : this.getDrawableState());
        }
        this.itemBackground.draw(canvas);
    }

    private void updateOtpViewBoxPath(int i) {
        boolean drawRightCorner = false;
        boolean drawLeftCorner = false;
        if (this.otpViewItemSpacing != 0) {
            drawRightCorner = true;
            drawLeftCorner = true;
        } else {
            if (i == 0 && i != this.otpViewItemCount - 1) {
                drawLeftCorner = true;
            }
            if (i == this.otpViewItemCount - 1 && i != 0) {
                drawRightCorner = true;
            }
        }
        this.updateRoundRectPath(this.itemBorderRect, this.otpViewItemRadius, this.otpViewItemRadius, drawLeftCorner, drawRightCorner);
    }

    private void drawOtpBox(Canvas canvas, int i) {
        if (this.getText() != null && this.hideLineWhenFilled && i < this.getText().length()) {
            return;
        }
        canvas.drawPath(this.path, this.paint);
    }

    private void drawOtpLine(Canvas canvas, int i) {
        if (this.getText() != null && this.hideLineWhenFilled && i < this.getText().length()) {
            return;
        }
        boolean drawRight = true;
        boolean drawLeft = true;
        if (this.otpViewItemSpacing == 0 && this.otpViewItemCount > 1) {
            if (i == 0) {
                drawRight = false;
            } else if (i == this.otpViewItemCount - 1) {
                drawLeft = false;
            } else {
                drawRight = false;
                drawLeft = false;
            }
        }
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStrokeWidth((float)this.lineWidth / 10.0f);
        float halfLineWidth = (float)this.lineWidth / 2.0f;
        this.itemLineRect.set(this.itemBorderRect.left - halfLineWidth, this.itemBorderRect.bottom - halfLineWidth, this.itemBorderRect.right + halfLineWidth, this.itemBorderRect.bottom + halfLineWidth);
        this.updateRoundRectPath(this.itemLineRect, this.otpViewItemRadius, this.otpViewItemRadius, drawLeft, drawRight);
        canvas.drawPath(this.path, this.paint);
    }

    private void drawCursor(Canvas canvas) {
        if (this.drawCursor) {
            float cx = this.itemCenterPoint.x;
            float cy = this.itemCenterPoint.y;
            float y = cy - this.cursorHeight / 2.0f;
            int color = this.paint.getColor();
            float width = this.paint.getStrokeWidth();
            this.paint.setColor(this.cursorColor);
            this.paint.setStrokeWidth((float)this.cursorWidth);
            canvas.drawLine(cx, y, cx, y + this.cursorHeight, this.paint);
            this.paint.setColor(color);
            this.paint.setStrokeWidth(width);
        }
    }

    private void updateRoundRectPath(RectF rectF, float rx, float ry, boolean l, boolean r) {
        this.updateRoundRectPath(rectF, rx, ry, l, r, r, l);
    }

    private void updateRoundRectPath(RectF rectF, float rx, float ry, boolean tl, boolean tr, boolean br, boolean bl) {
        this.path.reset();
        float l = rectF.left;
        float t = rectF.top;
        float r = rectF.right;
        float b = rectF.bottom;
        float w = r - l;
        float h = b - t;
        float lw = w - 2.0f * rx;
        float lh = h - 2.0f * ry;
        this.path.moveTo(l, t + ry);
        if (tl) {
            this.path.rQuadTo(0.0f, -ry, rx, -ry);
        } else {
            this.path.rLineTo(0.0f, -ry);
            this.path.rLineTo(rx, 0.0f);
        }
        this.path.rLineTo(lw, 0.0f);
        if (tr) {
            this.path.rQuadTo(rx, 0.0f, rx, ry);
        } else {
            this.path.rLineTo(rx, 0.0f);
            this.path.rLineTo(0.0f, ry);
        }
        this.path.rLineTo(0.0f, lh);
        if (br) {
            this.path.rQuadTo(0.0f, ry, -rx, ry);
        } else {
            this.path.rLineTo(0.0f, ry);
            this.path.rLineTo(-rx, 0.0f);
        }
        this.path.rLineTo(-lw, 0.0f);
        if (bl) {
            this.path.rQuadTo(-rx, 0.0f, -rx, -ry);
        } else {
            this.path.rLineTo(-rx, 0.0f);
            this.path.rLineTo(0.0f, -ry);
        }
        this.path.rLineTo(0.0f, -lh);
        this.path.close();
    }

    private void updateItemRectF(int i) {
        float halfLineWidth = (float)this.lineWidth / 2.0f;
        float left = (float)(this.getScrollX() + ViewCompat.getPaddingStart((View)this) + i * (this.otpViewItemSpacing + this.otpViewItemWidth)) + halfLineWidth;
        if (this.otpViewItemSpacing == 0 && i > 0) {
            left -= (float)(this.lineWidth * i);
        }
        float right = left + (float)this.otpViewItemWidth - (float)this.lineWidth;
        float top = (float)(this.getScrollY() + this.getPaddingTop()) + halfLineWidth;
        float bottom = top + (float)this.otpViewItemHeight - (float)this.lineWidth;
        this.itemBorderRect.set(left, top, right, bottom);
    }

    private void drawText(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        paint.setColor(this.getCurrentTextColor());
        if (this.rtlTextDirection) {
            int reversedPosition = this.otpViewItemCount - i;
            int reversedCharPosition = this.getText() == null ? reversedPosition : reversedPosition - this.getText().length();
            if (reversedCharPosition <= 0 && this.getText() != null) {
                this.drawTextAtBox(canvas, paint, (CharSequence)this.getText(), Math.abs(reversedCharPosition));
            }
        } else if (this.getText() != null) {
            this.drawTextAtBox(canvas, paint, (CharSequence)this.getText(), i);
        }
    }

    private void drawMaskingText(Canvas canvas, int i, String maskingChar) {
        Paint paint = this.getPaintByIndex(i);
        paint.setColor(this.getCurrentTextColor());
        if (this.rtlTextDirection) {
            int reversedPosition = this.otpViewItemCount - i;
            int reversedCharPosition = this.getText() == null ? reversedPosition : reversedPosition - this.getText().length();
            if (reversedCharPosition <= 0 && this.getText() != null) {
                this.drawTextAtBox(canvas, paint, this.getText().toString().replaceAll(".", maskingChar), Math.abs(reversedCharPosition));
            }
        } else if (this.getText() != null) {
            this.drawTextAtBox(canvas, paint, this.getText().toString().replaceAll(".", maskingChar), i);
        }
    }

    private void drawHint(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        paint.setColor(this.getCurrentHintTextColor());
        if (this.rtlTextDirection) {
            int reversedPosition = this.otpViewItemCount - i;
            int reversedCharPosition = reversedPosition - this.getHint().length();
            if (reversedCharPosition <= 0) {
                this.drawTextAtBox(canvas, paint, this.getHint(), Math.abs(reversedCharPosition));
            }
        } else {
            this.drawTextAtBox(canvas, paint, this.getHint(), i);
        }
    }

    private void drawTextAtBox(Canvas canvas, Paint paint, CharSequence text, int charAt) {
        paint.getTextBounds(text.toString(), charAt, charAt + 1, this.textRect);
        float cx = this.itemCenterPoint.x;
        float cy = this.itemCenterPoint.y;
        float x = cx - Math.abs((float)this.textRect.width()) / 2.0f - (float)this.textRect.left;
        float y = cy + Math.abs((float)this.textRect.height()) / 2.0f - (float)this.textRect.bottom;
        if (this.isAllCaps) {
            canvas.drawText(text.toString().toUpperCase(), charAt, charAt + 1, x, y, paint);
        } else {
            canvas.drawText(text, charAt, charAt + 1, x, y, paint);
        }
    }

    private void drawCircle(Canvas canvas, int i) {
        Paint paint = this.getPaintByIndex(i);
        float cx = this.itemCenterPoint.x;
        float cy = this.itemCenterPoint.y;
        if (this.rtlTextDirection) {
            int reversedItemPosition = this.otpViewItemCount - i;
            int reversedCharPosition = reversedItemPosition - this.getHint().length();
            if (reversedCharPosition <= 0) {
                canvas.drawCircle(cx, cy, paint.getTextSize() / 2.0f, paint);
            }
        } else {
            canvas.drawCircle(cx, cy, paint.getTextSize() / 2.0f, paint);
        }
    }

    private Paint getPaintByIndex(int i) {
        if (this.getText() != null && this.isAnimationEnable && i == this.getText().length() - 1) {
            this.animatorTextPaint.setColor(this.getPaint().getColor());
            return this.animatorTextPaint;
        }
        return this.getPaint();
    }

    private void drawAnchorLine(Canvas canvas) {
        float cx = this.itemCenterPoint.x;
        float cy = this.itemCenterPoint.y;
        this.paint.setStrokeWidth(1.0f);
        cy -= this.paint.getStrokeWidth() / 2.0f;
        this.path.reset();
        this.path.moveTo(cx -= this.paint.getStrokeWidth() / 2.0f, this.itemBorderRect.top);
        this.path.lineTo(cx, this.itemBorderRect.top + Math.abs(this.itemBorderRect.height()));
        canvas.drawPath(this.path, this.paint);
        this.path.reset();
        this.path.moveTo(this.itemBorderRect.left, cy);
        this.path.lineTo(this.itemBorderRect.left + Math.abs(this.itemBorderRect.width()), cy);
        canvas.drawPath(this.path, this.paint);
        this.path.reset();
        this.paint.setStrokeWidth((float)this.lineWidth);
    }

    private void updateColors() {
        int color;
        boolean shouldInvalidate = false;
        int n = color = this.lineColor != null ? this.lineColor.getColorForState(this.getDrawableState(), 0) : this.getCurrentTextColor();
        if (color != this.cursorLineColor) {
            this.cursorLineColor = color;
            shouldInvalidate = true;
        }
        if (shouldInvalidate) {
            this.invalidate();
        }
    }

    private void updateCenterPoint() {
        float cx = this.itemBorderRect.left + Math.abs(this.itemBorderRect.width()) / 2.0f;
        float cy = this.itemBorderRect.top + Math.abs(this.itemBorderRect.height()) / 2.0f;
        this.itemCenterPoint.set(cx, cy);
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    private static boolean isNumberInputType(int inputType) {
        return inputType == 2;
    }

    protected MovementMethod getDefaultMovementMethod() {
        return DefaultMovementMethod.getInstance();
    }

    public void setLineColor(@ColorInt int color) {
        this.lineColor = ColorStateList.valueOf((int)color);
        this.updateColors();
    }

    public void setLineColor(ColorStateList colors) {
        if (colors == null) {
            throw new IllegalArgumentException("Color cannot be null");
        }
        this.lineColor = colors;
        this.updateColors();
    }

    public ColorStateList getLineColors() {
        return this.lineColor;
    }

    @ColorInt
    public int getCurrentLineColor() {
        return this.cursorLineColor;
    }

    public void setLineWidth(@Px int borderWidth) {
        this.lineWidth = borderWidth;
        this.checkItemRadius();
        this.requestLayout();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setItemCount(int count) {
        this.otpViewItemCount = count;
        this.setMaxLength(count);
        this.requestLayout();
    }

    public int getItemCount() {
        return this.otpViewItemCount;
    }

    public void setItemRadius(@Px int itemRadius) {
        this.otpViewItemRadius = itemRadius;
        this.checkItemRadius();
        this.requestLayout();
    }

    public int getItemRadius() {
        return this.otpViewItemRadius;
    }

    public void setItemSpacing(@Px int itemSpacing) {
        this.otpViewItemSpacing = itemSpacing;
        this.requestLayout();
    }

    @Px
    public int getItemSpacing() {
        return this.otpViewItemSpacing;
    }

    public void setItemHeight(@Px int itemHeight) {
        this.otpViewItemHeight = itemHeight;
        this.updateCursorHeight();
        this.requestLayout();
    }

    public int getItemHeight() {
        return this.otpViewItemHeight;
    }

    public void setItemWidth(@Px int itemWidth) {
        this.otpViewItemWidth = itemWidth;
        this.checkItemRadius();
        this.requestLayout();
    }

    public int getItemWidth() {
        return this.otpViewItemWidth;
    }

    public void setAnimationEnable(boolean enable) {
        this.isAnimationEnable = enable;
    }

    public void setHideLineWhenFilled(boolean hideLineWhenFilled) {
        this.hideLineWhenFilled = hideLineWhenFilled;
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.updateCursorHeight();
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
        this.updateCursorHeight();
    }

    public void setOtpCompletionListener(OnOtpCompletionListener otpCompletionListener) {
        this.onOtpCompletionListener = otpCompletionListener;
    }

    public void setItemBackgroundResources(@DrawableRes int resId) {
        if (resId != 0 && this.itemBackgroundResource != resId) {
            return;
        }
        this.itemBackground = ResourcesCompat.getDrawable((Resources)this.getResources(), (int)resId, (Resources.Theme)this.getContext().getTheme());
        this.setItemBackground(this.itemBackground);
        this.itemBackgroundResource = resId;
    }

    public void setItemBackgroundColor(@ColorInt int color) {
        if (this.itemBackground instanceof ColorDrawable) {
            ((ColorDrawable)this.itemBackground.mutate()).setColor(color);
            this.itemBackgroundResource = 0;
        } else {
            this.setItemBackground((Drawable)new ColorDrawable(color));
        }
    }

    public void setItemBackground(Drawable background) {
        this.itemBackgroundResource = 0;
        this.itemBackground = background;
        this.invalidate();
    }

    public void setCursorWidth(@Px int width) {
        this.cursorWidth = width;
        if (this.isCursorVisible()) {
            this.invalidateCursor(true);
        }
    }

    public int getCursorWidth() {
        return this.cursorWidth;
    }

    public void setCursorColor(@ColorInt int color) {
        this.cursorColor = color;
        if (this.isCursorVisible()) {
            this.invalidateCursor(true);
        }
    }

    public int getCursorColor() {
        return this.cursorColor;
    }

    public void setMaskingChar(String maskingChar) {
        this.maskingChar = maskingChar;
        this.requestLayout();
    }

    public String getMaskingChar() {
        return this.maskingChar;
    }

    public void setCursorVisible(boolean visible) {
        if (this.isCursorVisible != visible) {
            this.isCursorVisible = visible;
            this.invalidateCursor(this.isCursorVisible);
            this.makeBlink();
        }
    }

    public boolean isCursorVisible() {
        return this.isCursorVisible;
    }

    public void onScreenStateChanged(int screenState) {
        super.onScreenStateChanged(screenState);
        if (screenState == 1) {
            this.resumeBlink();
        } else if (screenState == 0) {
            this.suspendBlink();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resumeBlink();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.suspendBlink();
    }

    private boolean shouldBlink() {
        return this.isCursorVisible() && this.isFocused();
    }

    private void makeBlink() {
        if (this.shouldBlink()) {
            if (this.blink == null) {
                this.blink = new Blink();
            }
            this.removeCallbacks(this.blink);
            this.drawCursor = false;
            this.postDelayed(this.blink, 500L);
        } else if (this.blink != null) {
            this.removeCallbacks(this.blink);
        }
    }

    private void suspendBlink() {
        if (this.blink != null) {
            this.blink.cancel();
            this.invalidateCursor(false);
        }
    }

    private void resumeBlink() {
        if (this.blink != null) {
            this.blink.unCancel();
            this.makeBlink();
        }
    }

    private void invalidateCursor(boolean showCursor) {
        if (this.drawCursor != showCursor) {
            this.drawCursor = showCursor;
            this.invalidate();
        }
    }

    private void updateCursorHeight() {
        int delta = 2 * this.dpToPx();
        this.cursorHeight = (float)this.otpViewItemHeight - this.getTextSize() > (float)delta ? this.getTextSize() + (float)delta : this.getTextSize();
    }

    private int dpToPx() {
        return (int)(2.0f * this.getResources().getDisplayMetrics().density + 0.5f);
    }

    private class Blink
    implements Runnable {
        private boolean cancelled;

        private Blink() {
        }

        @Override
        public void run() {
            if (this.cancelled) {
                return;
            }
            OtpView.this.removeCallbacks(this);
            if (OtpView.this.shouldBlink()) {
                OtpView.this.invalidateCursor(!OtpView.this.drawCursor);
                OtpView.this.postDelayed(this, 500L);
            }
        }

        private void cancel() {
            if (!this.cancelled) {
                OtpView.this.removeCallbacks(this);
                this.cancelled = true;
            }
        }

        private void unCancel() {
            this.cancelled = false;
        }
    }
}

