/*
 * Decompiled with CFR 0.152.
 */
package com.mukesh;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.mukesh.OtpListener;
import com.mukesh.R;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class OtpView
extends LinearLayout {
    private EditText currentlyFocusedEditText;
    private List<EditText> editTexts = new ArrayList<EditText>();
    private int length;
    private OtpListener otpListener;
    private String stylesOtp;

    public OtpView(Context context) {
        super(context);
        this.init(null);
    }

    public OtpView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public OtpView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray styles = this.getContext().obtainStyledAttributes(attrs, R.styleable.OtpView);
        this.styleEditTexts(styles);
        styles.recycle();
    }

    private String makeOTP() {
        StringBuilder stringBuilder = new StringBuilder();
        for (EditText editText : this.editTexts) {
            stringBuilder.append((CharSequence)editText.getText());
        }
        return stringBuilder.toString();
    }

    public boolean hasValidOTP() {
        return this.makeOTP().length() == this.length;
    }

    public String getOTP() {
        return this.makeOTP();
    }

    public void setListener(OtpListener otpListener) {
        this.otpListener = otpListener;
    }

    public void setOTP(String otp) {
        if (otp.length() != this.length) {
            throw new IllegalArgumentException("Otp Size is different from the OtpView size");
        }
        for (int i = 0; i < this.editTexts.size(); ++i) {
            this.editTexts.get(i).setText((CharSequence)String.valueOf(otp.charAt(i)));
        }
        this.currentlyFocusedEditText = this.editTexts.get(this.length - 1);
        this.currentlyFocusedEditText.requestFocus();
    }

    private void styleEditTexts(TypedArray styles) {
        this.length = styles.getInt(R.styleable.OtpView_length, 4);
        this.generateViews(styles);
    }

    private void generateViews(TypedArray styles) {
        if (this.length > 0) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            params.setMargins(this.getPixels(16), this.getPixels(16), this.getPixels(16), this.getPixels(16));
            InputFilter[] filter = new InputFilter[]{this.getFilter(), new InputFilter.LengthFilter(1)};
            int textColor = styles.getColor(R.styleable.OtpView_android_textColor, -16777216);
            int backgroundColor = styles.getColor(R.styleable.OtpView_text_background_color, 0);
            int inputType = styles.getInt(R.styleable.OtpView_android_inputType, 0);
            int hintColor = styles.getColor(R.styleable.OtpView_hint_color, -7829368);
            String hint = styles.getString(R.styleable.OtpView_hint);
            this.stylesOtp = styles.getString(R.styleable.OtpView_otp);
            for (int i = 0; i < this.length; ++i) {
                EditText editText = new EditText(this.getContext());
                editText.setId(i);
                editText.setSingleLine();
                editText.setMaxLines(1);
                editText.setFilters(filter);
                editText.setLayoutParams((ViewGroup.LayoutParams)params);
                if (backgroundColor != 0) {
                    editText.setBackgroundColor(backgroundColor);
                } else {
                    editText.getBackground().mutate().setColorFilter(textColor, PorterDuff.Mode.SRC_ATOP);
                }
                editText.setHintTextColor(hintColor);
                editText.setHint((CharSequence)hint);
                editText.setTextColor(textColor);
                editText.setInputType(inputType);
                this.setFocusListener(editText);
                this.setOnTextChangeListener(editText);
                this.addView((View)editText, i);
                this.editTexts.add(editText);
            }
        } else {
            throw new IllegalStateException("Please specify the length of the otp view");
        }
        this.currentlyFocusedEditText = this.editTexts.get(0);
        this.setOTP(this.stylesOtp);
    }

    private InputFilter getFilter() {
        return new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                for (int i = start; i < end; ++i) {
                    if (Pattern.compile("[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890]*").matcher(String.valueOf(source.charAt(i))).matches()) continue;
                    return "";
                }
                return null;
            }
        };
    }

    private int getPixels(int valueInDp) {
        Resources r = this.getResources();
        float px = TypedValue.applyDimension((int)1, (float)valueInDp, (DisplayMetrics)r.getDisplayMetrics());
        return (int)px;
    }

    private void setFocusListener(EditText editText) {
        View.OnFocusChangeListener onFocusChangeListener = new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                OtpView.this.currentlyFocusedEditText = (EditText)v;
                OtpView.this.currentlyFocusedEditText.setSelection(OtpView.this.currentlyFocusedEditText.getText().length());
            }
        };
        editText.setOnFocusChangeListener(onFocusChangeListener);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void disableKeypad() {
        View.OnTouchListener touchListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                v.onTouchEvent(event);
                InputMethodManager imm = (InputMethodManager)v.getContext().getSystemService("input_method");
                if (imm != null) {
                    imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                }
                return true;
            }
        };
        for (EditText editText : this.editTexts) {
            editText.setOnTouchListener(touchListener);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void enableKeypad() {
        View.OnTouchListener touchListener = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return false;
            }
        };
        for (EditText editText : this.editTexts) {
            editText.setOnTouchListener(touchListener);
        }
    }

    public EditText getCurrentFoucusedEditText() {
        return this.currentlyFocusedEditText;
    }

    private void setOnTextChangeListener(EditText editText) {
        TextWatcher textWatcher = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                int editTextLength = OtpView.this.currentlyFocusedEditText.getText().toString().length();
                InputMethodManager imm = (InputMethodManager)OtpView.this.getContext().getSystemService("input_method");
                if (editTextLength == 0) {
                    if (OtpView.this.currentlyFocusedEditText == OtpView.this.editTexts.get(0)) {
                        if (imm != null) {
                            imm.hideSoftInputFromWindow(OtpView.this.getWindowToken(), 0);
                        }
                    } else if (OtpView.this.currentlyFocusedEditText.focusSearch(17) != null) {
                        OtpView.this.currentlyFocusedEditText.focusSearch(17).requestFocus();
                    }
                } else if (editTextLength == 1) {
                    if (OtpView.this.currentlyFocusedEditText == OtpView.this.editTexts.get(OtpView.this.editTexts.size() - 1)) {
                        if (imm != null) {
                            imm.hideSoftInputFromWindow(OtpView.this.getWindowToken(), 0);
                        }
                    } else if (OtpView.this.currentlyFocusedEditText.focusSearch(66) != null) {
                        OtpView.this.currentlyFocusedEditText.focusSearch(66).requestFocus();
                    }
                }
                if (OtpView.this.otpListener != null && OtpView.this.getOTP().length() == OtpView.this.length) {
                    OtpView.this.otpListener.onOtpEntered(OtpView.this.getOTP());
                }
            }
        };
        editText.addTextChangedListener(textWatcher);
    }

    public void simulateDeletePress() {
        this.currentlyFocusedEditText.setText((CharSequence)"");
    }
}

