/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.fast.tests;

import com.github.mrpowers.spark.fast.tests.ProductUtil$;
import com.github.mrpowers.spark.fast.tests.SchemaComparer;
import com.github.mrpowers.spark.fast.tests.SchemaDiffOutputFormat$;
import com.github.mrpowers.spark.fast.tests.ufansi.Color$;
import com.github.mrpowers.spark.fast.tests.ufansi.Str;
import com.github.mrpowers.spark.fast.tests.ufansi.Str$;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class SchemaComparer$ {
    public static SchemaComparer$ MODULE$;
    private final int INDENT_GAP;
    private final int DESCRIPTION_GAP;
    private final int TREE_GAP;
    private final String CONTAIN_NULLS;

    static {
        new SchemaComparer$();
    }

    private int INDENT_GAP() {
        return this.INDENT_GAP;
    }

    private int DESCRIPTION_GAP() {
        return this.DESCRIPTION_GAP;
    }

    private int TREE_GAP() {
        return this.TREE_GAP;
    }

    private String CONTAIN_NULLS() {
        return this.CONTAIN_NULLS;
    }

    private String betterSchemaMismatchMessage(StructType actualSchema, StructType expectedSchema) {
        return ProductUtil$.MODULE$.showProductDiff((Tuple2<String, String>)new Tuple2((Object)"Actual Schema", (Object)"Expected Schema"), Predef$.MODULE$.wrapRefArray((Object[])actualSchema.fields()), Predef$.MODULE$.wrapRefArray((Object[])expectedSchema.fields()), 200, ProductUtil$.MODULE$.showProductDiff$default$5(), ClassTag$.MODULE$.apply(StructField.class));
    }

    private <T> String treeSchemaMismatchMessage(StructType actualSchema, StructType expectedSchema) {
        Tuple2 tuple2 = SchemaComparer$.flattenStrucType$1(actualSchema, 0, SchemaComparer$.flattenStrucType$default$3$1());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq treeFieldPair1 = (Seq)tuple2._1();
        int tree1MaxWidth = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)treeFieldPair1, (Object)BoxesRunTime.boxToInteger((int)tree1MaxWidth));
        Seq treeFieldPair12 = (Seq)tuple22._1();
        int tree1MaxWidth2 = tuple22._2$mcI$sp();
        Tuple2 tuple23 = SchemaComparer$.flattenStrucType$1(expectedSchema, 0, SchemaComparer$.flattenStrucType$default$3$1());
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Seq treeFieldPair2 = (Seq)tuple23._1();
        Seq treeFieldPair22 = treeFieldPair2;
        Tuple2 tuple24 = (Tuple2)((TraversableOnce)treeFieldPair12.zipAll((GenIterable)treeFieldPair22, (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), null), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), null), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    Seq acc = (Seq)tuple22._1();
                    int maxWidth = tuple22._2$mcI$sp();
                    if (tuple23 != null) {
                        Tuple2 tuple24 = (Tuple2)tuple23._1();
                        Tuple2 tuple25 = (Tuple2)tuple23._2();
                        if (tuple24 != null) {
                            int indent1 = tuple24._1$mcI$sp();
                            StructField field1 = (StructField)tuple24._2();
                            if (tuple25 != null) {
                                int indent2 = tuple25._1$mcI$sp();
                                StructField field2 = (StructField)tuple25._2();
                                Tuple2<String, String> tuple26 = MODULE$.getIndentPair(indent1, indent2);
                                if (tuple26 == null) {
                                    throw new MatchError(tuple26);
                                }
                                String prefix1 = (String)tuple26._1();
                                String prefix2 = (String)tuple26._2();
                                Tuple2 tuple27 = new Tuple2((Object)prefix1, (Object)prefix2);
                                String prefix12 = (String)tuple27._1();
                                String prefix22 = (String)tuple27._2();
                                Tuple2<String, String> tuple28 = MODULE$.getNamePair(field1, field2);
                                if (tuple28 == null) {
                                    throw new MatchError(tuple28);
                                }
                                String name1 = (String)tuple28._1();
                                String name2 = (String)tuple28._2();
                                Tuple2 tuple29 = new Tuple2((Object)name1, (Object)name2);
                                String name12 = (String)tuple29._1();
                                String name22 = (String)tuple29._2();
                                Tuple2<String, String> tuple210 = MODULE$.getDataTypePair(field1, field2);
                                if (tuple210 == null) {
                                    throw new MatchError(tuple210);
                                }
                                String dtype1 = (String)tuple210._1();
                                String dtype2 = (String)tuple210._2();
                                Tuple2 tuple211 = new Tuple2((Object)dtype1, (Object)dtype2);
                                String dtype12 = (String)tuple211._1();
                                String dtype22 = (String)tuple211._2();
                                Tuple2<String, String> tuple212 = MODULE$.getNullablePair(field1, field2);
                                if (tuple212 == null) {
                                    throw new MatchError(tuple212);
                                }
                                String nullable1 = (String)tuple212._1();
                                String nullable2 = (String)tuple212._2();
                                Tuple2 tuple213 = new Tuple2((Object)nullable1, (Object)nullable2);
                                String nullable12 = (String)tuple213._1();
                                String nullable22 = (String)tuple213._2();
                                Tuple2<String, String> tuple214 = MODULE$.getContainNullsPair(field1, field2);
                                if (tuple214 == null) {
                                    throw new MatchError(tuple214);
                                }
                                String containNulls1 = (String)tuple214._1();
                                String containNulls2 = (String)tuple214._2();
                                Tuple2 tuple215 = new Tuple2((Object)containNulls1, (Object)containNulls2);
                                String containNulls12 = (String)tuple215._1();
                                String containNulls22 = (String)tuple215._2();
                                String structString1 = MODULE$.formatField(field1, prefix12, name12, dtype12, nullable12, containNulls12);
                                String structString2 = MODULE$.formatField(field2, prefix22, name22, dtype22, nullable22, containNulls22);
                                return new Tuple2(acc.$colon$plus((Object)new Tuple2((Object)structString1, (Object)structString2), Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(maxWidth, structString1.length())));
                            }
                        }
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        Seq treePair = (Seq)tuple24._1();
        int maxWidth = tuple24._2$mcI$sp();
        Tuple2 tuple25 = new Tuple2((Object)treePair, (Object)BoxesRunTime.boxToInteger((int)maxWidth));
        Seq treePair2 = (Seq)tuple25._1();
        int maxWidth2 = tuple25._2$mcI$sp();
        int schemaGap = maxWidth2 + this.TREE_GAP();
        int headerGap = tree1MaxWidth2 + this.TREE_GAP();
        return ((StringBuilder)treePair2.foldLeft((Object)new StringBuilder(new java.lang.StringBuilder(16).append((String)new StringOps(Predef$.MODULE$.augmentString("\nActual Schema")).padTo(headerGap, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom())).append("Expected Schema\n").toString()), (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
            if (tuple2 != null) {
                StringBuilder sb = (StringBuilder)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    String s1 = (String)tuple22._1();
                    String s2 = (String)tuple22._2();
                    int gap = s1.isEmpty() ? headerGap : schemaGap;
                    String s = s2.isEmpty() ? s1 : (String)new StringOps(Predef$.MODULE$.augmentString(s1)).padTo(gap, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom());
                    return sb.append(new java.lang.StringBuilder(1).append(s).append(s2).append("\n").toString());
                }
            }
            throw new MatchError((Object)tuple2);
        })).toString();
    }

    private String getDescriptionPair(String nullable, String containNulls) {
        if (containNulls.isEmpty()) {
            return new java.lang.StringBuilder(13).append("(nullable = ").append(nullable).append(")").toString();
        }
        return new java.lang.StringBuilder(17).append("(containsNull = ").append(containNulls).append(")").toString();
    }

    private String formatField(StructField field, String prefix, String name, String dtype, String nullable, String containNulls) {
        if (field == null) {
            return "";
        }
        String description = this.getDescriptionPair(nullable, containNulls);
        return new java.lang.StringBuilder(5).append(prefix).append(" ").append(name).append(" : ").append(dtype).append(" ").append(description).toString();
    }

    private Tuple2<String, String> getContainNullsPair(StructField field1, StructField field2) {
        Tuple2 tuple2 = new Tuple2((Object)field1, (Object)field2);
        if (tuple2 != null) {
            StructField f = (StructField)tuple2._1();
            StructField structField = (StructField)tuple2._2();
            if (structField == null) {
                String containNulls = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Boolean.toString(f.metadata().getBoolean(MODULE$.CONTAIN_NULLS()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(containNulls)).toString()), (Object)"");
            }
        }
        if (tuple2 != null) {
            StructField structField = (StructField)tuple2._1();
            StructField f = (StructField)tuple2._2();
            if (structField == null) {
                String containNulls = (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Boolean.toString(f.metadata().getBoolean(MODULE$.CONTAIN_NULLS()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(containNulls)).toString());
            }
        }
        if (tuple2 != null) {
            StructField structField = (StructField)tuple2._1();
            StructField structField2 = (StructField)tuple2._2();
            if (structField != null) {
                Metadata m1 = structField.metadata();
                if (structField2 != null) {
                    Metadata m2 = structField2.metadata();
                    boolean isArrayElement1 = m1.contains(this.CONTAIN_NULLS());
                    boolean isArrayElement2 = m2.contains(this.CONTAIN_NULLS());
                    if (isArrayElement1 && isArrayElement2) {
                        boolean containNulls2;
                        Tuple2 tuple22;
                        boolean containNulls1 = m1.getBoolean(this.CONTAIN_NULLS());
                        Tuple2 tuple23 = tuple22 = containNulls1 != (containNulls2 = m2.getBoolean(this.CONTAIN_NULLS())) ? new Tuple2((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(Boolean.toString(containNulls1))), (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(Boolean.toString(containNulls2)))) : new Tuple2((Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(Boolean.toString(containNulls1))), (Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(Boolean.toString(containNulls2))));
                        if (tuple22 == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Str cn1 = (Str)tuple22._1();
                        Str cn2 = (Str)tuple22._2();
                        Tuple2 tuple24 = new Tuple2((Object)cn1, (Object)cn2);
                        Str cn12 = (Str)tuple24._1();
                        Str cn22 = (Str)tuple24._2();
                        return new Tuple2((Object)cn12.toString(), (Object)cn22.toString());
                    }
                    if (isArrayElement1) {
                        return new Tuple2((Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(Boolean.toString(m1.getBoolean(this.CONTAIN_NULLS())))).toString(), (Object)"");
                    }
                    if (isArrayElement2) {
                        return new Tuple2((Object)"", (Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(Boolean.toString(m2.getBoolean(this.CONTAIN_NULLS())))).toString());
                    }
                    return new Tuple2((Object)"", (Object)"");
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<String, String> getIndentPair(int indent1, int indent2) {
        Tuple2 tuple2;
        String prefix1 = SchemaComparer$.depthToIndentStr$1(indent1);
        String prefix2 = SchemaComparer$.depthToIndentStr$1(indent2);
        Tuple2 tuple22 = tuple2 = indent1 != indent2 ? new Tuple2((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(prefix1)), (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(prefix2))) : new Tuple2((Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(prefix1)), (Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(prefix2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Str p1 = (Str)tuple2._1();
        Str p2 = (Str)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)p1, (Object)p2);
        Str p12 = (Str)tuple23._1();
        Str p22 = (Str)tuple23._2();
        return new Tuple2((Object)p12.toString(), (Object)p22.toString());
    }

    private Tuple2<String, String> getNamePair(StructField field1, StructField field2) {
        StructField structField;
        Tuple2 tuple2 = new Tuple2((Object)field1, (Object)field2);
        if (tuple2 != null) {
            StructField structField2 = (StructField)tuple2._2();
            if (tuple2._1() != null && structField2 == null) {
                return new Tuple2((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(field1.name())).toString(), (Object)"");
            }
        }
        if (tuple2 != null && (structField = (StructField)tuple2._1()) == null && tuple2._2() != null) {
            return new Tuple2((Object)"", (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(field2.name())).toString());
        }
        if (tuple2 != null) {
            StructField f1 = (StructField)tuple2._1();
            StructField f2 = (StructField)tuple2._2();
            String string = f1.name();
            String string2 = f2.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return new Tuple2((Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(field1.name())).toString(), (Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(field2.name())).toString());
            }
        }
        if (tuple2 != null) {
            StructField f1 = (StructField)tuple2._1();
            StructField f2 = (StructField)tuple2._2();
            String string = f1.name();
            String string3 = f2.name();
            if (string == null ? string3 != null : !string.equals(string3)) {
                return new Tuple2((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(field1.name())).toString(), (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(field2.name())).toString());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<String, String> getDataTypePair(StructField field1, StructField field2) {
        Tuple2 tuple2 = new Tuple2((Object)field1, (Object)field2);
        if (tuple2 != null) {
            StructField f = (StructField)tuple2._1();
            StructField structField = (StructField)tuple2._2();
            if (f != null) {
                StructField structField2 = f;
                if (structField == null) {
                    return new Tuple2((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(structField2.dataType().typeName())).toString(), (Object)"");
                }
            }
        }
        if (tuple2 != null) {
            StructField structField = (StructField)tuple2._1();
            StructField f = (StructField)tuple2._2();
            if (structField == null && f != null) {
                StructField structField3 = f;
                return new Tuple2((Object)"", (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(structField3.dataType().typeName())).toString());
            }
        }
        if (tuple2 != null) {
            StructField f1 = (StructField)tuple2._1();
            StructField f2 = (StructField)tuple2._2();
            DataType dataType = f1.dataType();
            DataType dataType2 = f2.dataType();
            if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                return new Tuple2((Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(f1.dataType().typeName())).toString(), (Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(f2.dataType().typeName())).toString());
            }
        }
        if (tuple2 != null) {
            StructField f1 = (StructField)tuple2._1();
            StructField f2 = (StructField)tuple2._2();
            DataType dataType = f1.dataType();
            DataType dataType3 = f2.dataType();
            if (dataType == null ? dataType3 != null : !dataType.equals(dataType3)) {
                return new Tuple2((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(f1.dataType().typeName())).toString(), (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(f2.dataType().typeName())).toString());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<String, String> getNullablePair(StructField field1, StructField field2) {
        Tuple2 tuple2 = new Tuple2((Object)field1, (Object)field2);
        if (tuple2 != null) {
            StructField f = (StructField)tuple2._1();
            StructField structField = (StructField)tuple2._2();
            if (f != null) {
                StructField structField2 = f;
                if (structField == null) {
                    return new Tuple2((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(Boolean.toString(structField2.nullable()))).toString(), (Object)"");
                }
            }
        }
        if (tuple2 != null) {
            StructField structField = (StructField)tuple2._1();
            StructField f = (StructField)tuple2._2();
            if (structField == null && f != null) {
                StructField structField3 = f;
                return new Tuple2((Object)"", (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(Boolean.toString(structField3.nullable()))).toString());
            }
        }
        if (tuple2 != null) {
            StructField f1 = (StructField)tuple2._1();
            StructField f2 = (StructField)tuple2._2();
            if (f1.nullable() == f2.nullable()) {
                return new Tuple2((Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(Boolean.toString(f1.nullable()))).toString(), (Object)Color$.MODULE$.DarkGray().apply(Str$.MODULE$.implicitApply(Boolean.toString(f2.nullable()))).toString());
            }
        }
        if (tuple2 != null) {
            StructField f1 = (StructField)tuple2._1();
            StructField f2 = (StructField)tuple2._2();
            if (f1.nullable() != f2.nullable()) {
                return new Tuple2((Object)Color$.MODULE$.Red().apply(Str$.MODULE$.implicitApply(Boolean.toString(f1.nullable()))).toString(), (Object)Color$.MODULE$.Green().apply(Str$.MODULE$.implicitApply(Boolean.toString(f2.nullable()))).toString());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public <T> void assertDatasetSchemaEqual(Dataset<T> actualDS, Dataset<T> expectedDS, boolean ignoreNullable, boolean ignoreColumnNames, boolean ignoreColumnOrder, boolean ignoreMetadata, Enumeration.Value outputFormat) {
        this.assertSchemaEqual(actualDS.schema(), expectedDS.schema(), ignoreNullable, ignoreColumnNames, ignoreColumnOrder, ignoreMetadata, outputFormat);
    }

    public <T> boolean assertDatasetSchemaEqual$default$3() {
        return false;
    }

    public <T> boolean assertDatasetSchemaEqual$default$4() {
        return false;
    }

    public <T> boolean assertDatasetSchemaEqual$default$5() {
        return true;
    }

    public <T> boolean assertDatasetSchemaEqual$default$6() {
        return true;
    }

    public <T> Enumeration.Value assertDatasetSchemaEqual$default$7() {
        return SchemaDiffOutputFormat$.MODULE$.Table();
    }

    public void assertSchemaEqual(StructType actualSchema, StructType expectedSchema, boolean ignoreNullable, boolean ignoreColumnNames, boolean ignoreColumnOrder, boolean ignoreMetadata, Enumeration.Value outputFormat) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(ignoreColumnNames, ignoreColumnOrder);
        Tuple2.mcZZ.sp sp3 = new Tuple2.mcZZ.sp(true, true);
        Predef$.MODULE$.require(sp2 == null ? sp3 != null : !sp2.equals(sp3), (Function0 & Serializable & scala.Serializable)() -> "Cannot set both ignoreColumnNames and ignoreColumnOrder to true.");
        if (!this.equals(actualSchema, expectedSchema, ignoreNullable, ignoreColumnNames, ignoreColumnOrder, ignoreMetadata)) {
            String string;
            Enumeration.Value value = outputFormat;
            Enumeration.Value value2 = SchemaDiffOutputFormat$.MODULE$.Tree();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = this.treeSchemaMismatchMessage(actualSchema, expectedSchema);
            } else {
                Enumeration.Value value4 = SchemaDiffOutputFormat$.MODULE$.Table();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = this.betterSchemaMismatchMessage(actualSchema, expectedSchema);
                } else {
                    throw new MatchError((Object)value);
                }
            }
            String diffString = string;
            throw new SchemaComparer.DatasetSchemaMismatch(new java.lang.StringBuilder(6).append("Diffs\n").append(diffString).toString());
        }
    }

    public boolean assertSchemaEqual$default$3() {
        return false;
    }

    public boolean assertSchemaEqual$default$4() {
        return false;
    }

    public boolean assertSchemaEqual$default$5() {
        return true;
    }

    public boolean assertSchemaEqual$default$6() {
        return true;
    }

    public Enumeration.Value assertSchemaEqual$default$7() {
        return SchemaDiffOutputFormat$.MODULE$.Table();
    }

    public boolean equals(StructType s1, StructType s2, boolean ignoreNullable, boolean ignoreColumnNames, boolean ignoreColumnOrder, boolean ignoreMetadata) {
        if (s1.length() != s2.length()) {
            return false;
        }
        if (s1.length() != s2.length()) {
            return false;
        }
        Seq zipStruct = ignoreColumnOrder ? (Seq)((IterableLike)s1.sortBy((Function1 & Serializable & scala.Serializable)x$13 -> x$13.name(), (Ordering)Ordering.String$.MODULE$)).zip((GenIterable)s2.sortBy((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name(), (Ordering)Ordering.String$.MODULE$), Seq$.MODULE$.canBuildFrom()) : (Seq)s1.zip((GenIterable)s2, Seq$.MODULE$.canBuildFrom());
        return zipStruct.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SchemaComparer$.$anonfun$equals$3(ignoreNullable, ignoreColumnNames, ignoreMetadata, ignoreColumnOrder, x0$1)));
    }

    public boolean equals(DataType dt1, DataType dt2, boolean ignoreNullable, boolean ignoreColumnNames, boolean ignoreColumnOrder, boolean ignoreMetadata) {
        block7: {
            while (true) {
                Tuple2 tuple2;
                if ((tuple2 = new Tuple2((Object)dt1, (Object)dt2)) != null) {
                    DataType st1 = (DataType)tuple2._1();
                    DataType st2 = (DataType)tuple2._2();
                    if (st1 instanceof StructType) {
                        StructType structType = (StructType)st1;
                        if (st2 instanceof StructType) {
                            StructType structType2 = (StructType)st2;
                            return this.equals(structType, structType2, ignoreNullable, ignoreColumnNames, ignoreColumnOrder, this.equals$default$6());
                        }
                    }
                }
                if (tuple2 != null) {
                    DataType dataType = (DataType)tuple2._1();
                    DataType dataType2 = (DataType)tuple2._2();
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType vdt1 = arrayType.elementType();
                        if (dataType2 instanceof ArrayType) {
                            DataType vdt2;
                            ArrayType arrayType2 = (ArrayType)dataType2;
                            dt2 = vdt2 = arrayType2.elementType();
                            dt1 = vdt1;
                            continue;
                        }
                    }
                }
                if (tuple2 == null) break block7;
                DataType dataType = (DataType)tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (!(dataType instanceof MapType)) break block7;
                MapType mapType = (MapType)dataType;
                DataType kdt1 = mapType.keyType();
                DataType vdt1 = mapType.valueType();
                if (!(dataType3 instanceof MapType)) break block7;
                MapType mapType2 = (MapType)dataType3;
                DataType kdt2 = mapType2.keyType();
                DataType vdt2 = mapType2.valueType();
                if (!this.equals(kdt1, kdt2, ignoreNullable, ignoreColumnNames, ignoreColumnOrder, ignoreMetadata)) break;
                dt2 = vdt2;
                dt1 = vdt1;
            }
            return false;
        }
        DataType dataType = dt1;
        DataType dataType4 = dt2;
        return !(dataType != null ? !dataType.equals(dataType4) : dataType4 != null);
    }

    public boolean equals$default$3() {
        return false;
    }

    public boolean equals$default$4() {
        return false;
    }

    public boolean equals$default$5() {
        return true;
    }

    public boolean equals$default$6() {
        return true;
    }

    private static final Tuple2 flattenStrucType$1(StructType s, int indent, int additionalGap) {
        return (Tuple2)s.foldLeft((Object)new Tuple2((Object)Nil$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                StructField f = (StructField)tuple2._2();
                if (tuple22 != null) {
                    Seq fieldPair = (Seq)tuple22._1();
                    int maxWidth = tuple22._2$mcI$sp();
                    int gap = indent * MODULE$.INDENT_GAP() + MODULE$.DESCRIPTION_GAP() + f.name().length() + f.dataType().typeName().length() + Boolean.toString(f.nullable()).length() + additionalGap;
                    Seq pair = (Seq)fieldPair.$colon$plus((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)indent), (Object)f), Seq$.MODULE$.canBuildFrom());
                    int newMaxWidth = scala.math.package$.MODULE$.max(maxWidth, gap);
                    DataType dataType = f.dataType();
                    if (dataType instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        Tuple2 tuple23 = SchemaComparer$.flattenStrucType$1(structType, indent + 1, SchemaComparer$.flattenStrucType$default$3$1());
                        if (tuple23 == null) {
                            throw new MatchError((Object)tuple23);
                        }
                        Seq flattenPair = (Seq)tuple23._1();
                        int width = tuple23._2$mcI$sp();
                        Tuple2 tuple24 = new Tuple2((Object)flattenPair, (Object)BoxesRunTime.boxToInteger((int)width));
                        Seq flattenPair2 = (Seq)tuple24._1();
                        int width2 = tuple24._2$mcI$sp();
                        return new Tuple2(pair.$plus$plus((GenTraversableOnce)flattenPair2, Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(newMaxWidth, width2)));
                    }
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType elementType = arrayType.elementType();
                        boolean containsNull = arrayType.containsNull();
                        String x$1 = "element";
                        DataType x$2 = elementType;
                        Metadata x$3 = new MetadataBuilder().putBoolean(MODULE$.CONTAIN_NULLS(), containsNull).build();
                        boolean x$4 = StructField$.MODULE$.apply$default$3();
                        StructType arrStruct = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField(x$1, x$2, x$4, x$3), (List)Nil$.MODULE$));
                        Tuple2 tuple25 = SchemaComparer$.flattenStrucType$1(arrStruct, indent + 1, 5);
                        if (tuple25 == null) {
                            throw new MatchError((Object)tuple25);
                        }
                        Seq flattenPair = (Seq)tuple25._1();
                        int width = tuple25._2$mcI$sp();
                        Tuple2 tuple26 = new Tuple2((Object)flattenPair, (Object)BoxesRunTime.boxToInteger((int)width));
                        Seq flattenPair3 = (Seq)tuple26._1();
                        int width3 = tuple26._2$mcI$sp();
                        return new Tuple2(pair.$plus$plus((GenTraversableOnce)flattenPair3, Seq$.MODULE$.canBuildFrom()), (Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.max(newMaxWidth, width3)));
                    }
                    return new Tuple2((Object)pair, (Object)BoxesRunTime.boxToInteger((int)newMaxWidth));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final int flattenStrucType$default$3$1() {
        return 0;
    }

    public static final /* synthetic */ String $anonfun$getIndentPair$1(int x$11) {
        return "|    ";
    }

    private static final String depthToIndentStr$1(int depth) {
        return new java.lang.StringBuilder(3).append(((TraversableOnce)package$.MODULE$.Range().apply(0, depth).map((Function1 & Serializable & scala.Serializable)x$11 -> SchemaComparer$.$anonfun$getIndentPair$1(BoxesRunTime.unboxToInt((Object)x$11)), IndexedSeq$.MODULE$.canBuildFrom())).mkString()).append("|--").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$equals$3(boolean ignoreNullable$1, boolean ignoreColumnNames$1, boolean ignoreMetadata$1, boolean ignoreColumnOrder$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        StructField f1 = (StructField)tuple2._1();
        StructField f2 = (StructField)tuple2._2();
        if (f1.nullable() != f2.nullable()) {
            if (!ignoreNullable$1) return false;
        }
        String string = f1.name();
        String string2 = f2.name();
        if (string == null ? string2 != null : !string.equals(string2)) {
            if (!ignoreColumnNames$1) return false;
        }
        Metadata metadata = f1.metadata();
        Metadata metadata2 = f2.metadata();
        if (metadata == null ? metadata2 != null : !metadata.equals(metadata2)) {
            if (!ignoreMetadata$1) return false;
        }
        if (!MODULE$.equals(f1.dataType(), f2.dataType(), ignoreNullable$1, ignoreColumnNames$1, ignoreColumnOrder$1, ignoreMetadata$1)) return false;
        return true;
    }

    private SchemaComparer$() {
        MODULE$ = this;
        this.INDENT_GAP = 5;
        this.DESCRIPTION_GAP = 21;
        this.TREE_GAP = 6;
        this.CONTAIN_NULLS = "sparkFastTestContainsNull";
    }
}

