/*
 * Decompiled with CFR 0.152.
 */
package com.github.mrpowers.spark.fast.tests;

import java.io.Serializable;
import java.sql.Date;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DataFramePrettyPrint$ {
    public static DataFramePrettyPrint$ MODULE$;

    static {
        new DataFramePrettyPrint$();
    }

    public String showString(Dataset<Row> df, int _numRows, int truncate) {
        BoxedUnit boxedUnit;
        int numRows = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(_numRows), 0);
        Row[] takeResult = (Row[])df.take(numRows + 1);
        boolean hasMoreData = takeResult.length > numRows;
        Row[] data = (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])takeResult)).take(numRows);
        Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).toSeq();
        Seq rows = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data)).map((Function1 & Serializable & scala.Serializable)row -> (Seq)row.toSeq().map((Function1 & Serializable & scala.Serializable)cell -> {
            void var3_8;
            String string;
            Object object = cell;
            if (object == null) {
                string = "null";
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                string = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(byArray)).map((Function1 & Serializable & scala.Serializable)x$1 -> DataFramePrettyPrint$.$anonfun$showString$3(BoxesRunTime.unboxToByte((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", " ", "]");
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                string = Predef$.MODULE$.genericArrayOps(object2).mkString("[", ", ", "]");
            } else if (object instanceof Seq) {
                Seq seq = (Seq)object;
                string = seq.mkString("[", ", ", "]");
            } else if (object instanceof Date) {
                Date date = (Date)object;
                string = date.toLocalDate().format(DateTimeFormatter.ISO_DATE);
            } else {
                string = cell.toString();
            }
            String str = string;
            return truncate > 0 && str.length() > truncate ? (truncate < 4 ? str.substring(0, truncate) : str.substring(0, truncate - 3) + "...") : var3_8;
        }, Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).$plus$colon((Object)seq, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        StringBuilder sb = new StringBuilder();
        int numCols = df.schema().fieldNames().length;
        int[] colWidths = (int[])Array$.MODULE$.fill(numCols, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 3, ClassTag$.MODULE$.Int());
        rows.foreach((Function1 & Serializable & scala.Serializable)row -> {
            DataFramePrettyPrint$.$anonfun$showString$5(colWidths, row);
            return BoxedUnit.UNIT;
        });
        String sep = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(colWidths)).map((Function1 & Serializable & scala.Serializable)x$4 -> DataFramePrettyPrint$.$anonfun$showString$8(BoxesRunTime.unboxToInt((Object)x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).addString(sb, "+", "+", "+\n").toString();
        Seq h = (Seq)((IterableLike)rows.head()).zipWithIndex(Seq$.MODULE$.canBuildFrom());
        ((TraversableOnce)h.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String cell = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string = truncate > 0 ? StringUtils.leftPad((String)cell, (int)colWidths[i]) : StringUtils.rightPad((String)cell, (int)colWidths[i]);
            return string;
        }, Seq$.MODULE$.canBuildFrom())).addString(sb, "|", "|", "|\n");
        sb.append(sep);
        ((TraversableLike)rows.tail()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)((TraversableLike)x$5.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String cell = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string = truncate > 0 ? StringUtils.leftPad((String)cell.toString(), (int)colWidths[i]) : StringUtils.rightPad((String)cell.toString(), (int)colWidths[i]);
            return string;
        }, Seq$.MODULE$.canBuildFrom())).addString(sb, "|", "|", "|\n"), Seq$.MODULE$.canBuildFrom());
        sb.append(sep);
        if (hasMoreData) {
            String rowsString = numRows == 1 ? "row" : "rows";
            boxedUnit = sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"only showing top ", " ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numRows), rowsString})));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    public int showString$default$3() {
        return 20;
    }

    public static final /* synthetic */ String $anonfun$showString$3(byte x$1) {
        return new StringOps(Predef$.MODULE$.augmentString("%02X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)x$1)}));
    }

    public static final /* synthetic */ boolean $anonfun$showString$6(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$showString$7(int[] colWidths$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String cell = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        colWidths$1[i] = package$.MODULE$.max(colWidths$1[i], cell.length());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$showString$5(int[] colWidths$1, Seq row) {
        ((TraversableLike)row.zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DataFramePrettyPrint$.$anonfun$showString$6(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            DataFramePrettyPrint$.$anonfun$showString$7(colWidths$1, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$showString$8(int x$4) {
        return new StringOps(Predef$.MODULE$.augmentString("-")).$times(x$4);
    }

    private DataFramePrettyPrint$() {
        MODULE$ = this;
    }
}

