/*
 * Decompiled with CFR 0.152.
 */
package com.moczul.ok2curl;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/moczul/ok2curl/LimitedSink;", "Lokio/Sink;", "limited", "Lokio/Buffer;", "limit", "", "(Lokio/Buffer;J)V", "total", "close", "", "flush", "timeout", "Lokio/Timeout;", "write", "source", "byteCount", "ok2curl"})
public final class LimitedSink
implements Sink {
    @NotNull
    private final Buffer limited;
    private long total;

    public LimitedSink(@NotNull Buffer limited, long limit) {
        Intrinsics.checkNotNullParameter((Object)limited, (String)"limited");
        if (!(limit > 0L)) {
            boolean bl = false;
            String string = "limit has to be grater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.limited = limited;
        this.total = limit;
    }

    public void write(@NotNull Buffer source, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.total > 0L) {
            long toWrite = Math.min(this.total, byteCount);
            this.limited.write(source, toWrite);
            this.total -= toWrite;
        }
    }

    public void flush() throws IOException {
        this.limited.flush();
    }

    @NotNull
    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void close() throws IOException {
        this.limited.close();
    }
}

