/*
 * Decompiled with CFR 0.152.
 */
package com.mreram.ticketview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import com.mreram.ticketview.R;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\u0018\u0000 ,2\u00020\u0001:\u0001,B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J$\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\fH\u0002J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010&\u001a\u00020\u0019H\u0014J\u001a\u0010'\u001a\u00020\u00192\b\u0010(\u001a\u0004\u0018\u00010\u001f2\b\u0010)\u001a\u0004\u0018\u00010\u001fJ\u000e\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\fR\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/mreram/ticketview/TicketView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "anchorViewId1", "anchorViewId2", "circlePosition1", "", "circlePosition2", "circleRadius", "circleSpace", "circlesPath", "Landroid/graphics/Path;", "dashColor", "dashPaint", "Landroid/graphics/Paint;", "dashPath", "dashSize", "eraser", "dispatchDraw", "", "canvas", "Landroid/graphics/Canvas;", "drawChild", "", "child", "Landroid/view/View;", "drawingTime", "", "drawHoles", "getDp", "value", "onDraw", "onFinishInflate", "setAnchor", "view1", "view2", "setRadius", "radius", "Companion", "ticketview_release"})
public final class TicketView
extends RelativeLayout {
    private final Paint eraser;
    private int anchorViewId1;
    private int anchorViewId2;
    private Path circlesPath;
    private float circlePosition1;
    private float circlePosition2;
    private float circleRadius;
    private float circleSpace;
    private int dashColor;
    private float dashSize;
    private final Path dashPath;
    private final Paint dashPaint;
    private static final float DEFAULT_RADIUS = 9.0f;
    private static final int NO_VALUE = -1;
    public static final Companion Companion = new Companion(null);

    public final void setRadius(float radius) {
        this.circleRadius = radius;
        this.postInvalidate();
    }

    public final void setAnchor(@Nullable View view1, @Nullable View view2) {
        Rect rect = new Rect();
        View view = view1;
        if (view != null) {
            view.getDrawingRect(rect);
        }
        this.offsetDescendantRectToMyCoords(view1, rect);
        this.circlePosition1 = rect.bottom;
        if (view2 != null) {
            view2.getDrawingRect(rect);
            this.offsetDescendantRectToMyCoords(view2, rect);
            this.circlePosition2 = rect.bottom;
        }
        this.postInvalidate();
    }

    protected boolean drawChild(@Nullable Canvas canvas, @Nullable View child, long drawingTime) {
        boolean drawChild = super.drawChild(canvas, child, drawingTime);
        Canvas canvas2 = canvas;
        if (canvas2 == null) {
            Intrinsics.throwNpe();
        }
        this.drawHoles(canvas2);
        return drawChild;
    }

    protected void dispatchDraw(@Nullable Canvas canvas) {
        block1: {
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.save();
            }
            super.dispatchDraw(canvas);
            Canvas canvas3 = canvas;
            if (canvas3 == null) break block1;
            canvas3.restore();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.anchorViewId1 != TicketView.Companion.getNO_VALUE() || this.anchorViewId2 != TicketView.Companion.getNO_VALUE()) {
            View anchorView1 = this.findViewById(this.anchorViewId1);
            View anchorView2 = this.findViewById(this.anchorViewId2);
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this, anchorView1, anchorView2){
                final /* synthetic */ TicketView this$0;
                final /* synthetic */ View $anchorView1;
                final /* synthetic */ View $anchorView2;

                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT >= 16) {
                        this.this$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        this.this$0.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    this.this$0.setAnchor(this.$anchorView1, this.$anchorView2);
                }
                {
                    this.this$0 = $outer;
                    this.$anchorView1 = $captured_local_variable$1;
                    this.$anchorView2 = $captured_local_variable$2;
                }
            });
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.drawHoles(canvas);
        super.onDraw(canvas);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawHoles(Canvas canvas) {
        Path i2;
        this.circlesPath = new Path();
        int w = this.getWidth();
        float radius = this.circleRadius;
        float space = this.circleSpace;
        float circleWidth = radius * (float)2;
        int leftMargin = 0;
        if (this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)layoutParams;
            leftMargin = lp.leftMargin;
        }
        int left = this.getLeft() - leftMargin;
        float circleSpace = circleWidth + space;
        int count = (int)((float)w / circleSpace);
        float offset = (float)w - circleSpace * (float)count;
        float sideOffset = offset / (float)2;
        float halfCircleSpace = circleSpace / (float)2;
        int n = 0;
        int n2 = count;
        while (n < n2) {
            void i2;
            float positionCircle = (float)i2 * circleSpace + sideOffset + (float)left - radius;
            if (i2 == false) {
                positionCircle = (float)left + sideOffset - radius;
            }
            this.circlesPath.addCircle(positionCircle + halfCircleSpace, -this.circleRadius / (float)4, radius, Path.Direction.CW);
            ++i2;
        }
        Path $receiver = i2 = this.circlesPath;
        $receiver.addCircle(-this.circleRadius / (float)4, this.circlePosition1, this.circleRadius, Path.Direction.CW);
        $receiver.addCircle((float)w + this.circleRadius / (float)4, this.circlePosition1, this.circleRadius, Path.Direction.CW);
        if (this.anchorViewId2 != TicketView.Companion.getNO_VALUE()) {
            $receiver.addCircle(-this.circleRadius / (float)4, this.circlePosition2, this.circleRadius, Path.Direction.CW);
            $receiver.addCircle((float)w + this.circleRadius / (float)4, this.circlePosition2, this.circleRadius, Path.Direction.CW);
        }
        $receiver = i2 = this.dashPath;
        $receiver.moveTo(this.circleRadius, this.circlePosition1);
        $receiver.quadTo((float)w - this.circleRadius, this.circlePosition1, (float)w - this.circleRadius, this.circlePosition1);
        if (this.anchorViewId2 != TicketView.Companion.getNO_VALUE()) {
            $receiver.moveTo(this.circleRadius, this.circlePosition2);
            $receiver.quadTo((float)w - this.circleRadius, this.circlePosition2, (float)w - this.circleRadius, this.circlePosition2);
        }
        Canvas $receiver2 = canvas;
        if (this.dashSize > 0.0f) {
            $receiver2.drawPath(this.dashPath, this.dashPaint);
        }
        $receiver2.drawPath(this.circlesPath, this.eraser);
    }

    private final int getDp(float value) {
        int n;
        float f = value;
        if (f == 0.0f) {
            n = 0;
        } else {
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            float density = resources.getDisplayMetrics().density;
            n = (int)Math.ceil(density * value);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public TicketView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.eraser = new Paint(1);
        this.circlesPath = new Path();
        this.dashPath = new Path();
        this.dashPaint = new Paint(1);
        this.setLayerType(2, null);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TicketView);
        try {
            this.circleRadius = a.getDimension(R.styleable.TicketView_tv_circleRadius, (float)this.getDp(TicketView.Companion.getDEFAULT_RADIUS()));
            this.anchorViewId1 = a.getResourceId(R.styleable.TicketView_tv_anchor1, TicketView.Companion.getNO_VALUE());
            this.anchorViewId2 = a.getResourceId(R.styleable.TicketView_tv_anchor2, TicketView.Companion.getNO_VALUE());
            this.circleSpace = a.getDimension(R.styleable.TicketView_tv_circleSpace, (float)this.getDp(15.0f));
            this.dashColor = a.getColor(R.styleable.TicketView_tv_dashColor, Color.parseColor((String)"#0085be"));
            this.dashSize = a.getDimension(R.styleable.TicketView_tv_dashSize, (float)this.getDp(1.5f));
        }
        finally {
            a.recycle();
        }
        this.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.dashPaint.setColor(this.dashColor);
        this.dashPaint.setStyle(Paint.Style.STROKE);
        this.dashPaint.setStrokeWidth(this.dashSize);
        this.dashPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{this.getDp(3.0f), this.getDp(3.0f)}, 0.0f));
    }

    @JvmOverloads
    public /* synthetic */ TicketView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public TicketView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TicketView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        DEFAULT_RADIUS = 9.0f;
        NO_VALUE = -1;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/mreram/ticketview/TicketView$Companion;", "", "()V", "DEFAULT_RADIUS", "", "getDEFAULT_RADIUS", "()F", "NO_VALUE", "", "getNO_VALUE", "()I", "ticketview_release"})
    public static final class Companion {
        private final float getDEFAULT_RADIUS() {
            return DEFAULT_RADIUS;
        }

        private final int getNO_VALUE() {
            return NO_VALUE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

