/*
 * Decompiled with CFR 0.152.
 */
package smartdevelop.ir.eram.showcaseviewlib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Spannable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

class GuideMessageView
extends LinearLayout {
    private Paint mPaint;
    private RectF mRect;
    private TextView mTitleTextView;
    private TextView mContentTextView;
    float density;
    int[] location = new int[2];

    GuideMessageView(Context context) {
        super(context);
        this.density = context.getResources().getDisplayMetrics().density;
        this.setWillNotDraw(false);
        this.mRect = new RectF();
        this.mPaint = new Paint(1);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.setLayerType(1, null);
        this.setOrientation(1);
        this.setGravity(17);
        int padding = (int)(10.0f * this.density);
        int paddingBetween = (int)(3.0f * this.density);
        this.mTitleTextView = new TextView(context);
        this.mTitleTextView.setPadding(padding, padding, padding, paddingBetween);
        this.mTitleTextView.setGravity(17);
        this.mTitleTextView.setTextSize(1, 18.0f);
        this.mTitleTextView.setTextColor(-16777216);
        this.addView((View)this.mTitleTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.mContentTextView = new TextView(context);
        this.mContentTextView.setTextColor(-16777216);
        this.mContentTextView.setTextSize(1, 14.0f);
        this.mContentTextView.setPadding(padding, paddingBetween, padding, padding);
        this.mContentTextView.setGravity(17);
        this.addView((View)this.mContentTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
    }

    public void setTitle(String title) {
        if (title == null) {
            this.removeView((View)this.mTitleTextView);
            return;
        }
        this.mTitleTextView.setText((CharSequence)title);
    }

    public void setContentText(String content) {
        this.mContentTextView.setText((CharSequence)content);
    }

    public void setContentSpan(Spannable content) {
        this.mContentTextView.setText((CharSequence)content);
    }

    public void setContentTypeFace(Typeface typeFace) {
        this.mContentTextView.setTypeface(typeFace);
    }

    public void setTitleTypeFace(Typeface typeFace) {
        this.mTitleTextView.setTypeface(typeFace);
    }

    public void setTitleTextSize(int size) {
        this.mTitleTextView.setTextSize(2, (float)size);
    }

    public void setContentTextSize(int size) {
        this.mContentTextView.setTextSize(2, (float)size);
    }

    public void setColor(int color) {
        this.mPaint.setAlpha(255);
        this.mPaint.setColor(color);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.getLocationOnScreen(this.location);
        this.mRect.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(canvas.getWidth() - this.getPaddingRight()), (float)(canvas.getHeight() - this.getPaddingBottom()));
        canvas.drawRoundRect(this.mRect, 15.0f, 15.0f, this.mPaint);
    }
}

