/*
 * Decompiled with CFR 0.152.
 */
package moxy.compiler.presenterbinder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import moxy.MvpPresenter;
import moxy.PresenterBinder;
import moxy.compiler.ExtensionsKt;
import moxy.compiler.JavaFilesGenerator;
import moxy.compiler.Util;
import moxy.compiler.presenterbinder.TargetClassInfo;
import moxy.compiler.presenterbinder.TargetPresenterField;
import moxy.presenter.PresenterField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c*\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\u001e"}, d2={"Lmoxy/compiler/presenterbinder/PresenterBinderClassGenerator;", "Lmoxy/compiler/JavaFilesGenerator;", "Lmoxy/compiler/presenterbinder/TargetClassInfo;", "()V", "generate", "", "Lcom/squareup/javapoet/JavaFile;", "targetClassInfo", "generateBindMethod", "Lcom/squareup/javapoet/MethodSpec;", "field", "Lmoxy/compiler/presenterbinder/TargetPresenterField;", "targetClassName", "Lcom/squareup/javapoet/ClassName;", "generateGetPresentersMethod", "fields", "containerClassName", "superPresenterBinder", "Ljavax/lang/model/element/TypeElement;", "generateGetTagMethod", "tagProviderMethodName", "", "generatePresenterBinderClass", "Lcom/squareup/javapoet/TypeSpec;", "generatePresenterBinderConstructor", "tag", "generateProvidePresenterMethod", "addOptionalMethod", "Lcom/squareup/javapoet/TypeSpec$Builder;", "methodSpec", "moxy-compiler"})
public final class PresenterBinderClassGenerator
implements JavaFilesGenerator<TargetClassInfo> {
    @Override
    @NotNull
    public List<JavaFile> generate(@NotNull TargetClassInfo targetClassInfo) {
        Intrinsics.checkNotNullParameter((Object)targetClassInfo, (String)"targetClassInfo");
        ClassName targetClassName = targetClassInfo.getName();
        List<TargetPresenterField> fields = targetClassInfo.getFields();
        TypeElement superPresenterBinder = targetClassInfo.getSuperPresenterBinder();
        List list = targetClassName.simpleNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"targetClassName.simpleNames()");
        String containerSimpleName = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"$", null, null, (int)0, null, null, (int)62, null);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)(containerSimpleName + "$$PresentersBinder")).addOriginatingElement(targetClassInfo.getElement()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ExtensionsKt.parametrizedWith(ExtensionsKt.className(Reflection.getOrCreateKotlinClass(PresenterBinder.class)), (TypeName)targetClassName));
        for (TargetPresenterField field : fields) {
            classBuilder.addType(this.generatePresenterBinderClass(field, targetClassName));
        }
        classBuilder.addMethod(this.generateGetPresentersMethod(fields, targetClassName, superPresenterBinder));
        TypeSpec typeSpec = classBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"classBuilder.build()");
        return CollectionsKt.listOf((Object)ExtensionsKt.toJavaFile(typeSpec, targetClassName));
    }

    private final MethodSpec generateGetPresentersMethod(List<TargetPresenterField> fields, ClassName containerClassName, TypeElement superPresenterBinder) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getPresenterFields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ClassName className = ExtensionsKt.className(Reflection.getOrCreateKotlinClass(List.class));
        ParameterizedTypeName parameterizedTypeName = ExtensionsKt.parametrizedWith(ExtensionsKt.className(Reflection.getOrCreateKotlinClass(PresenterField.class)), (TypeName)ExtensionsKt.supertypeWildcard(containerClassName));
        Intrinsics.checkNotNullExpressionValue((Object)parameterizedTypeName, (String)"PresenterField::class.cl\u2026d()\n                    )");
        MethodSpec.Builder builder2 = builder.returns((TypeName)ExtensionsKt.parametrizedWith(className, (TypeName)parameterizedTypeName));
        builder2.addStatement("$1T<$2T<$3T>> presenters = new $4T<>($5L)", new Object[]{List.class, PresenterField.class, ExtensionsKt.supertypeWildcard(containerClassName), ArrayList.class, fields.size()});
        for (TargetPresenterField field : fields) {
            builder2.addStatement("presenters.add(new $1L())", new Object[]{field.getGeneratedClassName()});
        }
        if (superPresenterBinder != null) {
            builder2.addStatement("presenters.addAll(new $1L().getPresenterFields())", new Object[]{superPresenterBinder.getQualifiedName().toString() + "$$PresentersBinder"});
        }
        builder2.addStatement("return presenters", new Object[0]);
        MethodSpec methodSpec = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"builder.build()");
        return methodSpec;
    }

    private final TypeSpec generatePresenterBinderClass(TargetPresenterField field, ClassName targetClassName) {
        String string = field.getTag();
        if (string == null) {
            string = field.getName();
        }
        String tag2 = string;
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)field.getGeneratedClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ExtensionsKt.parametrizedWith(ExtensionsKt.className(Reflection.getOrCreateKotlinClass(PresenterField.class)), (TypeName)targetClassName)).addMethod(this.generatePresenterBinderConstructor(field, tag2)).addMethod(this.generateBindMethod(field, targetClassName)).addMethod(this.generateProvidePresenterMethod(field, targetClassName));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"TypeSpec.classBuilder(fi\u2026(field, targetClassName))");
        TypeSpec typeSpec = this.addOptionalMethod(builder, this.generateGetTagMethod(field.getPresenterTagProviderMethodName(), targetClassName)).build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"TypeSpec.classBuilder(fi\u2026me))\n            .build()");
        return typeSpec;
    }

    private final MethodSpec generateGetTagMethod(String tagProviderMethodName, ClassName targetClassName) {
        if (tagProviderMethodName == null) {
            return null;
        }
        return MethodSpec.methodBuilder((String)"getTag").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((Type)((Object)String.class)).addParameter((TypeName)targetClassName, "delegated", new Modifier[0]).addStatement("return String.valueOf(delegated.$1L())", new Object[]{tagProviderMethodName}).build();
    }

    private final MethodSpec generatePresenterBinderConstructor(TargetPresenterField field, String tag2) {
        MethodSpec methodSpec = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($1S, $2S, $3T.class)", new Object[]{tag2, field.getPresenterId(), field.getTypeName()}).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"MethodSpec.constructorBu\u2026ame)\n            .build()");
        return methodSpec;
    }

    private final MethodSpec generateBindMethod(TargetPresenterField field, ClassName targetClassName) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"bind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)targetClassName, "target", new Modifier[0]).addParameter((Type)((Object)MvpPresenter.class), "presenter", new Modifier[0]).addStatement("target.$1L = ($2T) presenter", new Object[]{field.getName(), field.getTypeName()}).build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"MethodSpec.methodBuilder\u2026ame)\n            .build()");
        return methodSpec;
    }

    private final MethodSpec generateProvidePresenterMethod(TargetPresenterField field, ClassName targetClassName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"providePresenter").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ExtensionsKt.parametrizedWith(ExtensionsKt.className(Reflection.getOrCreateKotlinClass(MvpPresenter.class)), (TypeName)ExtensionsKt.subtypeWildcard(Reflection.getOrCreateKotlinClass(Object.class)))).addParameter((TypeName)targetClassName, "delegated", new Modifier[0]);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"MethodSpec.methodBuilder\u2026etClassName, \"delegated\")");
        MethodSpec.Builder builder2 = builder;
        if (field.getPresenterProviderMethodName() != null) {
            builder2.addStatement("return delegated.$1L()", new Object[]{field.getPresenterProviderMethodName()});
        } else {
            boolean hasEmptyConstructor = Util.hasEmptyConstructor(ExtensionsKt.asTypeElement(field.getType()));
            if (hasEmptyConstructor) {
                builder2.addStatement("return new $1T()", new Object[]{field.getTypeName()});
            } else {
                builder2.addStatement("throw new $1T($2S + $3S)", new Object[]{IllegalStateException.class, field.getType(), " hasn't got a default constructor. You can apply @ProvidePresenter to a method which will construct Presenter. Otherwise you can add empty constructor to presenter."});
            }
        }
        MethodSpec methodSpec = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"builder.build()");
        return methodSpec;
    }

    private final TypeSpec.Builder addOptionalMethod(TypeSpec.Builder $this$addOptionalMethod, MethodSpec methodSpec) {
        TypeSpec.Builder builder;
        if (methodSpec != null) {
            TypeSpec.Builder builder2 = $this$addOptionalMethod.addMethod(methodSpec);
            builder = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"addMethod(methodSpec)");
        } else {
            builder = $this$addOptionalMethod;
        }
        return builder;
    }
}

