/*
 * Decompiled with CFR 0.152.
 */
package moxy.compiler.presenterbinder;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import moxy.compiler.ElementProcessor;
import moxy.compiler.Util;
import moxy.compiler.presenterbinder.PresenterProviderMethod;
import moxy.compiler.presenterbinder.TagProviderMethod;
import moxy.compiler.presenterbinder.TargetClassInfo;
import moxy.compiler.presenterbinder.TargetPresenterField;
import moxy.presenter.InjectPresenter;
import moxy.presenter.ProvidePresenter;
import moxy.presenter.ProvidePresenterTag;

public class InjectPresenterProcessor
extends ElementProcessor<VariableElement, TargetClassInfo> {
    private static final String PRESENTER_FIELD_ANNOTATION = InjectPresenter.class.getName();
    private static final String PROVIDE_PRESENTER_ANNOTATION = ProvidePresenter.class.getName();
    private static final String PROVIDE_PRESENTER_TAG_ANNOTATION = ProvidePresenterTag.class.getName();
    private final List<TypeElement> presentersContainers = new ArrayList<TypeElement>();

    private static List<TargetPresenterField> collectFields(TypeElement presentersContainer) {
        ArrayList<TargetPresenterField> fields = new ArrayList<TargetPresenterField>();
        for (Element element : presentersContainer.getEnclosedElements()) {
            AnnotationMirror annotation;
            if (element.getKind() != ElementKind.FIELD || (annotation = Util.getAnnotation(element, PRESENTER_FIELD_ANNOTATION)) == null) continue;
            TypeMirror clazz = ((DeclaredType)element.asType()).asElement().asType();
            String name = element.toString();
            String tag = Util.getAnnotationValueAsString(annotation, "tag");
            String presenterId = Util.getAnnotationValueAsString(annotation, "presenterId");
            TargetPresenterField field = new TargetPresenterField(clazz, name, tag, presenterId);
            fields.add(field);
        }
        return fields;
    }

    private static List<PresenterProviderMethod> collectPresenterProviders(TypeElement presentersContainer) {
        ArrayList<PresenterProviderMethod> providers = new ArrayList<PresenterProviderMethod>();
        for (Element element : presentersContainer.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement providerMethod = (ExecutableElement)element;
            AnnotationMirror annotation = Util.getAnnotation(element, PROVIDE_PRESENTER_ANNOTATION);
            if (annotation == null) continue;
            String name = providerMethod.getSimpleName().toString();
            DeclaredType kind = (DeclaredType)providerMethod.getReturnType();
            String tag = Util.getAnnotationValueAsString(annotation, "tag");
            String presenterId = Util.getAnnotationValueAsString(annotation, "presenterId");
            providers.add(new PresenterProviderMethod(kind, name, tag, presenterId));
        }
        return providers;
    }

    private static List<TagProviderMethod> collectTagProviders(TypeElement presentersContainer) {
        ArrayList<TagProviderMethod> providers = new ArrayList<TagProviderMethod>();
        for (Element element : presentersContainer.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement providerMethod = (ExecutableElement)element;
            AnnotationMirror annotation = Util.getAnnotation(element, PROVIDE_PRESENTER_TAG_ANNOTATION);
            if (annotation == null) continue;
            String name = providerMethod.getSimpleName().toString();
            TypeMirror presenterClass = Util.getAnnotationValueAsTypeMirror(annotation, "presenterClass");
            String type = Util.getAnnotationValueAsString(annotation, "type");
            String presenterId = Util.getAnnotationValueAsString(annotation, "presenterId");
            providers.add(new TagProviderMethod(presenterClass, name, type, presenterId));
        }
        return providers;
    }

    private static void bindProvidersToFields(List<TargetPresenterField> fields, List<PresenterProviderMethod> presenterProviders) {
        if (fields.isEmpty() || presenterProviders.isEmpty()) {
            return;
        }
        for (PresenterProviderMethod presenterProvider : presenterProviders) {
            TypeMirror providerTypeMirror = presenterProvider.getClazz().asElement().asType();
            for (TargetPresenterField field : fields) {
                if (!field.getClazz().equals(providerTypeMirror) || field.getTag() == null && presenterProvider.getTag() != null || field.getTag() != null && !field.getTag().equals(presenterProvider.getTag()) || field.getPresenterId() == null && presenterProvider.getPresenterId() != null || field.getPresenterId() != null && !field.getPresenterId().equals(presenterProvider.getPresenterId())) continue;
                field.setPresenterProviderMethodName(presenterProvider.getName());
            }
        }
    }

    private static void bindTagProvidersToFields(List<TargetPresenterField> fields, List<TagProviderMethod> tagProviders) {
        if (fields.isEmpty() || tagProviders.isEmpty()) {
            return;
        }
        for (TagProviderMethod tagProvider : tagProviders) {
            for (TargetPresenterField field : fields) {
                if (!field.getClazz().equals(tagProvider.getPresenterClass()) || field.getPresenterId() == null && tagProvider.getPresenterId() != null || field.getPresenterId() != null && !field.getPresenterId().equals(tagProvider.getPresenterId())) continue;
                field.setPresenterTagProviderMethodName(tagProvider.getMethodName());
            }
        }
    }

    @Override
    public TargetClassInfo process(VariableElement variableElement) {
        Element enclosingElement = variableElement.getEnclosingElement();
        if (!(enclosingElement instanceof TypeElement)) {
            throw new RuntimeException("Only class fields could be annotated as @InjectPresenter: " + variableElement + " at " + enclosingElement);
        }
        if (this.presentersContainers.contains(enclosingElement)) {
            return null;
        }
        TypeElement presentersContainer = (TypeElement)enclosingElement;
        this.presentersContainers.add(presentersContainer);
        List<TargetPresenterField> fields = InjectPresenterProcessor.collectFields(presentersContainer);
        InjectPresenterProcessor.bindProvidersToFields(fields, InjectPresenterProcessor.collectPresenterProviders(presentersContainer));
        InjectPresenterProcessor.bindTagProvidersToFields(fields, InjectPresenterProcessor.collectTagProviders(presentersContainer));
        return new TargetClassInfo(presentersContainer, fields, this.findSuperPresenterContainer(presentersContainer));
    }

    private TypeElement findSuperPresenterContainer(TypeElement typeElement) {
        TypeElement currentTypeElement = typeElement;
        while (currentTypeElement != null) {
            TypeMirror superclass = currentTypeElement.getSuperclass();
            if (superclass.getKind() == TypeKind.DECLARED) {
                DeclaredType superType = (DeclaredType)superclass;
                currentTypeElement = (TypeElement)superType.asElement();
            } else {
                currentTypeElement = null;
            }
            if (currentTypeElement == null) continue;
            for (Element element : currentTypeElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD || element.getAnnotation(InjectPresenter.class) == null) continue;
                return currentTypeElement;
            }
        }
        return null;
    }
}

