/*
 * Decompiled with CFR 0.152.
 */
package com.github.mowedgrass.jasyptgradleboot.password.property;

import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.env.StandardEnvironment;

public class PropertyResolver {
    private StandardEnvironment environment;

    public PropertyResolver(StandardEnvironment environment) {
        this.environment = environment;
    }

    public Optional<String> getEnvironmentProperty(String key) {
        return this.getProperty(arg_0 -> ((StandardEnvironment)this.environment).getProperty(arg_0), key);
    }

    public Optional<String> getSystemProperty(String key) {
        return this.getProperty(property -> (String)this.environment.getSystemEnvironment().get(property), key);
    }

    private Optional<String> getProperty(Function<String, String> source, String key) {
        return Optional.ofNullable(source.apply(key)).filter(s -> !s.isEmpty());
    }
}

