/*
 * Decompiled with CFR 0.152.
 */
package com.github.mowedgrass.jasyptgradleboot.encryptor.configuration;

import com.github.mowedgrass.jasyptgradleboot.encryptor.configuration.ConfigurationProperty;
import com.github.mowedgrass.jasyptgradleboot.encryptor.configuration.provider.ConfigurationProvider;
import com.github.mowedgrass.jasyptgradleboot.password.PasswordProvider;
import java.util.Optional;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;

public class ConfigurationFactory {
    private PasswordProvider passwordProvider;
    private ConfigurationProvider configurationProvider;

    public ConfigurationFactory(PasswordProvider passwordProvider, ConfigurationProvider configurationProvider) {
        this.passwordProvider = passwordProvider;
        this.configurationProvider = configurationProvider;
    }

    public PBEConfig create() {
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(this.passwordProvider.getPassword());
        config.setAlgorithm(this.getValue(ConfigurationProperty.ALGORITHM));
        config.setKeyObtentionIterations(this.getValue(ConfigurationProperty.KEY_OBTENTION_ITERATIONS));
        config.setPoolSize(this.getValue(ConfigurationProperty.POOL_SIZE));
        config.setProviderName(this.getValue(ConfigurationProperty.PROVIDER_NAME));
        config.setSaltGeneratorClassName(this.getValue(ConfigurationProperty.SALT_GENERATOR));
        config.setStringOutputType(this.getValue(ConfigurationProperty.OUTPUT_TYPE));
        return config;
    }

    private String getValue(ConfigurationProperty property) {
        return Optional.ofNullable(this.configurationProvider.getProperty(property)).orElse(property.getDefaultValue());
    }
}

