/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;
import io.swagger.client.model.CreatingACustomFieldRequest;
import io.swagger.client.model.CreatingACustomFieldResponse;
import io.swagger.client.model.CreatingAMailingListRequest;
import io.swagger.client.model.CreatingAMailingListResponse;
import io.swagger.client.model.DeletingAMailingListResponse;
import io.swagger.client.model.GettingAllActiveMailingListsResponse;
import io.swagger.client.model.GettingAllActiveMailingListsWithPagingResponse;
import io.swagger.client.model.GettingMailingListDetailsResponse;
import io.swagger.client.model.RemovingACustomFieldResponse;
import io.swagger.client.model.UpdatingACustomFieldRequest;
import io.swagger.client.model.UpdatingACustomFieldResponse;
import io.swagger.client.model.UpdatingAMailingListRequest;
import io.swagger.client.model.UpdatingAMailingListResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class MailingListsApi {
    private ApiClient apiClient;

    public MailingListsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MailingListsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call creatingACustomFieldCall(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreatingACustomFieldRequest localVarPostBody = body;
        String localVarPath = "/lists/{MailingListID}/customfields/create.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call creatingACustomFieldValidateBeforeCall(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling creatingACustomField(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling creatingACustomField(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling creatingACustomField(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling creatingACustomField(Async)");
        }
        Call call = this.creatingACustomFieldCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;
    }

    public CreatingACustomFieldResponse creatingACustomField(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body) throws ApiException {
        ApiResponse<CreatingACustomFieldResponse> resp = this.creatingACustomFieldWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    public ApiResponse<CreatingACustomFieldResponse> creatingACustomFieldWithHttpInfo(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body) throws ApiException {
        Call call = this.creatingACustomFieldValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<CreatingACustomFieldResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call creatingACustomFieldAsync(String format, String apikey, String mailingListID, CreatingACustomFieldRequest body, final ApiCallback<CreatingACustomFieldResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.creatingACustomFieldValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatingACustomFieldResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call creatingAMailingListCall(String format, String apikey, CreatingAMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CreatingAMailingListRequest localVarPostBody = body;
        String localVarPath = "/lists/create.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call creatingAMailingListValidateBeforeCall(String format, String apikey, CreatingAMailingListRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling creatingAMailingList(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling creatingAMailingList(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling creatingAMailingList(Async)");
        }
        Call call = this.creatingAMailingListCall(format, apikey, body, progressListener, progressRequestListener);
        return call;
    }

    public CreatingAMailingListResponse creatingAMailingList(String format, String apikey, CreatingAMailingListRequest body) throws ApiException {
        ApiResponse<CreatingAMailingListResponse> resp = this.creatingAMailingListWithHttpInfo(format, apikey, body);
        return resp.getData();
    }

    public ApiResponse<CreatingAMailingListResponse> creatingAMailingListWithHttpInfo(String format, String apikey, CreatingAMailingListRequest body) throws ApiException {
        Call call = this.creatingAMailingListValidateBeforeCall(format, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<CreatingAMailingListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call creatingAMailingListAsync(String format, String apikey, CreatingAMailingListRequest body, final ApiCallback<CreatingAMailingListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.creatingAMailingListValidateBeforeCall(format, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatingAMailingListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deletingAMailingListCall(String format, String apikey, String mailingListID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{MailingListID}/delete.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deletingAMailingListValidateBeforeCall(String format, String apikey, String mailingListID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling deletingAMailingList(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling deletingAMailingList(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling deletingAMailingList(Async)");
        }
        Call call = this.deletingAMailingListCall(format, apikey, mailingListID, progressListener, progressRequestListener);
        return call;
    }

    public DeletingAMailingListResponse deletingAMailingList(String format, String apikey, String mailingListID) throws ApiException {
        ApiResponse<DeletingAMailingListResponse> resp = this.deletingAMailingListWithHttpInfo(format, apikey, mailingListID);
        return resp.getData();
    }

    public ApiResponse<DeletingAMailingListResponse> deletingAMailingListWithHttpInfo(String format, String apikey, String mailingListID) throws ApiException {
        Call call = this.deletingAMailingListValidateBeforeCall(format, apikey, mailingListID, null, null);
        Type localVarReturnType = new TypeToken<DeletingAMailingListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deletingAMailingListAsync(String format, String apikey, String mailingListID, final ApiCallback<DeletingAMailingListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deletingAMailingListValidateBeforeCall(format, apikey, mailingListID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeletingAMailingListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingAllActiveMailingListsCall(String format, String apikey, String withStatistics, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        if (withStatistics != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "WithStatistics", withStatistics));
        }
        if (shortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ShortBy", shortBy));
        }
        if (sortMethod != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "SortMethod", sortMethod));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingAllActiveMailingListsValidateBeforeCall(String format, String apikey, String withStatistics, String shortBy, String sortMethod, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingAllActiveMailingLists(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingAllActiveMailingLists(Async)");
        }
        Call call = this.gettingAllActiveMailingListsCall(format, apikey, withStatistics, shortBy, sortMethod, progressListener, progressRequestListener);
        return call;
    }

    public GettingAllActiveMailingListsResponse gettingAllActiveMailingLists(String format, String apikey, String withStatistics, String shortBy, String sortMethod) throws ApiException {
        ApiResponse<GettingAllActiveMailingListsResponse> resp = this.gettingAllActiveMailingListsWithHttpInfo(format, apikey, withStatistics, shortBy, sortMethod);
        return resp.getData();
    }

    public ApiResponse<GettingAllActiveMailingListsResponse> gettingAllActiveMailingListsWithHttpInfo(String format, String apikey, String withStatistics, String shortBy, String sortMethod) throws ApiException {
        Call call = this.gettingAllActiveMailingListsValidateBeforeCall(format, apikey, withStatistics, shortBy, sortMethod, null, null);
        Type localVarReturnType = new TypeToken<GettingAllActiveMailingListsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingAllActiveMailingListsAsync(String format, String apikey, String withStatistics, String shortBy, String sortMethod, final ApiCallback<GettingAllActiveMailingListsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingAllActiveMailingListsValidateBeforeCall(format, apikey, withStatistics, shortBy, sortMethod, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingAllActiveMailingListsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingAllActiveMailingListsWithPagingCall(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{Page}/{PageSize}.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{Page\\}", this.apiClient.escapeString(page.toString())).replaceAll("\\{PageSize\\}", this.apiClient.escapeString(pageSize.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        if (shortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ShortBy", shortBy));
        }
        if (sortMethod != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "SortMethod", sortMethod));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingAllActiveMailingListsWithPagingValidateBeforeCall(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingAllActiveMailingListsWithPaging(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingAllActiveMailingListsWithPaging(Async)");
        }
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling gettingAllActiveMailingListsWithPaging(Async)");
        }
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling gettingAllActiveMailingListsWithPaging(Async)");
        }
        Call call = this.gettingAllActiveMailingListsWithPagingCall(format, apikey, page, pageSize, shortBy, sortMethod, progressListener, progressRequestListener);
        return call;
    }

    public GettingAllActiveMailingListsWithPagingResponse gettingAllActiveMailingListsWithPaging(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod) throws ApiException {
        ApiResponse<GettingAllActiveMailingListsWithPagingResponse> resp = this.gettingAllActiveMailingListsWithPagingWithHttpInfo(format, apikey, page, pageSize, shortBy, sortMethod);
        return resp.getData();
    }

    public ApiResponse<GettingAllActiveMailingListsWithPagingResponse> gettingAllActiveMailingListsWithPagingWithHttpInfo(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod) throws ApiException {
        Call call = this.gettingAllActiveMailingListsWithPagingValidateBeforeCall(format, apikey, page, pageSize, shortBy, sortMethod, null, null);
        Type localVarReturnType = new TypeToken<GettingAllActiveMailingListsWithPagingResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingAllActiveMailingListsWithPagingAsync(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ApiCallback<GettingAllActiveMailingListsWithPagingResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingAllActiveMailingListsWithPagingValidateBeforeCall(format, apikey, page, pageSize, shortBy, sortMethod, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingAllActiveMailingListsWithPagingResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call gettingMailingListDetailsCall(String format, String mailingListID, String apikey, String withStatistics, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{MailingListID}/details.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        if (withStatistics != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "WithStatistics", withStatistics));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call gettingMailingListDetailsValidateBeforeCall(String format, String mailingListID, String apikey, String withStatistics, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingMailingListDetails(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingMailingListDetails(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingMailingListDetails(Async)");
        }
        Call call = this.gettingMailingListDetailsCall(format, mailingListID, apikey, withStatistics, progressListener, progressRequestListener);
        return call;
    }

    public GettingMailingListDetailsResponse gettingMailingListDetails(String format, String mailingListID, String apikey, String withStatistics) throws ApiException {
        ApiResponse<GettingMailingListDetailsResponse> resp = this.gettingMailingListDetailsWithHttpInfo(format, mailingListID, apikey, withStatistics);
        return resp.getData();
    }

    public ApiResponse<GettingMailingListDetailsResponse> gettingMailingListDetailsWithHttpInfo(String format, String mailingListID, String apikey, String withStatistics) throws ApiException {
        Call call = this.gettingMailingListDetailsValidateBeforeCall(format, mailingListID, apikey, withStatistics, null, null);
        Type localVarReturnType = new TypeToken<GettingMailingListDetailsResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call gettingMailingListDetailsAsync(String format, String mailingListID, String apikey, String withStatistics, final ApiCallback<GettingMailingListDetailsResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.gettingMailingListDetailsValidateBeforeCall(format, mailingListID, apikey, withStatistics, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingMailingListDetailsResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call removingACustomFieldCall(String format, String customFieldID, String apikey, String mailingListID, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/lists/{MailingListID}/customfields/{CustomFieldID}/delete.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CustomFieldID\\}", this.apiClient.escapeString(customFieldID.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call removingACustomFieldValidateBeforeCall(String format, String customFieldID, String apikey, String mailingListID, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling removingACustomField(Async)");
        }
        if (customFieldID == null) {
            throw new ApiException("Missing the required parameter 'customFieldID' when calling removingACustomField(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling removingACustomField(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling removingACustomField(Async)");
        }
        Call call = this.removingACustomFieldCall(format, customFieldID, apikey, mailingListID, progressListener, progressRequestListener);
        return call;
    }

    public RemovingACustomFieldResponse removingACustomField(String format, String customFieldID, String apikey, String mailingListID) throws ApiException {
        ApiResponse<RemovingACustomFieldResponse> resp = this.removingACustomFieldWithHttpInfo(format, customFieldID, apikey, mailingListID);
        return resp.getData();
    }

    public ApiResponse<RemovingACustomFieldResponse> removingACustomFieldWithHttpInfo(String format, String customFieldID, String apikey, String mailingListID) throws ApiException {
        Call call = this.removingACustomFieldValidateBeforeCall(format, customFieldID, apikey, mailingListID, null, null);
        Type localVarReturnType = new TypeToken<RemovingACustomFieldResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call removingACustomFieldAsync(String format, String customFieldID, String apikey, String mailingListID, final ApiCallback<RemovingACustomFieldResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.removingACustomFieldValidateBeforeCall(format, customFieldID, apikey, mailingListID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<RemovingACustomFieldResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatingACustomFieldCall(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdatingACustomFieldRequest localVarPostBody = body;
        String localVarPath = "/lists/{MailingListID}/customfields/{CustomFieldID}/update.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{CustomFieldID\\}", this.apiClient.escapeString(customFieldID.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatingACustomFieldValidateBeforeCall(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingACustomField(Async)");
        }
        if (customFieldID == null) {
            throw new ApiException("Missing the required parameter 'customFieldID' when calling updatingACustomField(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingACustomField(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingACustomField(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingACustomField(Async)");
        }
        Call call = this.updatingACustomFieldCall(format, customFieldID, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;
    }

    public UpdatingACustomFieldResponse updatingACustomField(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body) throws ApiException {
        ApiResponse<UpdatingACustomFieldResponse> resp = this.updatingACustomFieldWithHttpInfo(format, customFieldID, apikey, mailingListID, body);
        return resp.getData();
    }

    public ApiResponse<UpdatingACustomFieldResponse> updatingACustomFieldWithHttpInfo(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body) throws ApiException {
        Call call = this.updatingACustomFieldValidateBeforeCall(format, customFieldID, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingACustomFieldResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatingACustomFieldAsync(String format, String customFieldID, String apikey, String mailingListID, UpdatingACustomFieldRequest body, final ApiCallback<UpdatingACustomFieldResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatingACustomFieldValidateBeforeCall(format, customFieldID, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingACustomFieldResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatingAMailingListCall(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UpdatingAMailingListRequest localVarPostBody = body;
        String localVarPath = "/lists/{MailingListID}/update.{Format}".replaceAll("\\{Format\\}", this.apiClient.escapeString(format.toString())).replaceAll("\\{MailingListID\\}", this.apiClient.escapeString(mailingListID.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "apikey", apikey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatingAMailingListValidateBeforeCall(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingAMailingList(Async)");
        }
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingAMailingList(Async)");
        }
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingAMailingList(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingAMailingList(Async)");
        }
        Call call = this.updatingAMailingListCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        return call;
    }

    public UpdatingAMailingListResponse updatingAMailingList(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body) throws ApiException {
        ApiResponse<UpdatingAMailingListResponse> resp = this.updatingAMailingListWithHttpInfo(format, apikey, mailingListID, body);
        return resp.getData();
    }

    public ApiResponse<UpdatingAMailingListResponse> updatingAMailingListWithHttpInfo(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body) throws ApiException {
        Call call = this.updatingAMailingListValidateBeforeCall(format, apikey, mailingListID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingAMailingListResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatingAMailingListAsync(String format, String apikey, String mailingListID, UpdatingAMailingListRequest body, final ApiCallback<UpdatingAMailingListResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatingAMailingListValidateBeforeCall(format, apikey, mailingListID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingAMailingListResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

