/*
 * Moosend API
 * TODO: Add a description
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.AddingCriteriaToSegmentsRequest;
import io.swagger.client.model.AddingCriteriaToSegmentsResponse;
import io.swagger.client.model.CreatingANewSegmentRequest;
import io.swagger.client.model.CreatingANewSegmentResponse;
import io.swagger.client.model.DeletingASegmentResponse;
import io.swagger.client.model.GettingSegmentDetailsResponse;
import io.swagger.client.model.GettingSegmentSubscribersResponse;
import io.swagger.client.model.GettingSegmentsResponse;
import io.swagger.client.model.UpdatingASegmentRequest;
import io.swagger.client.model.UpdatingASegmentResponse;
import io.swagger.client.model.UpdatingSegmentCriteriaRequest;
import io.swagger.client.model.UpdatingSegmentCriteriaResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SegmentsApi {
    private ApiClient apiClient;

    public SegmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SegmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for addingCriteriaToSegments
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addingCriteriaToSegmentsCall(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/criteria/add.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "SegmentID" + "\\}", apiClient.escapeString(segmentID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addingCriteriaToSegmentsValidateBeforeCall(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling addingCriteriaToSegments(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling addingCriteriaToSegments(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling addingCriteriaToSegments(Async)");
        }
        
        // verify the required parameter 'segmentID' is set
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling addingCriteriaToSegments(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling addingCriteriaToSegments(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addingCriteriaToSegmentsCall(format, mailingListID, apikey, segmentID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Adding criteria to segments
     * Adds a new criterion (a rule) to the specified segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param body  (required)
     * @return AddingCriteriaToSegmentsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AddingCriteriaToSegmentsResponse addingCriteriaToSegments(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body) throws ApiException {
        ApiResponse<AddingCriteriaToSegmentsResponse> resp = addingCriteriaToSegmentsWithHttpInfo(format, mailingListID, apikey, segmentID, body);
        return resp.getData();
    }

    /**
     * Adding criteria to segments
     * Adds a new criterion (a rule) to the specified segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param body  (required)
     * @return ApiResponse&lt;AddingCriteriaToSegmentsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AddingCriteriaToSegmentsResponse> addingCriteriaToSegmentsWithHttpInfo(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body) throws ApiException {
        com.squareup.okhttp.Call call = addingCriteriaToSegmentsValidateBeforeCall(format, mailingListID, apikey, segmentID, body, null, null);
        Type localVarReturnType = new TypeToken<AddingCriteriaToSegmentsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Adding criteria to segments (asynchronously)
     * Adds a new criterion (a rule) to the specified segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addingCriteriaToSegmentsAsync(String format, String mailingListID, String apikey, String segmentID, AddingCriteriaToSegmentsRequest body, final ApiCallback<AddingCriteriaToSegmentsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addingCriteriaToSegmentsValidateBeforeCall(format, mailingListID, apikey, segmentID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AddingCriteriaToSegmentsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for creatingANewSegment
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call creatingANewSegmentCall(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/segments/create.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call creatingANewSegmentValidateBeforeCall(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling creatingANewSegment(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling creatingANewSegment(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling creatingANewSegment(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling creatingANewSegment(Async)");
        }
        
        
        com.squareup.okhttp.Call call = creatingANewSegmentCall(format, mailingListID, apikey, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Creating a new segment
     * Creates a new empty segment (without criteria) for the given mailing list. You may specify the name of the segment and the way the criteria will match together.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return CreatingANewSegmentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreatingANewSegmentResponse creatingANewSegment(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body) throws ApiException {
        ApiResponse<CreatingANewSegmentResponse> resp = creatingANewSegmentWithHttpInfo(format, mailingListID, apikey, body);
        return resp.getData();
    }

    /**
     * Creating a new segment
     * Creates a new empty segment (without criteria) for the given mailing list. You may specify the name of the segment and the way the criteria will match together.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return ApiResponse&lt;CreatingANewSegmentResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreatingANewSegmentResponse> creatingANewSegmentWithHttpInfo(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body) throws ApiException {
        com.squareup.okhttp.Call call = creatingANewSegmentValidateBeforeCall(format, mailingListID, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<CreatingANewSegmentResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Creating a new segment (asynchronously)
     * Creates a new empty segment (without criteria) for the given mailing list. You may specify the name of the segment and the way the criteria will match together.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call creatingANewSegmentAsync(String format, String mailingListID, String apikey, CreatingANewSegmentRequest body, final ApiCallback<CreatingANewSegmentResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = creatingANewSegmentValidateBeforeCall(format, mailingListID, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatingANewSegmentResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deletingASegment
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletingASegmentCall(String format, String mailingListID, String apikey, String segmentID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/delete.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "SegmentID" + "\\}", apiClient.escapeString(segmentID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletingASegmentValidateBeforeCall(String format, String mailingListID, String apikey, String segmentID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling deletingASegment(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling deletingASegment(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling deletingASegment(Async)");
        }
        
        // verify the required parameter 'segmentID' is set
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling deletingASegment(Async)");
        }
        
        
        com.squareup.okhttp.Call call = deletingASegmentCall(format, mailingListID, apikey, segmentID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Deleting A Segment
     * Deletes a segment along with its criteria from the mailing list. The subscribers of the mailing list that the segment returned are not deleted or affected in any way.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @return DeletingASegmentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeletingASegmentResponse deletingASegment(String format, String mailingListID, String apikey, String segmentID) throws ApiException {
        ApiResponse<DeletingASegmentResponse> resp = deletingASegmentWithHttpInfo(format, mailingListID, apikey, segmentID);
        return resp.getData();
    }

    /**
     * Deleting A Segment
     * Deletes a segment along with its criteria from the mailing list. The subscribers of the mailing list that the segment returned are not deleted or affected in any way.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @return ApiResponse&lt;DeletingASegmentResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeletingASegmentResponse> deletingASegmentWithHttpInfo(String format, String mailingListID, String apikey, String segmentID) throws ApiException {
        com.squareup.okhttp.Call call = deletingASegmentValidateBeforeCall(format, mailingListID, apikey, segmentID, null, null);
        Type localVarReturnType = new TypeToken<DeletingASegmentResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Deleting A Segment (asynchronously)
     * Deletes a segment along with its criteria from the mailing list. The subscribers of the mailing list that the segment returned are not deleted or affected in any way.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletingASegmentAsync(String format, String mailingListID, String apikey, String segmentID, final ApiCallback<DeletingASegmentResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletingASegmentValidateBeforeCall(format, mailingListID, apikey, segmentID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeletingASegmentResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingSegmentDetails
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param segmentID The ID of the segment to fetch results for. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingSegmentDetailsCall(String format, String mailingListID, String segmentID, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/details.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "SegmentID" + "\\}", apiClient.escapeString(segmentID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingSegmentDetailsValidateBeforeCall(String format, String mailingListID, String segmentID, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSegmentDetails(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingSegmentDetails(Async)");
        }
        
        // verify the required parameter 'segmentID' is set
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling gettingSegmentDetails(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSegmentDetails(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingSegmentDetailsCall(format, mailingListID, segmentID, apikey, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting segment details
     * Gets detailed information on a specific segment and its criteria. However, it does not include the subscribers returned by the segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param segmentID The ID of the segment to fetch results for. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return GettingSegmentDetailsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingSegmentDetailsResponse gettingSegmentDetails(String format, String mailingListID, String segmentID, String apikey) throws ApiException {
        ApiResponse<GettingSegmentDetailsResponse> resp = gettingSegmentDetailsWithHttpInfo(format, mailingListID, segmentID, apikey);
        return resp.getData();
    }

    /**
     * Getting segment details
     * Gets detailed information on a specific segment and its criteria. However, it does not include the subscribers returned by the segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param segmentID The ID of the segment to fetch results for. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return ApiResponse&lt;GettingSegmentDetailsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingSegmentDetailsResponse> gettingSegmentDetailsWithHttpInfo(String format, String mailingListID, String segmentID, String apikey) throws ApiException {
        com.squareup.okhttp.Call call = gettingSegmentDetailsValidateBeforeCall(format, mailingListID, segmentID, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingSegmentDetailsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting segment details (asynchronously)
     * Gets detailed information on a specific segment and its criteria. However, it does not include the subscribers returned by the segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param segmentID The ID of the segment to fetch results for. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingSegmentDetailsAsync(String format, String mailingListID, String segmentID, String apikey, final ApiCallback<GettingSegmentDetailsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingSegmentDetailsValidateBeforeCall(format, mailingListID, segmentID, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSegmentDetailsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingSegmentSubscribers
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param segmentID The ID of the segment to fetch results for. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingSegmentSubscribersCall(String format, String mailingListID, String segmentID, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/members.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "SegmentID" + "\\}", apiClient.escapeString(segmentID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingSegmentSubscribersValidateBeforeCall(String format, String mailingListID, String segmentID, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSegmentSubscribers(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingSegmentSubscribers(Async)");
        }
        
        // verify the required parameter 'segmentID' is set
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling gettingSegmentSubscribers(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSegmentSubscribers(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingSegmentSubscribersCall(format, mailingListID, segmentID, apikey, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting segment subscribers
     * Gets a list of the subscribers that the specified segment returns according to its criteria. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param segmentID The ID of the segment to fetch results for. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return GettingSegmentSubscribersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingSegmentSubscribersResponse gettingSegmentSubscribers(String format, String mailingListID, String segmentID, String apikey) throws ApiException {
        ApiResponse<GettingSegmentSubscribersResponse> resp = gettingSegmentSubscribersWithHttpInfo(format, mailingListID, segmentID, apikey);
        return resp.getData();
    }

    /**
     * Getting segment subscribers
     * Gets a list of the subscribers that the specified segment returns according to its criteria. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param segmentID The ID of the segment to fetch results for. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return ApiResponse&lt;GettingSegmentSubscribersResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingSegmentSubscribersResponse> gettingSegmentSubscribersWithHttpInfo(String format, String mailingListID, String segmentID, String apikey) throws ApiException {
        com.squareup.okhttp.Call call = gettingSegmentSubscribersValidateBeforeCall(format, mailingListID, segmentID, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingSegmentSubscribersResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting segment subscribers (asynchronously)
     * Gets a list of the subscribers that the specified segment returns according to its criteria. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param segmentID The ID of the segment to fetch results for. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingSegmentSubscribersAsync(String format, String mailingListID, String segmentID, String apikey, final ApiCallback<GettingSegmentSubscribersResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingSegmentSubscribersValidateBeforeCall(format, mailingListID, segmentID, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSegmentSubscribersResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingSegments
     * @param format  (required)
     * @param mailingListID  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingSegmentsCall(String format, String mailingListID, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/segments.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingSegmentsValidateBeforeCall(String format, String mailingListID, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSegments(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling gettingSegments(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSegments(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingSegmentsCall(format, mailingListID, apikey, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting segments
     * Get a list of all segments with their criteria for the given mailing list.
     * @param format  (required)
     * @param mailingListID  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return GettingSegmentsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingSegmentsResponse gettingSegments(String format, String mailingListID, String apikey) throws ApiException {
        ApiResponse<GettingSegmentsResponse> resp = gettingSegmentsWithHttpInfo(format, mailingListID, apikey);
        return resp.getData();
    }

    /**
     * Getting segments
     * Get a list of all segments with their criteria for the given mailing list.
     * @param format  (required)
     * @param mailingListID  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return ApiResponse&lt;GettingSegmentsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingSegmentsResponse> gettingSegmentsWithHttpInfo(String format, String mailingListID, String apikey) throws ApiException {
        com.squareup.okhttp.Call call = gettingSegmentsValidateBeforeCall(format, mailingListID, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingSegmentsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting segments (asynchronously)
     * Get a list of all segments with their criteria for the given mailing list.
     * @param format  (required)
     * @param mailingListID  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingSegmentsAsync(String format, String mailingListID, String apikey, final ApiCallback<GettingSegmentsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingSegmentsValidateBeforeCall(format, mailingListID, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSegmentsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updatingASegment
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updatingASegmentCall(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/update.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "SegmentID" + "\\}", apiClient.escapeString(segmentID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updatingASegmentValidateBeforeCall(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingASegment(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingASegment(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingASegment(Async)");
        }
        
        // verify the required parameter 'segmentID' is set
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling updatingASegment(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingASegment(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updatingASegmentCall(format, mailingListID, apikey, segmentID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Updating a segment
     * Updates the properties of an existing segment. You may update the name and match type of the segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param body  (required)
     * @return UpdatingASegmentResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UpdatingASegmentResponse updatingASegment(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body) throws ApiException {
        ApiResponse<UpdatingASegmentResponse> resp = updatingASegmentWithHttpInfo(format, mailingListID, apikey, segmentID, body);
        return resp.getData();
    }

    /**
     * Updating a segment
     * Updates the properties of an existing segment. You may update the name and match type of the segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param body  (required)
     * @return ApiResponse&lt;UpdatingASegmentResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UpdatingASegmentResponse> updatingASegmentWithHttpInfo(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body) throws ApiException {
        com.squareup.okhttp.Call call = updatingASegmentValidateBeforeCall(format, mailingListID, apikey, segmentID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingASegmentResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Updating a segment (asynchronously)
     * Updates the properties of an existing segment. You may update the name and match type of the segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updatingASegmentAsync(String format, String mailingListID, String apikey, String segmentID, UpdatingASegmentRequest body, final ApiCallback<UpdatingASegmentResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updatingASegmentValidateBeforeCall(format, mailingListID, apikey, segmentID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingASegmentResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updatingSegmentCriteria
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param criteriaID The ID of the criterion to process. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updatingSegmentCriteriaCall(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/lists/{MailingListID}/segments/{SegmentID}/criteria/{CriteriaID}/update.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "MailingListID" + "\\}", apiClient.escapeString(mailingListID.toString()))
            .replaceAll("\\{" + "SegmentID" + "\\}", apiClient.escapeString(segmentID.toString()))
            .replaceAll("\\{" + "CriteriaID" + "\\}", apiClient.escapeString(criteriaID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updatingSegmentCriteriaValidateBeforeCall(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingSegmentCriteria(Async)");
        }
        
        // verify the required parameter 'mailingListID' is set
        if (mailingListID == null) {
            throw new ApiException("Missing the required parameter 'mailingListID' when calling updatingSegmentCriteria(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingSegmentCriteria(Async)");
        }
        
        // verify the required parameter 'segmentID' is set
        if (segmentID == null) {
            throw new ApiException("Missing the required parameter 'segmentID' when calling updatingSegmentCriteria(Async)");
        }
        
        // verify the required parameter 'criteriaID' is set
        if (criteriaID == null) {
            throw new ApiException("Missing the required parameter 'criteriaID' when calling updatingSegmentCriteria(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingSegmentCriteria(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updatingSegmentCriteriaCall(format, mailingListID, apikey, segmentID, criteriaID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Updating segment criteria
     * Updates an existing criterion in the specified segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param criteriaID The ID of the criterion to process. (required)
     * @param body  (required)
     * @return UpdatingSegmentCriteriaResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UpdatingSegmentCriteriaResponse updatingSegmentCriteria(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body) throws ApiException {
        ApiResponse<UpdatingSegmentCriteriaResponse> resp = updatingSegmentCriteriaWithHttpInfo(format, mailingListID, apikey, segmentID, criteriaID, body);
        return resp.getData();
    }

    /**
     * Updating segment criteria
     * Updates an existing criterion in the specified segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param criteriaID The ID of the criterion to process. (required)
     * @param body  (required)
     * @return ApiResponse&lt;UpdatingSegmentCriteriaResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UpdatingSegmentCriteriaResponse> updatingSegmentCriteriaWithHttpInfo(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body) throws ApiException {
        com.squareup.okhttp.Call call = updatingSegmentCriteriaValidateBeforeCall(format, mailingListID, apikey, segmentID, criteriaID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingSegmentCriteriaResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Updating segment criteria (asynchronously)
     * Updates an existing criterion in the specified segment.
     * @param format  (required)
     * @param mailingListID The ID of the mailing list the specified segment belongs. (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param segmentID The ID of the segment to update. (required)
     * @param criteriaID The ID of the criterion to process. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updatingSegmentCriteriaAsync(String format, String mailingListID, String apikey, String segmentID, Double criteriaID, UpdatingSegmentCriteriaRequest body, final ApiCallback<UpdatingSegmentCriteriaResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updatingSegmentCriteriaValidateBeforeCall(format, mailingListID, apikey, segmentID, criteriaID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingSegmentCriteriaResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
