/*
 * Moosend API
 * TODO: Add a description
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.AbTestCampaignSummaryResponse;
import io.swagger.client.model.ActivityByLocationResponse;
import io.swagger.client.model.CampaignSummaryResponse;
import io.swagger.client.model.CloningAnExistingCampaignResponse;
import io.swagger.client.model.CreatingADraftCampaignRequest;
import io.swagger.client.model.CreatingADraftCampaignResponse;
import io.swagger.client.model.DeletingACampaignResponse;
import io.swagger.client.model.GetAllCampaignsResponse;
import io.swagger.client.model.GetCampaignStatisticsWithPagingFilteredResponse;
import io.swagger.client.model.GetCampaignsByPageAndPagesizeResponse;
import io.swagger.client.model.GetCampaignsByPageResponse;
import io.swagger.client.model.GettingAllYourSendersResponse;
import io.swagger.client.model.GettingCampaignDetailsResponse;
import io.swagger.client.model.GettingSenderDetailsResponse;
import io.swagger.client.model.LinkActivityResponse;
import io.swagger.client.model.SchedulingACampaignRequest;
import io.swagger.client.model.SchedulingACampaignResponse;
import io.swagger.client.model.SendingACampaignResponse;
import io.swagger.client.model.TestingACampaignRequest;
import io.swagger.client.model.TestingACampaignResponse;
import io.swagger.client.model.UnschedulingACampaignResponse;
import io.swagger.client.model.UpdatingADraftCampaignRequest;
import io.swagger.client.model.UpdatingADraftCampaignResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CampaignsApi {
    private ApiClient apiClient;

    public CampaignsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CampaignsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for aBTestCampaignSummary
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested AB test campaign (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call aBTestCampaignSummaryCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/view_ab_summary.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call aBTestCampaignSummaryValidateBeforeCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling aBTestCampaignSummary(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling aBTestCampaignSummary(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling aBTestCampaignSummary(Async)");
        }
        
        
        com.squareup.okhttp.Call call = aBTestCampaignSummaryCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * AB Test Campaign Summary
     * Provides a basic summary of the results for a sent AB test campaign, separately for each version (A and B), such as the number of recipients, opens, clicks, bounces, unsubscribes, forwards etc to date.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested AB test campaign (required)
     * @return AbTestCampaignSummaryResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public AbTestCampaignSummaryResponse aBTestCampaignSummary(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<AbTestCampaignSummaryResponse> resp = aBTestCampaignSummaryWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    /**
     * AB Test Campaign Summary
     * Provides a basic summary of the results for a sent AB test campaign, separately for each version (A and B), such as the number of recipients, opens, clicks, bounces, unsubscribes, forwards etc to date.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested AB test campaign (required)
     * @return ApiResponse&lt;AbTestCampaignSummaryResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<AbTestCampaignSummaryResponse> aBTestCampaignSummaryWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        com.squareup.okhttp.Call call = aBTestCampaignSummaryValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<AbTestCampaignSummaryResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * AB Test Campaign Summary (asynchronously)
     * Provides a basic summary of the results for a sent AB test campaign, separately for each version (A and B), such as the number of recipients, opens, clicks, bounces, unsubscribes, forwards etc to date.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested AB test campaign (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call aBTestCampaignSummaryAsync(String format, String apikey, String campaignID, final ApiCallback<AbTestCampaignSummaryResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = aBTestCampaignSummaryValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<AbTestCampaignSummaryResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for activityByLocation
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call activityByLocationCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/stats/countries.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call activityByLocationValidateBeforeCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling activityByLocation(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling activityByLocation(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling activityByLocation(Async)");
        }
        
        
        com.squareup.okhttp.Call call = activityByLocationCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Activity By Location
     * Returns a detailed report of your campaign opens (unique and total) by country.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @return ActivityByLocationResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ActivityByLocationResponse activityByLocation(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<ActivityByLocationResponse> resp = activityByLocationWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    /**
     * Activity By Location
     * Returns a detailed report of your campaign opens (unique and total) by country.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @return ApiResponse&lt;ActivityByLocationResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ActivityByLocationResponse> activityByLocationWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        com.squareup.okhttp.Call call = activityByLocationValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<ActivityByLocationResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Activity By Location (asynchronously)
     * Returns a detailed report of your campaign opens (unique and total) by country.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call activityByLocationAsync(String format, String apikey, String campaignID, final ApiCallback<ActivityByLocationResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = activityByLocationValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ActivityByLocationResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for campaignSummary
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call campaignSummaryCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/view_summary.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call campaignSummaryValidateBeforeCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling campaignSummary(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling campaignSummary(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling campaignSummary(Async)");
        }
        
        
        com.squareup.okhttp.Call call = campaignSummaryCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Campaign Summary
     * Provides a basic summary of the results for any sent campaign such as the number of recipients, opens, clicks, bounces, unsubscribes, forwards etc. to date.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @return CampaignSummaryResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CampaignSummaryResponse campaignSummary(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<CampaignSummaryResponse> resp = campaignSummaryWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    /**
     * Campaign Summary
     * Provides a basic summary of the results for any sent campaign such as the number of recipients, opens, clicks, bounces, unsubscribes, forwards etc. to date.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @return ApiResponse&lt;CampaignSummaryResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CampaignSummaryResponse> campaignSummaryWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        com.squareup.okhttp.Call call = campaignSummaryValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<CampaignSummaryResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Campaign Summary (asynchronously)
     * Provides a basic summary of the results for any sent campaign such as the number of recipients, opens, clicks, bounces, unsubscribes, forwards etc. to date.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call campaignSummaryAsync(String format, String apikey, String campaignID, final ApiCallback<CampaignSummaryResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = campaignSummaryValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CampaignSummaryResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for cloningAnExistingCampaign
     * @param format  (required)
     * @param campaignID  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call cloningAnExistingCampaignCall(String format, String campaignID, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/clone.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call cloningAnExistingCampaignValidateBeforeCall(String format, String campaignID, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling cloningAnExistingCampaign(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling cloningAnExistingCampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling cloningAnExistingCampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = cloningAnExistingCampaignCall(format, campaignID, apikey, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Cloning An Existing Campaign
     * Creates an exact copy of an existing campaign. The new campaign is created as a draft.
     * @param format  (required)
     * @param campaignID  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return CloningAnExistingCampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CloningAnExistingCampaignResponse cloningAnExistingCampaign(String format, String campaignID, String apikey) throws ApiException {
        ApiResponse<CloningAnExistingCampaignResponse> resp = cloningAnExistingCampaignWithHttpInfo(format, campaignID, apikey);
        return resp.getData();
    }

    /**
     * Cloning An Existing Campaign
     * Creates an exact copy of an existing campaign. The new campaign is created as a draft.
     * @param format  (required)
     * @param campaignID  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return ApiResponse&lt;CloningAnExistingCampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CloningAnExistingCampaignResponse> cloningAnExistingCampaignWithHttpInfo(String format, String campaignID, String apikey) throws ApiException {
        com.squareup.okhttp.Call call = cloningAnExistingCampaignValidateBeforeCall(format, campaignID, apikey, null, null);
        Type localVarReturnType = new TypeToken<CloningAnExistingCampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Cloning An Existing Campaign (asynchronously)
     * Creates an exact copy of an existing campaign. The new campaign is created as a draft.
     * @param format  (required)
     * @param campaignID  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call cloningAnExistingCampaignAsync(String format, String campaignID, String apikey, final ApiCallback<CloningAnExistingCampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = cloningAnExistingCampaignValidateBeforeCall(format, campaignID, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CloningAnExistingCampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for creatingADraftCampaign
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call creatingADraftCampaignCall(String format, String apikey, CreatingADraftCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/campaigns/create.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call creatingADraftCampaignValidateBeforeCall(String format, String apikey, CreatingADraftCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling creatingADraftCampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling creatingADraftCampaign(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling creatingADraftCampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = creatingADraftCampaignCall(format, apikey, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Creating A Draft Campaign
     * Creates a new campaign in your account. This method does not send the campaign, but rather creates it as a draft, ready for sending or testing.  You can choose to send either a regular campaign or an AB split campaign. Campaign content must be specified from a web location.  Ignore ***(A/B Split Campaign Option)*** if you want to create a regular campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return CreatingADraftCampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public CreatingADraftCampaignResponse creatingADraftCampaign(String format, String apikey, CreatingADraftCampaignRequest body) throws ApiException {
        ApiResponse<CreatingADraftCampaignResponse> resp = creatingADraftCampaignWithHttpInfo(format, apikey, body);
        return resp.getData();
    }

    /**
     * Creating A Draft Campaign
     * Creates a new campaign in your account. This method does not send the campaign, but rather creates it as a draft, ready for sending or testing.  You can choose to send either a regular campaign or an AB split campaign. Campaign content must be specified from a web location.  Ignore ***(A/B Split Campaign Option)*** if you want to create a regular campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @return ApiResponse&lt;CreatingADraftCampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<CreatingADraftCampaignResponse> creatingADraftCampaignWithHttpInfo(String format, String apikey, CreatingADraftCampaignRequest body) throws ApiException {
        com.squareup.okhttp.Call call = creatingADraftCampaignValidateBeforeCall(format, apikey, body, null, null);
        Type localVarReturnType = new TypeToken<CreatingADraftCampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Creating A Draft Campaign (asynchronously)
     * Creates a new campaign in your account. This method does not send the campaign, but rather creates it as a draft, ready for sending or testing.  You can choose to send either a regular campaign or an AB split campaign. Campaign content must be specified from a web location.  Ignore ***(A/B Split Campaign Option)*** if you want to create a regular campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call creatingADraftCampaignAsync(String format, String apikey, CreatingADraftCampaignRequest body, final ApiCallback<CreatingADraftCampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = creatingADraftCampaignValidateBeforeCall(format, apikey, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreatingADraftCampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deletingACampaign
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to update. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deletingACampaignCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/delete.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deletingACampaignValidateBeforeCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling deletingACampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling deletingACampaign(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling deletingACampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = deletingACampaignCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Deleting A Campaign
     * Deletes a campaign from your account, draft or even sent.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to update. (required)
     * @return DeletingACampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DeletingACampaignResponse deletingACampaign(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<DeletingACampaignResponse> resp = deletingACampaignWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    /**
     * Deleting A Campaign
     * Deletes a campaign from your account, draft or even sent.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to update. (required)
     * @return ApiResponse&lt;DeletingACampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DeletingACampaignResponse> deletingACampaignWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        com.squareup.okhttp.Call call = deletingACampaignValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<DeletingACampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Deleting A Campaign (asynchronously)
     * Deletes a campaign from your account, draft or even sent.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to update. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deletingACampaignAsync(String format, String apikey, String campaignID, final ApiCallback<DeletingACampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deletingACampaignValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DeletingACampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getAllCampaigns
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getAllCampaignsCall(String format, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getAllCampaignsValidateBeforeCall(String format, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getAllCampaigns(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getAllCampaigns(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getAllCampaignsCall(format, apikey, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get All Campaigns
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return GetAllCampaignsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetAllCampaignsResponse getAllCampaigns(String format, String apikey) throws ApiException {
        ApiResponse<GetAllCampaignsResponse> resp = getAllCampaignsWithHttpInfo(format, apikey);
        return resp.getData();
    }

    /**
     * Get All Campaigns
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return ApiResponse&lt;GetAllCampaignsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetAllCampaignsResponse> getAllCampaignsWithHttpInfo(String format, String apikey) throws ApiException {
        com.squareup.okhttp.Call call = getAllCampaignsValidateBeforeCall(format, apikey, null, null);
        Type localVarReturnType = new TypeToken<GetAllCampaignsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get All Campaigns (asynchronously)
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getAllCampaignsAsync(String format, String apikey, final ApiCallback<GetAllCampaignsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getAllCampaignsValidateBeforeCall(format, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetAllCampaignsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCampaignStatisticsWithPagingFiltered
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested AB test campaign (required)
     * @param type The type of the activity to display results for. This must be one of the following values : * Sent : To get information about when and to which recipients the campaign was sent. * Opened : To get information about who opened the campaign. * LinkClicked : To get information about who clicked on which link. * Forward : To get information about who forwarded the campaign using the relevant link on the email body and when. * Unsubscribed : To get information about who unsubscribed from the campaign by clicking on the unsubscribe link and when. * Bounced : To get information about which email recipients failed to receive the campaign. If not specified, the value Sent will be used by default. (required)
     * @param page The page number to display results for. If not specified, the first page will be returned. (optional)
     * @param pageSize The maximum number of results per page. This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (optional)
     * @param from A date value that specifies since when to start returning results. If omitted, results will be returned from the moment the campaign was sent. (optional)
     * @param to A date value that specifies up to when to return results. If omitted, results will be returned up to date. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCampaignStatisticsWithPagingFilteredCall(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/stats/{Type}.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()))
            .replaceAll("\\{" + "Type" + "\\}", apiClient.escapeString(type.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));
        if (page != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "Page", page));
        if (pageSize != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "PageSize", pageSize));
        if (from != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "From", from));
        if (to != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "To", to));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCampaignStatisticsWithPagingFilteredValidateBeforeCall(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getCampaignStatisticsWithPagingFiltered(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getCampaignStatisticsWithPagingFiltered(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling getCampaignStatisticsWithPagingFiltered(Async)");
        }
        
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getCampaignStatisticsWithPagingFiltered(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getCampaignStatisticsWithPagingFilteredCall(format, apikey, campaignID, type, page, pageSize, from, to, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get Campaign Statistics With Paging &amp; Filtered
     * Returns a detailed list of statistics for a given campaign based on activity such as emails sent, opened, bounced, link clicked, etc.  Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested AB test campaign (required)
     * @param type The type of the activity to display results for. This must be one of the following values : * Sent : To get information about when and to which recipients the campaign was sent. * Opened : To get information about who opened the campaign. * LinkClicked : To get information about who clicked on which link. * Forward : To get information about who forwarded the campaign using the relevant link on the email body and when. * Unsubscribed : To get information about who unsubscribed from the campaign by clicking on the unsubscribe link and when. * Bounced : To get information about which email recipients failed to receive the campaign. If not specified, the value Sent will be used by default. (required)
     * @param page The page number to display results for. If not specified, the first page will be returned. (optional)
     * @param pageSize The maximum number of results per page. This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (optional)
     * @param from A date value that specifies since when to start returning results. If omitted, results will be returned from the moment the campaign was sent. (optional)
     * @param to A date value that specifies up to when to return results. If omitted, results will be returned up to date. (optional)
     * @return GetCampaignStatisticsWithPagingFilteredResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetCampaignStatisticsWithPagingFilteredResponse getCampaignStatisticsWithPagingFiltered(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to) throws ApiException {
        ApiResponse<GetCampaignStatisticsWithPagingFilteredResponse> resp = getCampaignStatisticsWithPagingFilteredWithHttpInfo(format, apikey, campaignID, type, page, pageSize, from, to);
        return resp.getData();
    }

    /**
     * Get Campaign Statistics With Paging &amp; Filtered
     * Returns a detailed list of statistics for a given campaign based on activity such as emails sent, opened, bounced, link clicked, etc.  Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested AB test campaign (required)
     * @param type The type of the activity to display results for. This must be one of the following values : * Sent : To get information about when and to which recipients the campaign was sent. * Opened : To get information about who opened the campaign. * LinkClicked : To get information about who clicked on which link. * Forward : To get information about who forwarded the campaign using the relevant link on the email body and when. * Unsubscribed : To get information about who unsubscribed from the campaign by clicking on the unsubscribe link and when. * Bounced : To get information about which email recipients failed to receive the campaign. If not specified, the value Sent will be used by default. (required)
     * @param page The page number to display results for. If not specified, the first page will be returned. (optional)
     * @param pageSize The maximum number of results per page. This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (optional)
     * @param from A date value that specifies since when to start returning results. If omitted, results will be returned from the moment the campaign was sent. (optional)
     * @param to A date value that specifies up to when to return results. If omitted, results will be returned up to date. (optional)
     * @return ApiResponse&lt;GetCampaignStatisticsWithPagingFilteredResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetCampaignStatisticsWithPagingFilteredResponse> getCampaignStatisticsWithPagingFilteredWithHttpInfo(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to) throws ApiException {
        com.squareup.okhttp.Call call = getCampaignStatisticsWithPagingFilteredValidateBeforeCall(format, apikey, campaignID, type, page, pageSize, from, to, null, null);
        Type localVarReturnType = new TypeToken<GetCampaignStatisticsWithPagingFilteredResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Campaign Statistics With Paging &amp; Filtered (asynchronously)
     * Returns a detailed list of statistics for a given campaign based on activity such as emails sent, opened, bounced, link clicked, etc.  Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested AB test campaign (required)
     * @param type The type of the activity to display results for. This must be one of the following values : * Sent : To get information about when and to which recipients the campaign was sent. * Opened : To get information about who opened the campaign. * LinkClicked : To get information about who clicked on which link. * Forward : To get information about who forwarded the campaign using the relevant link on the email body and when. * Unsubscribed : To get information about who unsubscribed from the campaign by clicking on the unsubscribe link and when. * Bounced : To get information about which email recipients failed to receive the campaign. If not specified, the value Sent will be used by default. (required)
     * @param page The page number to display results for. If not specified, the first page will be returned. (optional)
     * @param pageSize The maximum number of results per page. This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (optional)
     * @param from A date value that specifies since when to start returning results. If omitted, results will be returned from the moment the campaign was sent. (optional)
     * @param to A date value that specifies up to when to return results. If omitted, results will be returned up to date. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCampaignStatisticsWithPagingFilteredAsync(String format, String apikey, String campaignID, String type, String page, String pageSize, String from, String to, final ApiCallback<GetCampaignStatisticsWithPagingFilteredResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCampaignStatisticsWithPagingFilteredValidateBeforeCall(format, apikey, campaignID, type, page, pageSize, from, to, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetCampaignStatisticsWithPagingFilteredResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCampaignsByPage
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page number to display results for. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCampaignsByPageCall(String format, String apikey, Double page, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{Page}.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "Page" + "\\}", apiClient.escapeString(page.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCampaignsByPageValidateBeforeCall(String format, String apikey, Double page, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getCampaignsByPage(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getCampaignsByPage(Async)");
        }
        
        // verify the required parameter 'page' is set
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling getCampaignsByPage(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getCampaignsByPageCall(format, apikey, page, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get Campaigns By Page
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page number to display results for. (required)
     * @return GetCampaignsByPageResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetCampaignsByPageResponse getCampaignsByPage(String format, String apikey, Double page) throws ApiException {
        ApiResponse<GetCampaignsByPageResponse> resp = getCampaignsByPageWithHttpInfo(format, apikey, page);
        return resp.getData();
    }

    /**
     * Get Campaigns By Page
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page number to display results for. (required)
     * @return ApiResponse&lt;GetCampaignsByPageResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetCampaignsByPageResponse> getCampaignsByPageWithHttpInfo(String format, String apikey, Double page) throws ApiException {
        com.squareup.okhttp.Call call = getCampaignsByPageValidateBeforeCall(format, apikey, page, null, null);
        Type localVarReturnType = new TypeToken<GetCampaignsByPageResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Campaigns By Page (asynchronously)
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page number to display results for. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCampaignsByPageAsync(String format, String apikey, Double page, final ApiCallback<GetCampaignsByPageResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCampaignsByPageValidateBeforeCall(format, apikey, page, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetCampaignsByPageResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getCampaignsByPageAndPagesize
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page number to display results for. (required)
     * @param pageSize The maximum number of results per page.  This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (required)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getCampaignsByPageAndPagesizeCall(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{Page}/{PageSize}.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "Page" + "\\}", apiClient.escapeString(page.toString()))
            .replaceAll("\\{" + "PageSize" + "\\}", apiClient.escapeString(pageSize.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));
        if (shortBy != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "ShortBy", shortBy));
        if (sortMethod != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "SortMethod", sortMethod));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getCampaignsByPageAndPagesizeValidateBeforeCall(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling getCampaignsByPageAndPagesize(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling getCampaignsByPageAndPagesize(Async)");
        }
        
        // verify the required parameter 'page' is set
        if (page == null) {
            throw new ApiException("Missing the required parameter 'page' when calling getCampaignsByPageAndPagesize(Async)");
        }
        
        // verify the required parameter 'pageSize' is set
        if (pageSize == null) {
            throw new ApiException("Missing the required parameter 'pageSize' when calling getCampaignsByPageAndPagesize(Async)");
        }
        
        
        com.squareup.okhttp.Call call = getCampaignsByPageAndPagesizeCall(format, apikey, page, pageSize, shortBy, sortMethod, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get Campaigns By Page And Pagesize
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page number to display results for. (required)
     * @param pageSize The maximum number of results per page.  This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (required)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @return GetCampaignsByPageAndPagesizeResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GetCampaignsByPageAndPagesizeResponse getCampaignsByPageAndPagesize(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod) throws ApiException {
        ApiResponse<GetCampaignsByPageAndPagesizeResponse> resp = getCampaignsByPageAndPagesizeWithHttpInfo(format, apikey, page, pageSize, shortBy, sortMethod);
        return resp.getData();
    }

    /**
     * Get Campaigns By Page And Pagesize
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page number to display results for. (required)
     * @param pageSize The maximum number of results per page.  This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (required)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @return ApiResponse&lt;GetCampaignsByPageAndPagesizeResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GetCampaignsByPageAndPagesizeResponse> getCampaignsByPageAndPagesizeWithHttpInfo(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod) throws ApiException {
        com.squareup.okhttp.Call call = getCampaignsByPageAndPagesizeValidateBeforeCall(format, apikey, page, pageSize, shortBy, sortMethod, null, null);
        Type localVarReturnType = new TypeToken<GetCampaignsByPageAndPagesizeResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Campaigns By Page And Pagesize (asynchronously)
     * Returns a list of all campaigns in your account with detailed information. Because the results for this call could be quite big, paging information is required as input.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param page The page number to display results for. (required)
     * @param pageSize The maximum number of results per page.  This must be a positive integer up to 100. If not specified, 50 results per page will be returned.  If a value greater than 100 is specified, it will be treated as 100. (required)
     * @param shortBy The name of the campaign property to sort results by. If not specified, results will be sorted by the CreatedOn property (optional)
     * @param sortMethod The method to sort results: ASC for ascending, DESC for descending. If not specified, &#x60;ASC&#x60; will be assumed (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getCampaignsByPageAndPagesizeAsync(String format, String apikey, Double page, Double pageSize, String shortBy, String sortMethod, final ApiCallback<GetCampaignsByPageAndPagesizeResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getCampaignsByPageAndPagesizeValidateBeforeCall(format, apikey, page, pageSize, shortBy, sortMethod, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetCampaignsByPageAndPagesizeResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingAllYourSenders
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingAllYourSendersCall(String format, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/senders/find_all.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingAllYourSendersValidateBeforeCall(String format, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingAllYourSenders(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingAllYourSenders(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingAllYourSendersCall(format, apikey, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting All Your Senders
     * Gets a list of your active senders in your account. You may specify any email address of these senders when sending a campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return GettingAllYourSendersResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingAllYourSendersResponse gettingAllYourSenders(String format, String apikey) throws ApiException {
        ApiResponse<GettingAllYourSendersResponse> resp = gettingAllYourSendersWithHttpInfo(format, apikey);
        return resp.getData();
    }

    /**
     * Getting All Your Senders
     * Gets a list of your active senders in your account. You may specify any email address of these senders when sending a campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return ApiResponse&lt;GettingAllYourSendersResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingAllYourSendersResponse> gettingAllYourSendersWithHttpInfo(String format, String apikey) throws ApiException {
        com.squareup.okhttp.Call call = gettingAllYourSendersValidateBeforeCall(format, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingAllYourSendersResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting All Your Senders (asynchronously)
     * Gets a list of your active senders in your account. You may specify any email address of these senders when sending a campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingAllYourSendersAsync(String format, String apikey, final ApiCallback<GettingAllYourSendersResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingAllYourSendersValidateBeforeCall(format, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingAllYourSendersResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingCampaignDetails
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingCampaignDetailsCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/view.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingCampaignDetailsValidateBeforeCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingCampaignDetails(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingCampaignDetails(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling gettingCampaignDetails(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingCampaignDetailsCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting Campaign Details
     * Returns a complete set of properties that describe the requested campaign in detail. No statistics are included in the result.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @return GettingCampaignDetailsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingCampaignDetailsResponse gettingCampaignDetails(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<GettingCampaignDetailsResponse> resp = gettingCampaignDetailsWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    /**
     * Getting Campaign Details
     * Returns a complete set of properties that describe the requested campaign in detail. No statistics are included in the result.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @return ApiResponse&lt;GettingCampaignDetailsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingCampaignDetailsResponse> gettingCampaignDetailsWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        com.squareup.okhttp.Call call = gettingCampaignDetailsValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<GettingCampaignDetailsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting Campaign Details (asynchronously)
     * Returns a complete set of properties that describe the requested campaign in detail. No statistics are included in the result.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingCampaignDetailsAsync(String format, String apikey, String campaignID, final ApiCallback<GettingCampaignDetailsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingCampaignDetailsValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingCampaignDetailsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for gettingSenderDetails
     * @param format  (required)
     * @param email  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call gettingSenderDetailsCall(String format, String email, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/senders/find_one.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (email != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "Email", email));
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call gettingSenderDetailsValidateBeforeCall(String format, String email, String apikey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling gettingSenderDetails(Async)");
        }
        
        // verify the required parameter 'email' is set
        if (email == null) {
            throw new ApiException("Missing the required parameter 'email' when calling gettingSenderDetails(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling gettingSenderDetails(Async)");
        }
        
        
        com.squareup.okhttp.Call call = gettingSenderDetailsCall(format, email, apikey, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Getting Sender Details
     * Returns basic information for the specified sender identified by its email address.
     * @param format  (required)
     * @param email  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return GettingSenderDetailsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public GettingSenderDetailsResponse gettingSenderDetails(String format, String email, String apikey) throws ApiException {
        ApiResponse<GettingSenderDetailsResponse> resp = gettingSenderDetailsWithHttpInfo(format, email, apikey);
        return resp.getData();
    }

    /**
     * Getting Sender Details
     * Returns basic information for the specified sender identified by its email address.
     * @param format  (required)
     * @param email  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @return ApiResponse&lt;GettingSenderDetailsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<GettingSenderDetailsResponse> gettingSenderDetailsWithHttpInfo(String format, String email, String apikey) throws ApiException {
        com.squareup.okhttp.Call call = gettingSenderDetailsValidateBeforeCall(format, email, apikey, null, null);
        Type localVarReturnType = new TypeToken<GettingSenderDetailsResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Getting Sender Details (asynchronously)
     * Returns basic information for the specified sender identified by its email address.
     * @param format  (required)
     * @param email  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call gettingSenderDetailsAsync(String format, String email, String apikey, final ApiCallback<GettingSenderDetailsResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = gettingSenderDetailsValidateBeforeCall(format, email, apikey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GettingSenderDetailsResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for linkActivity
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call linkActivityCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/stats/links.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call linkActivityValidateBeforeCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling linkActivity(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling linkActivity(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling linkActivity(Async)");
        }
        
        
        com.squareup.okhttp.Call call = linkActivityCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Link Activity
     * Returns a list with your campaign links and how many clicks have been made by your recipients, either unique or total.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @return LinkActivityResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public LinkActivityResponse linkActivity(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<LinkActivityResponse> resp = linkActivityWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    /**
     * Link Activity
     * Returns a list with your campaign links and how many clicks have been made by your recipients, either unique or total.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @return ApiResponse&lt;LinkActivityResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<LinkActivityResponse> linkActivityWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        com.squareup.okhttp.Call call = linkActivityValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<LinkActivityResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Link Activity (asynchronously)
     * Returns a list with your campaign links and how many clicks have been made by your recipients, either unique or total.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the requested campaign (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call linkActivityAsync(String format, String apikey, String campaignID, final ApiCallback<LinkActivityResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = linkActivityValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<LinkActivityResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for schedulingACampaign
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the campaign to be scheduled (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call schedulingACampaignCall(String format, String apikey, String campaignID, SchedulingACampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/schedule.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call schedulingACampaignValidateBeforeCall(String format, String apikey, String campaignID, SchedulingACampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling schedulingACampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling schedulingACampaign(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling schedulingACampaign(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling schedulingACampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = schedulingACampaignCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Scheduling A Campaign
     * Assigns a scheduled date and time at which the campaign will be delivered.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the campaign to be scheduled (required)
     * @param body  (required)
     * @return SchedulingACampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SchedulingACampaignResponse schedulingACampaign(String format, String apikey, String campaignID, SchedulingACampaignRequest body) throws ApiException {
        ApiResponse<SchedulingACampaignResponse> resp = schedulingACampaignWithHttpInfo(format, apikey, campaignID, body);
        return resp.getData();
    }

    /**
     * Scheduling A Campaign
     * Assigns a scheduled date and time at which the campaign will be delivered.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the campaign to be scheduled (required)
     * @param body  (required)
     * @return ApiResponse&lt;SchedulingACampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SchedulingACampaignResponse> schedulingACampaignWithHttpInfo(String format, String apikey, String campaignID, SchedulingACampaignRequest body) throws ApiException {
        com.squareup.okhttp.Call call = schedulingACampaignValidateBeforeCall(format, apikey, campaignID, body, null, null);
        Type localVarReturnType = new TypeToken<SchedulingACampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Scheduling A Campaign (asynchronously)
     * Assigns a scheduled date and time at which the campaign will be delivered.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the campaign to be scheduled (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call schedulingACampaignAsync(String format, String apikey, String campaignID, SchedulingACampaignRequest body, final ApiCallback<SchedulingACampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = schedulingACampaignValidateBeforeCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SchedulingACampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for sendingACampaign
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to be sent. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call sendingACampaignCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/send.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call sendingACampaignValidateBeforeCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling sendingACampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling sendingACampaign(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling sendingACampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = sendingACampaignCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Sending a campaign
     * Sends an existing draft campaign to all recipients specified in its mailing list. The campaign is sent immediatelly.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to be sent. (required)
     * @return SendingACampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public SendingACampaignResponse sendingACampaign(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<SendingACampaignResponse> resp = sendingACampaignWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    /**
     * Sending a campaign
     * Sends an existing draft campaign to all recipients specified in its mailing list. The campaign is sent immediatelly.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to be sent. (required)
     * @return ApiResponse&lt;SendingACampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<SendingACampaignResponse> sendingACampaignWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        com.squareup.okhttp.Call call = sendingACampaignValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<SendingACampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Sending a campaign (asynchronously)
     * Sends an existing draft campaign to all recipients specified in its mailing list. The campaign is sent immediatelly.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to be sent. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call sendingACampaignAsync(String format, String apikey, String campaignID, final ApiCallback<SendingACampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = sendingACampaignValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<SendingACampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for testingACampaign
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to be tested. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call testingACampaignCall(String format, String apikey, String campaignID, TestingACampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/send_test.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call testingACampaignValidateBeforeCall(String format, String apikey, String campaignID, TestingACampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling testingACampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling testingACampaign(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling testingACampaign(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling testingACampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = testingACampaignCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Testing a campaign
     * Sends a test email of a draft campaign to a list of email addresses you specify for previewing.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to be tested. (required)
     * @param body  (required)
     * @return TestingACampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public TestingACampaignResponse testingACampaign(String format, String apikey, String campaignID, TestingACampaignRequest body) throws ApiException {
        ApiResponse<TestingACampaignResponse> resp = testingACampaignWithHttpInfo(format, apikey, campaignID, body);
        return resp.getData();
    }

    /**
     * Testing a campaign
     * Sends a test email of a draft campaign to a list of email addresses you specify for previewing.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to be tested. (required)
     * @param body  (required)
     * @return ApiResponse&lt;TestingACampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<TestingACampaignResponse> testingACampaignWithHttpInfo(String format, String apikey, String campaignID, TestingACampaignRequest body) throws ApiException {
        com.squareup.okhttp.Call call = testingACampaignValidateBeforeCall(format, apikey, campaignID, body, null, null);
        Type localVarReturnType = new TypeToken<TestingACampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Testing a campaign (asynchronously)
     * Sends a test email of a draft campaign to a list of email addresses you specify for previewing.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to be tested. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call testingACampaignAsync(String format, String apikey, String campaignID, TestingACampaignRequest body, final ApiCallback<TestingACampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = testingACampaignValidateBeforeCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TestingACampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for unschedulingACampaign
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the campaign to be scheduled (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call unschedulingACampaignCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/unschedule.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call unschedulingACampaignValidateBeforeCall(String format, String apikey, String campaignID, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling unschedulingACampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling unschedulingACampaign(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling unschedulingACampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = unschedulingACampaignCall(format, apikey, campaignID, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Unscheduling a campaign
     * Removes a previously defined scheduled date and time from a campaign, so that it will be delivered immediately if already queued or when sent.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the campaign to be scheduled (required)
     * @return UnschedulingACampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UnschedulingACampaignResponse unschedulingACampaign(String format, String apikey, String campaignID) throws ApiException {
        ApiResponse<UnschedulingACampaignResponse> resp = unschedulingACampaignWithHttpInfo(format, apikey, campaignID);
        return resp.getData();
    }

    /**
     * Unscheduling a campaign
     * Removes a previously defined scheduled date and time from a campaign, so that it will be delivered immediately if already queued or when sent.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the campaign to be scheduled (required)
     * @return ApiResponse&lt;UnschedulingACampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UnschedulingACampaignResponse> unschedulingACampaignWithHttpInfo(String format, String apikey, String campaignID) throws ApiException {
        com.squareup.okhttp.Call call = unschedulingACampaignValidateBeforeCall(format, apikey, campaignID, null, null);
        Type localVarReturnType = new TypeToken<UnschedulingACampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Unscheduling a campaign (asynchronously)
     * Removes a previously defined scheduled date and time from a campaign, so that it will be delivered immediately if already queued or when sent.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the campaign to be scheduled (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call unschedulingACampaignAsync(String format, String apikey, String campaignID, final ApiCallback<UnschedulingACampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = unschedulingACampaignValidateBeforeCall(format, apikey, campaignID, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UnschedulingACampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updatingADraftCampaign
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to update. (required)
     * @param body  (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updatingADraftCampaignCall(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        
        // create path and map variables
        String localVarPath = "/campaigns/{CampaignID}/update.{Format}"
            .replaceAll("\\{" + "Format" + "\\}", apiClient.escapeString(format.toString()))
            .replaceAll("\\{" + "CampaignID" + "\\}", apiClient.escapeString(campaignID.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (apikey != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "apikey", apikey));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updatingADraftCampaignValidateBeforeCall(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'format' is set
        if (format == null) {
            throw new ApiException("Missing the required parameter 'format' when calling updatingADraftCampaign(Async)");
        }
        
        // verify the required parameter 'apikey' is set
        if (apikey == null) {
            throw new ApiException("Missing the required parameter 'apikey' when calling updatingADraftCampaign(Async)");
        }
        
        // verify the required parameter 'campaignID' is set
        if (campaignID == null) {
            throw new ApiException("Missing the required parameter 'campaignID' when calling updatingADraftCampaign(Async)");
        }
        
        // verify the required parameter 'body' is set
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling updatingADraftCampaign(Async)");
        }
        
        
        com.squareup.okhttp.Call call = updatingADraftCampaignCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Updating A Draft Campaign
     * Updates properties of an existing draft A/B campaign in your account. Non-draft campaigns cannot be updated. Ignore ***(A/B Split Campaign Option)*** if you want to create a regular campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to update. (required)
     * @param body  (required)
     * @return UpdatingADraftCampaignResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UpdatingADraftCampaignResponse updatingADraftCampaign(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body) throws ApiException {
        ApiResponse<UpdatingADraftCampaignResponse> resp = updatingADraftCampaignWithHttpInfo(format, apikey, campaignID, body);
        return resp.getData();
    }

    /**
     * Updating A Draft Campaign
     * Updates properties of an existing draft A/B campaign in your account. Non-draft campaigns cannot be updated. Ignore ***(A/B Split Campaign Option)*** if you want to create a regular campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to update. (required)
     * @param body  (required)
     * @return ApiResponse&lt;UpdatingADraftCampaignResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UpdatingADraftCampaignResponse> updatingADraftCampaignWithHttpInfo(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body) throws ApiException {
        com.squareup.okhttp.Call call = updatingADraftCampaignValidateBeforeCall(format, apikey, campaignID, body, null, null);
        Type localVarReturnType = new TypeToken<UpdatingADraftCampaignResponse>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Updating A Draft Campaign (asynchronously)
     * Updates properties of an existing draft A/B campaign in your account. Non-draft campaigns cannot be updated. Ignore ***(A/B Split Campaign Option)*** if you want to create a regular campaign.
     * @param format  (required)
     * @param apikey You may find your API Key or generate a new one in your account settings. (required)
     * @param campaignID The ID of the draft campaign to update. (required)
     * @param body  (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updatingADraftCampaignAsync(String format, String apikey, String campaignID, UpdatingADraftCampaignRequest body, final ApiCallback<UpdatingADraftCampaignResponse> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updatingADraftCampaignValidateBeforeCall(format, apikey, campaignID, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UpdatingADraftCampaignResponse>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
