/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.sticky;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.StickyCallback;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.group.CompareGroupCondition;
import com.cz.widget.recyclerview.adapter.wrapper.sticky.group.GroupCondition;
import java.util.ArrayList;
import java.util.Arrays;

public class StickyGroupingStrategy<A extends RecyclerView.Adapter, T> {
    private A adapter;
    private int[] adapterIndexArray;
    private CompareGroupCondition<T> compareCondition;
    private GroupCondition<T> condition;
    private OnAdapterGroupingListener listener;
    private OnAdapterDataChangeListener adapterDataChangelistener;

    public static <A extends RecyclerView.Adapter, T> StickyGroupingStrategy<A, T> of(@NonNull A adapter) {
        return new StickyGroupingStrategy<A, T>(adapter);
    }

    public StickyGroupingStrategy(@NonNull A adapter) {
        this.adapter = adapter;
        this.registerAdapterDataObserver((RecyclerView.Adapter)adapter);
    }

    public void setCompareCondition(CompareGroupCondition<T> compareCondition) {
        this.compareCondition = compareCondition;
        this.updateAdapterGroup();
    }

    public void setCondition(GroupCondition<T> condition) {
        this.condition = condition;
        this.updateAdapterGroup();
    }

    void updateAdapterGroup() {
        if (null == this.compareCondition && null == this.condition) {
            throw new NullPointerException("condition is null!");
        }
        if (null != this.compareCondition) {
            this.updateAdapterGroup(this.compareCondition);
        } else if (null != this.condition) {
            this.updateAdapterGroup(this.condition);
        }
    }

    private void updateAdapterGroup(@NonNull CompareGroupCondition<T> compareCondition) {
        int i;
        Object lastItem = null;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int itemCount = this.adapter.getItemCount();
        for (i = 0; i < itemCount; ++i) {
            if (null == lastItem) {
                lastItem = ((StickyCallback)this.adapter).getItem(i);
                continue;
            }
            Object item = ((StickyCallback)this.adapter).getItem(i);
            if (!compareCondition.group(lastItem, item)) continue;
            int position = i;
            if (null != this.listener) {
                position = this.listener.onAdapterGroup(i);
            }
            list.add(position);
        }
        this.adapterIndexArray = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            this.adapterIndexArray[i] = (Integer)list.get(i);
        }
    }

    private void updateAdapterGroup(@NonNull GroupCondition<T> condition) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int itemCount = this.adapter.getItemCount();
        for (i = 0; i < itemCount; ++i) {
            Object item = ((StickyCallback)this.adapter).getItem(i);
            if (!condition.group(item, i)) continue;
            int position = i;
            if (null != this.listener) {
                position = this.listener.onAdapterGroup(i);
            }
            list.add(position);
        }
        this.adapterIndexArray = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            this.adapterIndexArray[i] = (Integer)list.get(i);
        }
    }

    public boolean isGroupPosition(int position) {
        if (null == this.adapterIndexArray) {
            return false;
        }
        return 0 <= Arrays.binarySearch(this.adapterIndexArray, position);
    }

    public int getGroupCount() {
        int groupCount = 0;
        if (null != this.adapterIndexArray) {
            groupCount = this.adapterIndexArray.length;
        }
        return groupCount;
    }

    public int getGroupStartPosition(int adapterPosition) {
        int position = 0;
        int start = this.getGroupIndex(adapterPosition);
        if (-1 < start && start < this.adapterIndexArray.length) {
            position = this.adapterIndexArray[start];
        }
        return position;
    }

    public int getGroupPosition(int groupIndex) {
        int position = 0;
        if (-1 < groupIndex && groupIndex < this.adapterIndexArray.length) {
            position = this.adapterIndexArray[groupIndex];
        }
        return position;
    }

    public int getGroupIndex(int position) {
        int start = 0;
        int end = this.adapterIndexArray.length;
        while (end - start > 1) {
            int middle = (start + end) / 2;
            int middleValue = this.adapterIndexArray[middle];
            if (position > middleValue) {
                start = middle;
                continue;
            }
            if (position < middleValue) {
                end = middle;
                continue;
            }
            start = middle;
            break;
        }
        return start;
    }

    public int getGroupCount(int position) {
        int start = 0;
        int result = -1;
        int end = this.adapterIndexArray.length - 1;
        while (start <= end) {
            int middle = (start + end) / 2;
            int middleValue = this.adapterIndexArray[middle];
            if (position == middleValue) {
                result = middle;
                break;
            }
            if (position < middleValue) {
                end = middle - 1;
                continue;
            }
            start = middle + 1;
        }
        if (-1 == result) {
            result = start;
        }
        return result;
    }

    private void dispatchDataChange() {
        if (null != this.adapterDataChangelistener) {
            this.adapterDataChangelistener.onDataChanged();
        }
    }

    private void registerAdapterDataObserver(RecyclerView.Adapter adapter) {
        adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                super.onChanged();
                StickyGroupingStrategy.this.updateAdapterGroup();
                StickyGroupingStrategy.this.dispatchDataChange();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                StickyGroupingStrategy.this.updateAdapterGroup();
                StickyGroupingStrategy.this.dispatchDataChange();
            }

            public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
                super.onItemRangeChanged(positionStart, itemCount, payload);
                StickyGroupingStrategy.this.updateAdapterGroup();
                StickyGroupingStrategy.this.dispatchDataChange();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                StickyGroupingStrategy.this.updateAdapterGroup();
                StickyGroupingStrategy.this.dispatchDataChange();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                StickyGroupingStrategy.this.updateAdapterGroup();
                StickyGroupingStrategy.this.dispatchDataChange();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                StickyGroupingStrategy.this.updateAdapterGroup();
                StickyGroupingStrategy.this.dispatchDataChange();
            }
        });
    }

    void setOnAdapterGroupingListener(@NonNull OnAdapterGroupingListener listener) {
        this.listener = listener;
    }

    void setOnAdapterDataChangeListener(OnAdapterDataChangeListener listener) {
        this.adapterDataChangelistener = listener;
    }

    static interface OnAdapterDataChangeListener {
        public void onDataChanged();
    }

    static interface OnAdapterGroupingListener {
        public int onAdapterGroup(int var1);
    }
}

