/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.drag;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.wrapper.drag.DragWrapperAdapter;

public class DragItemTouchHelperCallback
extends ItemTouchHelper.Callback {
    private final DragWrapperAdapter adapter;

    public DragItemTouchHelperCallback(@NonNull DragWrapperAdapter adapter) {
        this.adapter = adapter;
    }

    public boolean isLongPressDragEnabled() {
        boolean longPressDragEnabled = super.isLongPressDragEnabled();
        if (null != this.adapter) {
            longPressDragEnabled = this.adapter.isLongPressDragEnabled();
        }
        return longPressDragEnabled;
    }

    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        int adapterPosition = viewHolder.getAdapterPosition();
        int flag = ItemTouchHelper.Callback.makeFlag((int)0, (int)2);
        if (null != this.adapter && this.adapter.isDragEnable(adapterPosition)) {
            flag = ItemTouchHelper.Callback.makeFlag((int)2, (int)this.adapter.getDragFlag());
        }
        return flag;
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
        int targetPosition = target.getAdapterPosition();
        boolean itemEnable = false;
        if (null != this.adapter && this.adapter.isDragEnable(targetPosition)) {
            itemEnable = true;
            int adapterPosition = viewHolder.getAdapterPosition();
            this.adapter.move(adapterPosition, targetPosition);
        }
        return itemEnable;
    }

    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
    }
}

