/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.support.tree;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.WrapperAdapter;
import com.cz.widget.recyclerview.adapter.listener.OnTreeNodeClickListener;
import com.cz.widget.recyclerview.adapter.support.tree.TreeLoadCallback;
import com.cz.widget.recyclerview.adapter.support.tree.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public abstract class TreeAdapter<E>
extends RecyclerView.Adapter {
    private final List<TreeNode<E>> nodeList = new ArrayList<TreeNode<E>>();
    private final TreeNode<E> rootNode;
    private WrapperAdapter wrapperAdapter;
    private TreeLoadCallback<E> callback;
    private OnTreeNodeClickListener<E> listener;

    public TreeAdapter(TreeNode<E> rootNode) {
        this.rootNode = rootNode;
        this.rootNode.isExpand = true;
        List<TreeNode<E>> nodeList = this.getNodeList(rootNode);
        if (null != nodeList) {
            this.nodeList.addAll(nodeList);
        }
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        if (adapter instanceof WrapperAdapter) {
            this.wrapperAdapter = (WrapperAdapter)adapter;
        }
    }

    public void expandAll() {
        this.expandNode(this.rootNode, false);
        this.notifyDataSetChanged();
    }

    public void expandNode(TreeNode<E> parentNode) {
        this.expandNode(parentNode, true);
    }

    private void expandNode(TreeNode<E> parentNode, boolean notifyDataSetChanged) {
        if (!parentNode.isExpand) {
            parentNode.isExpand = true;
            if (!parentNode.children.isEmpty()) {
                int index = this.nodeList.indexOf(parentNode);
                this.nodeList.addAll(index + 1, parentNode.children);
            }
        }
        for (TreeNode node : parentNode.children) {
            this.expandNode(node);
        }
        if (notifyDataSetChanged) {
            this.notifyDataSetChanged();
        }
    }

    public void collapseAll() {
        this.collapseNode(this.rootNode, false);
        this.notifyDataSetChanged();
    }

    public void collapseNode(TreeNode<E> parentNode) {
        this.collapseNode(parentNode, true);
    }

    public void collapseNode(TreeNode<E> parentNode, boolean notifyDataSetChanged) {
        if (parentNode.isExpand && parentNode != this.rootNode) {
            parentNode.isExpand = false;
            this.nodeList.removeAll(parentNode.children);
        }
        for (TreeNode node : parentNode.children) {
            this.collapseNode(node);
        }
        if (notifyDataSetChanged) {
            this.notifyDataSetChanged();
        }
    }

    private List<TreeNode<E>> getNodeList(@NonNull TreeNode<E> rootNode) {
        ArrayList<TreeNode<TreeNode>> nodeList = new ArrayList<TreeNode<TreeNode>>();
        Stack nodes = new Stack();
        nodes.add(rootNode);
        while (!nodes.isEmpty()) {
            TreeNode node = (TreeNode)nodes.pop();
            if (this.rootNode == node || node.isExpand && !node.children.isEmpty()) {
                List children = node.children;
                for (int i = children.size() - 1; i >= 0; --i) {
                    TreeNode childNode = children.get(i);
                    nodes.push(childNode);
                }
            }
            if (node == rootNode) continue;
            nodeList.add(node);
        }
        return nodeList;
    }

    public abstract void onBindViewHolder(RecyclerView.ViewHolder var1, TreeNode<E> var2, E var3, int var4, int var5);

    public void onBindViewHolder(final @NonNull RecyclerView.ViewHolder holder, int position) {
        TreeNode<E> node = this.getNode(position);
        this.onBindViewHolder(holder, node, node.item, this.getItemViewType(position), position);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int adapterPosition = holder.getAdapterPosition();
                if (null != TreeAdapter.this.wrapperAdapter) {
                    adapterPosition -= TreeAdapter.this.wrapperAdapter.getExtraViewCount(adapterPosition);
                }
                TreeNode node = TreeAdapter.this.getNode(adapterPosition);
                if (null != TreeAdapter.this.callback && !node.isExpand && !node.isLoad) {
                    List children = TreeAdapter.this.callback.onLoad(node);
                    if (null != children) {
                        for (TreeNode child : children) {
                            child.parent = node;
                        }
                        node.children.addAll(children);
                    }
                    node.isLoad = true;
                }
                boolean isExpand = node.isExpand;
                node.isExpand = true;
                List childNodeList = TreeAdapter.this.getNodeList(node);
                boolean bl = node.isExpand = !isExpand;
                if (!childNodeList.isEmpty()) {
                    int size = childNodeList.size();
                    TreeAdapter.this.onNodeExpand(node, node.item, holder, !isExpand);
                    if (isExpand) {
                        TreeAdapter.this.nodeList.removeAll(childNodeList);
                        TreeAdapter.this.notifyItemRangeRemoved(adapterPosition + 1, size);
                    } else {
                        TreeAdapter.this.nodeList.addAll(adapterPosition + 1, childNodeList);
                        TreeAdapter.this.notifyItemRangeInserted(adapterPosition + 1, size);
                    }
                } else if (null != TreeAdapter.this.listener) {
                    TreeAdapter.this.listener.onNodeItemClick(node, node.item, v, adapterPosition);
                }
            }
        });
    }

    protected void onNodeExpand(TreeNode<E> node, E item, RecyclerView.ViewHolder holder, boolean expand) {
    }

    public TreeNode<E> getNode(int position) {
        return this.nodeList.get(position);
    }

    @Nullable
    public E getItem(int position) {
        E item = null;
        TreeNode<E> treeNode = this.nodeList.get(position);
        if (null != treeNode) {
            item = treeNode.item;
        }
        return item;
    }

    public int getItemCount() {
        return this.nodeList.size();
    }

    public void remove(int position) {
        TreeNode<E> node = this.nodeList.get(position);
        if (null != node) {
            this.removeNode(node);
        }
    }

    public void removeNode(@NonNull TreeNode<E> node) {
        if (null != node) {
            int position;
            List childNodes = node.children;
            if (node.isExpand && !childNodes.isEmpty()) {
                int size = childNodes.size();
                for (int i = size - 1; i >= 0; --i) {
                    TreeNode treeNode = childNodes.get(i);
                    this.removeNode(treeNode);
                }
            }
            if (0 <= (position = this.nodeList.indexOf(node))) {
                TreeNode<E> childNode = this.nodeList.remove(position);
                this.notifyItemRemoved(position);
                TreeNode parent = childNode.parent;
                if (null != parent) {
                    parent.children.remove(childNode);
                }
            }
        }
    }

    public void add(E e) {
        TreeNode<E> treeNode = new TreeNode<E>(this.rootNode, e);
        this.add(treeNode);
    }

    public void add(TreeNode<E> node) {
        node.parent = this.rootNode;
        this.rootNode.children.add(node);
        ArrayList<TreeNode<E>> nodeItems = new ArrayList<TreeNode<E>>();
        nodeItems.add(node);
        List<TreeNode<E>> nodeList = this.getNodeList(node);
        if (!nodeList.isEmpty()) {
            nodeItems.addAll(nodeList);
        }
        int itemCount = this.getItemCount();
        this.nodeList.addAll(nodeItems);
        this.notifyItemRangeInserted(itemCount, nodeItems.size());
    }

    public void addFirst(E e) {
        TreeNode<E> treeNode = new TreeNode<E>(this.rootNode, e);
        this.addFirst(treeNode);
    }

    public void addFirst(TreeNode<E> node) {
        node.parent = this.rootNode;
        this.rootNode.children.add(0, node);
        ArrayList<TreeNode<E>> nodeItems = new ArrayList<TreeNode<E>>();
        nodeItems.add(node);
        List<TreeNode<E>> nodeList = this.getNodeList(node);
        if (!nodeList.isEmpty()) {
            nodeItems.addAll(nodeList);
        }
        this.nodeList.addAll(0, nodeItems);
        this.notifyItemRangeInserted(0, nodeItems.size());
    }

    public void setLoadCallback(TreeLoadCallback<E> callback) {
        this.callback = callback;
    }

    public void setOnTreeNodeClickListener(OnTreeNodeClickListener<E> listener) {
        this.listener = listener;
    }
}

