/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.support.swipe;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.support.swipe.SwipeAdapter;
import com.cz.widget.recyclerview.adapter.support.swipe.SwipeOverlayViewGroup;
import java.util.LinkedList;

public class SwipeItemTouchHelperCallback
extends ItemTouchHelper.Callback
implements View.OnTouchListener {
    private static final String TAG = "SwipeItemTouchHelperCallback";
    private float initialTouchX;
    private float initialTouchY;
    private float lastTouchX;
    private float lastTouchY;
    private final RecyclerBin recyclerBin = new RecyclerBin();
    private SwipeOverlayViewGroup overlayViewGroup;
    private RecyclerView recyclerView;
    private int selectPosition = -1;
    private int orientation = 1;
    private final SwipeAdapter adapter;

    public SwipeItemTouchHelperCallback(@NonNull SwipeAdapter swipeCallback) {
        this.adapter = swipeCallback;
    }

    public void attachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        recyclerView.setOnTouchListener((View.OnTouchListener)this);
        this.recyclerView = recyclerView;
        this.overlayViewGroup = new SwipeOverlayViewGroup(recyclerView);
    }

    private int getOrientation(RecyclerView recyclerView) {
        int orientation = 1;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            orientation = linearLayoutManager.getOrientation();
        }
        return orientation;
    }

    public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
        int adapterPosition = viewHolder.getAdapterPosition();
        int flag = ItemTouchHelper.Callback.makeFlag((int)0, (int)2);
        if (null != this.adapter && this.adapter.isSwipeEnable(adapterPosition)) {
            flag = ItemTouchHelper.Callback.makeFlag((int)1, (int)this.adapter.getMoveFlag());
        }
        return flag;
    }

    public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
        return false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        int action = event.getActionMasked();
        if (action == 0) {
            this.initialTouchX = event.getX();
            this.initialTouchY = event.getY();
        } else if (action == 2) {
            float x = event.getX();
            float y = event.getY();
            float diffX = x - this.lastTouchX;
            float diffY = y - this.lastTouchY;
            this.lastTouchX = x;
            this.lastTouchY = y;
        }
        return false;
    }

    public void onChildDraw(@NonNull Canvas c, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        int adapterPosition = viewHolder.getAdapterPosition();
        View itemView = viewHolder.itemView;
        float translationX = dX;
        View adapterView = this.overlayViewGroup.findAdapterView(adapterPosition);
        if (dX < 0.0f && actionState == 1) {
            translationX = dX * (float)adapterView.getWidth() / (float)itemView.getWidth();
        }
        adapterView.setTranslationX(translationX);
        this.overlayViewGroup.getOverlayView().draw(c);
        super.onChildDraw(c, recyclerView, viewHolder, translationX, dY, actionState, isCurrentlyActive);
        Log.i((String)TAG, (String)("onChildDraw:" + adapterPosition + " dx:" + dX + " dy:" + dY + " actionState:" + actionState + " isCurrentlyActive:" + isCurrentlyActive + " translationX:" + translationX));
    }

    public void onChildDrawOver(@NonNull Canvas c, @NonNull RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        super.onChildDrawOver(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
    }

    @SuppressLint(value={"Range"})
    public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int actionState) {
        super.onSelectedChanged(viewHolder, actionState);
        if (1 == actionState) {
            RecyclerView.ViewHolder selectViewHolder;
            int adapterPosition = viewHolder.getAdapterPosition();
            if (this.selectPosition != -1 && this.selectPosition != adapterPosition && null != (selectViewHolder = this.recyclerView.findViewHolderForAdapterPosition(this.selectPosition))) {
                selectViewHolder.itemView.animate().translationX(0.0f).setUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        int selectAdapterPosition = selectViewHolder.getAdapterPosition();
                        View adapterView = SwipeItemTouchHelperCallback.this.overlayViewGroup.findAdapterView(selectAdapterPosition);
                        if (null != adapterView) {
                            adapterView.setTranslationX(selectViewHolder.itemView.getTranslationX());
                        }
                    }
                }).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationStart(Animator animation) {
                        super.onAnimationStart(animation);
                        selectViewHolder.setIsRecyclable(false);
                    }

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        selectViewHolder.setIsRecyclable(true);
                    }
                });
            }
            if (null != this.adapter && this.adapter.isSwipeEnable(adapterPosition)) {
                this.selectPosition = adapterPosition;
                View adapterView = this.overlayViewGroup.findAdapterView(adapterPosition);
                if (null == adapterView) {
                    int viewType = this.adapter.getSwipeMenuViewType(adapterPosition);
                    View scrapView = this.recyclerBin.getViewFromScrap(adapterPosition, viewType);
                    if (null != scrapView) {
                        this.overlayViewGroup.add(scrapView);
                        this.layoutSwipeView(viewHolder.itemView, scrapView, 8);
                    } else {
                        View view = this.recyclerBin.getView(this.overlayViewGroup.getOverlayView(), adapterPosition, viewType);
                        int widthMeasureSpec = 0;
                        int heightMeasureSpec = 0;
                        switch (8) {
                            case 4: 
                            case 8: 
                            case 16: 
                            case 32: {
                                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)Integer.MIN_VALUE);
                                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)viewHolder.itemView.getHeight(), (int)0x40000000);
                                break;
                            }
                            case 1: 
                            case 2: {
                                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)viewHolder.itemView.getWidth(), (int)Integer.MIN_VALUE);
                                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0x40000000);
                                break;
                            }
                        }
                        this.overlayViewGroup.measureChild(view, widthMeasureSpec, heightMeasureSpec);
                        this.layoutSwipeView(viewHolder.itemView, view, 8);
                        this.overlayViewGroup.add(view);
                    }
                }
            }
        }
        if (0 == actionState) {
            // empty if block
        }
    }

    @SuppressLint(value={"Range"})
    public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        int adapterPosition = viewHolder.getAdapterPosition();
    }

    public float getSwipeThreshold(@NonNull RecyclerView.ViewHolder viewHolder) {
        int adapterPosition = viewHolder.getAdapterPosition();
        View adapterView = this.overlayViewGroup.findAdapterView(adapterPosition);
        if (null != adapterView) {
            return 1.0f;
        }
        return super.getSwipeThreshold(viewHolder);
    }

    public void layoutSwipeView(View view, View menuLayout, int direction) {
        int left = view.getLeft();
        int top = view.getTop();
        int right = view.getRight();
        int bottom = view.getBottom();
        switch (direction) {
            case 4: 
            case 16: {
                menuLayout.layout(left - menuLayout.getMeasuredWidth(), top, left, bottom);
                break;
            }
            case 8: 
            case 32: {
                menuLayout.layout(right, top, right + menuLayout.getMeasuredWidth(), bottom);
                break;
            }
            case 1: {
                menuLayout.layout(left, top - menuLayout.getMeasuredHeight(), right, top);
                break;
            }
            case 2: {
                menuLayout.layout(left, bottom, right, bottom + menuLayout.getMeasuredHeight());
                break;
            }
        }
    }

    private class RecyclerBin {
        public SparseArray<LinkedList<View>> scrapArray = new SparseArray();

        private RecyclerBin() {
        }

        public void clear() {
            this.scrapArray.clear();
        }

        public void addScrapView(int viewType, @NonNull View view) {
            LinkedList<View> viewList = (LinkedList<View>)this.scrapArray.get(viewType);
            if (null == viewList) {
                viewList = new LinkedList<View>();
                this.scrapArray.put(viewType, viewList);
            }
            viewList.add(view);
        }

        public void recycler(int viewType, View view) {
            this.addScrapView(viewType, view);
        }

        @Nullable
        private View getViewFromScrap(int position, int viewType) {
            View stickyView = null;
            LinkedList viewList = (LinkedList)this.scrapArray.get(viewType);
            if (null != viewList && !viewList.isEmpty()) {
                stickyView = (View)viewList.pollFirst();
            }
            if (null != stickyView) {
                SwipeOverlayViewGroup.LayoutParams layoutParams = (SwipeOverlayViewGroup.LayoutParams)stickyView.getLayoutParams();
                layoutParams.position = position;
            }
            return stickyView;
        }

        @NonNull
        public View getView(ViewGroup parent, int position, int stickyViewType) {
            if (null == SwipeItemTouchHelperCallback.this.adapter) {
                throw new NullPointerException("The adapter was null, Make sure you set up the adapter!");
            }
            LinkedList viewList = (LinkedList)this.scrapArray.get(stickyViewType);
            View stickyView = null == viewList || viewList.isEmpty() ? SwipeItemTouchHelperCallback.this.adapter.onCreateSwipeMenuView(parent.getContext(), parent, stickyViewType) : (View)viewList.pollFirst();
            SwipeOverlayViewGroup.LayoutParams layoutParams = (SwipeOverlayViewGroup.LayoutParams)stickyView.getLayoutParams();
            layoutParams.position = position;
            return stickyView;
        }
    }
}

