/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.support.expand;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.WrapperAdapter;
import com.cz.widget.recyclerview.adapter.listener.OnExpandItemClickListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ExpandAdapter<K, E>
extends RecyclerView.Adapter {
    private static final int HEADER_ITEM = 0;
    private static final int CHILD_ITEM = 1;
    private WrapperAdapter wrapperAdapter;
    private List<Entry<K, List<E>>> expandList = new ArrayList<Entry<K, List<E>>>();
    private int[] expandStepArray;
    private OnExpandItemClickListener listener;

    public ExpandAdapter(LinkedHashMap<K, List<E>> map) {
        this(map, false);
    }

    public ExpandAdapter(LinkedHashMap<K, List<E>> map, boolean expand) {
        this(ExpandAdapter.convertLinkedHashMap(map), expand);
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        if (adapter instanceof WrapperAdapter) {
            this.wrapperAdapter = (WrapperAdapter)adapter;
        }
    }

    private static <K, E> List<Entry<K, List<E>>> convertLinkedHashMap(LinkedHashMap<K, List<E>> items) {
        ArrayList<Entry<K, List<Entry<K, List<E>>>>> expandList = new ArrayList<Entry<K, List<Entry<K, List<E>>>>>();
        if (!items.isEmpty()) {
            for (Map.Entry<K, List<E>> entry : items.entrySet()) {
                expandList.add(new Entry<K, List<E>>(entry.getKey(), entry.getValue()));
            }
        }
        return expandList;
    }

    private ExpandAdapter(List<Entry<K, List<E>>> items, boolean expand) {
        if (null != items) {
            this.expandList.addAll(items);
            int size = items.size();
            for (int i = 0; i < size; ++i) {
                Entry<K, List<E>> entry = this.expandList.get(i);
                ((Entry)entry).isExpand = expand;
            }
            this.updateGroupItemInfo(items, true);
        }
    }

    private void updateGroupItemInfo(List<Entry<K, List<E>>> items, boolean resizeStepArray) {
        if (resizeStepArray) {
            this.expandStepArray = new int[items.size()];
        }
        int count = 0;
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            Entry<K, List<E>> entry = items.get(i);
            List children = (List)((Entry)entry).children;
            this.expandStepArray[i] = count;
            int itemSize = null == children || !((Entry)entry).isExpand ? 0 : children.size();
            count += itemSize + 1;
        }
    }

    public int getGroupCount() {
        return this.expandList.size();
    }

    public int getChildrenCount(int position) {
        return ((List)((Entry)this.expandList.get(position)).children).size();
    }

    public K getGroup(int position) {
        return (K)((Entry)this.expandList.get(position)).k;
    }

    public List<E> getGroupItems(int groupPosition) {
        return (List)((Entry)this.expandList.get(groupPosition)).children;
    }

    public E getChild(int groupPosition, int childPosition) {
        return this.getGroupItems(groupPosition).get(childPosition);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder holder = null;
        switch (viewType) {
            case 0: {
                holder = this.createGroupHolder(parent);
                break;
            }
            case 1: {
                holder = this.createChildHolder(parent);
            }
        }
        return holder;
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, int position) {
        int viewType = this.getItemViewType(position);
        final int groupPosition = this.getGroupPosition(position);
        switch (viewType) {
            case 0: {
                this.onBindGroupHolder(holder, groupPosition);
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Entry entry;
                        int adapterPosition = holder.getAdapterPosition();
                        if (null != ExpandAdapter.this.wrapperAdapter) {
                            adapterPosition -= ExpandAdapter.this.wrapperAdapter.getExtraViewCount(adapterPosition);
                        }
                        int newGroupPosition = ExpandAdapter.this.getGroupPosition(adapterPosition);
                        boolean isExpand = (entry = (Entry)ExpandAdapter.this.expandList.get(newGroupPosition)).isExpand;
                        entry.isExpand = !isExpand;
                        ExpandAdapter.this.onGroupExpand(holder, !isExpand, newGroupPosition);
                        ExpandAdapter.this.expandGroup(adapterPosition, newGroupPosition, !isExpand);
                    }
                });
                break;
            }
            case 1: {
                final int childPosition = this.getChildPosition(position);
                this.onBindChildHolder(holder, groupPosition, childPosition);
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != ExpandAdapter.this.listener) {
                            ExpandAdapter.this.listener.onItemClick(v, groupPosition, childPosition);
                        }
                    }
                });
            }
        }
    }

    protected void onGroupExpand(RecyclerView.ViewHolder holder, boolean expand, int groupPosition) {
    }

    private void expandGroup(int position, int groupPosition, boolean expand) {
        List<E> childItems = this.getGroupItems(groupPosition);
        int expandCount = null == childItems ? 0 : childItems.size();
        this.updateGroupItemInfo(this.expandList, false);
        if (expand) {
            this.notifyItemRangeInserted(position + 1, expandCount);
        } else {
            this.notifyItemRangeRemoved(position + 1, expandCount);
        }
    }

    public abstract RecyclerView.ViewHolder createGroupHolder(ViewGroup var1);

    public abstract RecyclerView.ViewHolder createChildHolder(ViewGroup var1);

    public abstract void onBindGroupHolder(RecyclerView.ViewHolder var1, int var2);

    public abstract RecyclerView.ViewHolder onBindChildHolder(RecyclerView.ViewHolder var1, int var2, int var3);

    public int getItemCount() {
        int itemCount = 0;
        for (int i = 0; i < this.expandList.size(); ++i) {
            Entry<K, List<E>> entry = this.expandList.get(i);
            if (null != ((Entry)entry).children && ((Entry)entry).isExpand) {
                itemCount += ((List)((Entry)entry).children).size();
            }
            ++itemCount;
        }
        return itemCount;
    }

    public int getItemViewType(int position) {
        int findPosition = ExpandAdapter.getSelectPosition(this.expandStepArray, position);
        Integer stepPosition = this.expandStepArray[findPosition];
        int viewType = 0;
        if (0 < position - stepPosition) {
            viewType = 1;
        }
        return viewType;
    }

    private int getGroupPosition(int position) {
        return ExpandAdapter.getSelectPosition(this.expandStepArray, position);
    }

    private int getChildPosition(int position) {
        int findPosition = ExpandAdapter.getSelectPosition(this.expandStepArray, position);
        return position - this.expandStepArray[findPosition] - 1;
    }

    public static int getSelectPosition(int[] positions, int firstVisiblePosition) {
        int start = 0;
        int end = positions.length;
        while (end - start > 1) {
            int middle = start + end >> 1;
            int middleValue = positions[middle];
            if (firstVisiblePosition > middleValue) {
                start = middle;
                continue;
            }
            if (firstVisiblePosition < middleValue) {
                end = middle;
                continue;
            }
            start = middle;
            break;
        }
        return start;
    }

    public void addGroup(K item, List<E> items) {
        int index = this.getGroupCount();
        this.addGroup(item, items, index, false);
    }

    public void addGroup(K item, List<E> children, int index, boolean expand) {
        Entry<K, List<E>> entry = new Entry<K, List<E>>(item, children);
        ((Entry)entry).isExpand = expand;
        this.expandList.add(index, entry);
        this.updateGroupItemInfo(this.expandList, true);
        int itemSize = null == children || !expand ? 0 : children.size();
        int startIndex = this.expandStepArray[index];
        this.notifyItemRangeInserted(startIndex, itemSize + 1);
    }

    public void removeGroup(int position) {
        if (0 <= position && position < this.expandList.size()) {
            int index = this.expandStepArray[position];
            int itemSize = 0;
            Entry<K, List<E>> entry = this.expandList.remove(position);
            if (((Entry)entry).isExpand) {
                itemSize = null == ((Entry)entry).children ? 0 : ((List)((Entry)entry).children).size();
            }
            this.updateGroupItemInfo(this.expandList, true);
            this.notifyItemRangeRemoved(index, itemSize + 1);
        }
    }

    public void removeGroup(int position, int childPosition) {
        if (this.expandList.isEmpty()) {
            return;
        }
        int groupPosition = this.expandStepArray[position];
        Entry<K, List<E>> entry = this.expandList.get(position);
        List children = (List)((Entry)entry).children;
        if (!children.isEmpty()) {
            children.remove(childPosition);
            if (((Entry)entry).isExpand) {
                this.updateGroupItemInfo(this.expandList, true);
                int startIndex = groupPosition + 1;
                int removePosition = startIndex + childPosition;
                this.notifyItemRemoved(removePosition);
            }
        }
        this.notifyItemChanged(groupPosition);
    }

    public void swap(LinkedHashMap<K, List<E>> items) {
        this.swap(ExpandAdapter.convertLinkedHashMap(items), false);
    }

    public void swap(List<Entry<K, List<E>>> items, boolean expand) {
        if (!items.isEmpty()) {
            this.expandStepArray = null;
            this.expandList.clear();
            this.expandList.addAll(items);
            for (int i = 0; i < this.expandList.size(); ++i) {
                Entry<K, List<E>> entry = this.expandList.get(i);
                ((Entry)entry).isExpand = expand;
            }
            this.updateGroupItemInfo(this.expandList, true);
            this.notifyDataSetChanged();
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.expandList.size(); ++i) {
            Entry<K, List<E>> entry = this.expandList.get(i);
            ((Entry)entry).isExpand = true;
        }
        this.updateGroupItemInfo(this.expandList, false);
        this.notifyDataSetChanged();
    }

    public void collapseAll() {
        for (int i = 0; i < this.expandList.size(); ++i) {
            Entry<K, List<E>> entry = this.expandList.get(i);
            ((Entry)entry).isExpand = false;
        }
        this.updateGroupItemInfo(this.expandList, false);
        this.notifyDataSetChanged();
    }

    public boolean getGroupExpand(int position) {
        Entry<K, List<E>> entry = this.expandList.get(position);
        return ((Entry)entry).isExpand;
    }

    public void setOnExpandItemClickListener(OnExpandItemClickListener listener) {
        this.listener = listener;
    }

    static class Entry<K, E> {
        private final K k;
        private final E children;
        private boolean isExpand = false;

        public Entry(K k, E children) {
            this.k = k;
            this.children = children;
        }
    }
}

