/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.wrapper.drag.Moveable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseAdapter<VH extends RecyclerView.ViewHolder, E>
extends RecyclerView.Adapter<VH>
implements Moveable {
    private final List<E> itemList = new ArrayList();

    public BaseAdapter(@NonNull List<E> itemList) {
        if (null != itemList) {
            this.itemList.addAll(itemList);
        }
    }

    @CallSuper
    public void onBindViewHolder(@NonNull VH holder, int position) {
    }

    public E getItem(int position) {
        return this.itemList.get(position);
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    public void removeList(@Nullable List<E> list) {
        this.removeList(list, true);
    }

    public void removeList(@Nullable List<E> list, boolean notifyDataSetChanged) {
        if (null != list) {
            this.itemList.removeAll(list);
            if (notifyDataSetChanged) {
                this.notifyDataSetChanged();
            }
        }
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean notifyDataSetChanged) {
        int itemCount = this.getItemCount();
        this.itemList.clear();
        if (notifyDataSetChanged) {
            this.notifyDataSetChanged();
            this.notifyItemRangeRemoved(0, itemCount);
        }
    }

    public void add(@Nullable E item) {
        int index = this.getItemCount();
        this.add(item, index, true);
    }

    public void add(@Nullable E item, int index) {
        this.add(item, index, true);
    }

    public void add(@Nullable E item, int index, boolean notifyDataSetChanged) {
        if (null != item) {
            this.itemList.add(index, item);
            if (notifyDataSetChanged) {
                this.notifyItemInserted(index);
            }
        }
    }

    public int indexOf(@Nullable E item) {
        return this.itemList.indexOf(item);
    }

    public void set(int index, @Nullable E item) {
        this.set(index, item, true);
    }

    public void set(int index, @Nullable E item, boolean notifyDataSetChanged) {
        this.itemList.set(index, item);
        if (notifyDataSetChanged) {
            this.notifyItemChanged(index);
        }
    }

    public void addAll(List<E> list) {
        this.addAll(list, true);
    }

    public void addAll(List<E> list, boolean notifyDataSetChanged) {
        int itemCount = this.getItemCount();
        this.addAll(itemCount, list, notifyDataSetChanged);
    }

    public void addAll(int index, @Nullable List<E> list) {
        this.addAll(index, list, true);
    }

    public void addAll(int index, @Nullable List<E> list, boolean notifyDataSetChanged) {
        if (null != list) {
            this.itemList.addAll(index, list);
            if (notifyDataSetChanged) {
                this.notifyItemRangeInserted(index, list.size());
            }
        }
    }

    public void remove(int start, int count) {
        this.remove(start, count, true);
    }

    public void remove(int start, int count, boolean notifyDataSetChanged) {
        int index = 0;
        while (index++ < count) {
            this.itemList.remove(start);
        }
        if (notifyDataSetChanged) {
            this.notifyItemRangeRemoved(start, count);
        }
    }

    public void remove(@Nullable E item) {
        this.remove(item, true);
    }

    public void remove(@Nullable E item, boolean notifyDataSetChanged) {
        this.remove(this.indexOf(item), notifyDataSetChanged);
    }

    public void remove(int position, boolean notifyDataSetChanged) {
        if (-1 != position) {
            this.itemList.remove(position);
            if (notifyDataSetChanged) {
                this.notifyItemRemoved(position);
            }
        }
    }

    public void swap(@Nullable List<E> list) {
        this.clear(true);
        if (null != list) {
            this.addAll(list, false);
        }
    }

    public void swap(@Nullable List<E> list, boolean notifyDataSetChanged) {
        this.clear(true);
        if (null != list) {
            this.addAll(list, notifyDataSetChanged);
        }
    }

    @Override
    public void move(int from, int to) {
        Collections.swap(this.itemList, from, to);
    }

    @NonNull
    public List<E> getItemList() {
        return this.itemList;
    }
}

