/*
 * Decompiled with CFR 0.152.
 */
package com.github.mohaka.ratingstar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;

class Utilities {
    private Context context;

    Utilities() {
    }

    static Utilities with(Context context) {
        Utilities reVal = new Utilities();
        reVal.context = context;
        return reVal;
    }

    Drawable getRD(int res) {
        return ContextCompat.getDrawable((Context)this.context.getApplicationContext(), (int)res);
    }

    Drawable getRDV(int res) {
        if (Utilities.hasLollipop()) {
            return this.getRD(res);
        }
        return VectorDrawableCompat.create((Resources)this.context.getResources(), (int)res, (Resources.Theme)this.context.getTheme());
    }

    static boolean isPointInside(Point point, Point ... inBoundaries) {
        boolean result = false;
        int i = 0;
        int j = inBoundaries.length - 1;
        while (i < inBoundaries.length) {
            if (inBoundaries[i].y > point.y != inBoundaries[j].y > point.y && point.x < (inBoundaries[j].x - inBoundaries[i].x) * (point.y - inBoundaries[i].y) / (inBoundaries[j].y - inBoundaries[i].y) + inBoundaries[i].x) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    static Point centerPoint(Point p1, Point p2) {
        return new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
    }

    static int lineLength(Point p1, Point p2) {
        double a = Math.abs(p1.x - p2.x);
        double b = Math.abs(p1.y - p2.y);
        a = Math.pow(a, 2.0);
        b = Math.pow(b, 2.0);
        return (int)Math.sqrt(a + b);
    }

    static boolean hasJellyBeanMR1() {
        return Build.VERSION.SDK_INT >= 17;
    }

    static boolean hasLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    static int getThemeColor(Context context, int attributeColor) {
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(attributeColor, value, true);
        return value.data;
    }
}

