/*
 * Decompiled with CFR 0.152.
 */
package com.github.mohaka.ratingstar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.github.mohaka.ratingstar.R;
import com.github.mohaka.ratingstar.Utilities;

public class RatingStar
extends FrameLayout {
    private static final boolean SHOW_GUIDELINES = false;
    private static final String KEY_SUPER_STATE = "__key_super_state";
    private static final String KEY_RATING = "__key_rating";
    private static final String KEY_SHOW_NUMBERS = "__key_show_numbers";
    private static final String KEY_STAR_COLOR = "__key_star_color";
    private static final String KEY_HIGHLIGHT_COLOR = "__key_highlight_color";
    private AppCompatImageView[] stars = new AppCompatImageView[5];
    private AppCompatImageView[] numbers = new AppCompatImageView[5];
    private Drawable[][] drawables = new Drawable[5][2];
    private Point[][] boundaries = new Point[5][4];
    private int rating;
    private boolean showNumbers;
    private int starColor;
    private int highlightColor;
    private RateValueListener listener;
    private Path[] debugPaths = new Path[5];
    private Paint debugPaint = new Paint();

    public RatingStar(Context context) {
        super(context);
        this.init(context);
        this.fetchAttributes(context, null, 0);
    }

    public RatingStar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
        this.fetchAttributes(context, attrs, 0);
    }

    public RatingStar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
        this.fetchAttributes(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchAttributes(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RatingStar, defStyleAttr, 0);
        try {
            this.setRating(a.getInt(R.styleable.RatingStar_rating, 0));
            this.setShowNumbers(a.getBoolean(R.styleable.RatingStar_showNumbers, true));
            int starColor = Utilities.getThemeColor(context, R.attr.colorPrimary);
            starColor = a.getColor(R.styleable.RatingStar_starColor, starColor);
            int highlightColor = Utilities.getThemeColor(context, R.attr.colorAccent);
            highlightColor = a.getColor(R.styleable.RatingStar_highlightColor, highlightColor);
            this.setStarColor(starColor);
            this.setHighlightColor(highlightColor);
        }
        finally {
            a.recycle();
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_SUPER_STATE, superState);
        bundle.putInt(KEY_RATING, this.rating);
        bundle.putBoolean(KEY_SHOW_NUMBERS, this.showNumbers);
        bundle.putInt(KEY_STAR_COLOR, this.starColor);
        bundle.putInt(KEY_HIGHLIGHT_COLOR, this.highlightColor);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.setRating(bundle.getInt(KEY_RATING));
            this.setShowNumbers(bundle.getBoolean(KEY_SHOW_NUMBERS));
            this.setStarColor(bundle.getInt(KEY_STAR_COLOR));
            this.setHighlightColor(bundle.getInt(KEY_HIGHLIGHT_COLOR));
            state = bundle.getParcelable(KEY_SUPER_STATE);
        }
        super.onRestoreInstanceState(state);
    }

    private void init(Context context) {
        this.stars[0] = new AppCompatImageView(context);
        this.stars[1] = new AppCompatImageView(context);
        this.stars[2] = new AppCompatImageView(context);
        this.stars[3] = new AppCompatImageView(context);
        this.stars[4] = new AppCompatImageView(context);
        Utilities utilities = Utilities.with(this.getContext());
        Drawable normal_0 = utilities.getRD(R.drawable.ic_petal_1);
        Drawable selected_0 = utilities.getRD(R.drawable.ic_petal_1);
        StateListDrawable drawable_0 = new StateListDrawable();
        drawable_0.addState(new int[]{0x10100A1}, selected_0);
        drawable_0.addState(new int[0], normal_0);
        this.stars[0].setImageDrawable((Drawable)drawable_0);
        this.drawables[0][0] = normal_0;
        this.drawables[0][1] = selected_0;
        Drawable normal_1 = utilities.getRD(R.drawable.ic_petal_2);
        Drawable selected_1 = utilities.getRD(R.drawable.ic_petal_2);
        StateListDrawable drawable_1 = new StateListDrawable();
        drawable_1.addState(new int[]{0x10100A1}, selected_1);
        drawable_1.addState(new int[0], normal_1);
        this.stars[1].setImageDrawable((Drawable)drawable_1);
        this.drawables[1][0] = normal_1;
        this.drawables[1][1] = selected_1;
        Drawable normal_2 = utilities.getRD(R.drawable.ic_petal_3);
        Drawable selected_2 = utilities.getRD(R.drawable.ic_petal_3);
        StateListDrawable drawable_2 = new StateListDrawable();
        drawable_2.addState(new int[]{0x10100A1}, selected_2);
        drawable_2.addState(new int[0], normal_2);
        this.stars[2].setImageDrawable((Drawable)drawable_2);
        this.drawables[2][0] = normal_2;
        this.drawables[2][1] = selected_2;
        Drawable normal_3 = utilities.getRD(R.drawable.ic_petal_4);
        Drawable selected_3 = utilities.getRD(R.drawable.ic_petal_4);
        StateListDrawable drawable_3 = new StateListDrawable();
        drawable_3.addState(new int[]{0x10100A1}, selected_3);
        drawable_3.addState(new int[0], normal_3);
        this.stars[3].setImageDrawable((Drawable)drawable_3);
        this.drawables[3][0] = normal_3;
        this.drawables[3][1] = selected_3;
        Drawable normal_4 = utilities.getRD(R.drawable.ic_petal_5);
        Drawable selected_4 = utilities.getRD(R.drawable.ic_petal_5);
        StateListDrawable drawable_4 = new StateListDrawable();
        drawable_4.addState(new int[]{0x10100A1}, selected_4);
        drawable_4.addState(new int[0], normal_4);
        this.stars[4].setImageDrawable((Drawable)drawable_4);
        this.drawables[4][0] = normal_4;
        this.drawables[4][1] = selected_4;
        this.numbers[0] = new AppCompatImageView(context);
        this.numbers[0].setImageResource(R.drawable.ic_num_1);
        this.numbers[1] = new AppCompatImageView(context);
        this.numbers[1].setImageResource(R.drawable.ic_num_2);
        this.numbers[2] = new AppCompatImageView(context);
        this.numbers[2].setImageResource(R.drawable.ic_num_3);
        this.numbers[3] = new AppCompatImageView(context);
        this.numbers[3].setImageResource(R.drawable.ic_num_4);
        this.numbers[4] = new AppCompatImageView(context);
        this.numbers[4].setImageResource(R.drawable.ic_num_5);
        for (AppCompatImageView star : this.stars) {
            this.addView((View)star, -1, -1);
        }
        for (AppCompatImageView star : this.numbers) {
            this.addView((View)star, -1, -1);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: 
            case 2: {
                for (int i = 0; i < this.boundaries.length; ++i) {
                    Point[] points;
                    Point touchPoint = new Point((int)event.getX(), (int)event.getY());
                    if (!Utilities.isPointInside(touchPoint, points = this.boundaries[i])) continue;
                    this.setRating(i + 1);
                    return true;
                }
                this.setRating(0);
                return true;
            }
            case 1: {
                if (this.listener != null) {
                    this.listener.onValueChanged(this.getRating());
                }
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    public int getPaddingEnd() {
        return Utilities.hasJellyBeanMR1() ? super.getPaddingEnd() : super.getPaddingRight();
    }

    public int getPaddingStart() {
        return Utilities.hasJellyBeanMR1() ? super.getPaddingStart() : super.getPaddingLeft();
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        int width = w - this.getPaddingEnd() - this.getPaddingStart();
        int height = h - this.getPaddingTop() - this.getPaddingBottom();
        boolean isWide = width > height;
        int margin = Math.abs((width - height) / 2);
        int left = this.getPaddingStart() + (isWide ? margin : 0);
        int top = this.getPaddingTop() + (isWide ? 0 : margin);
        int length = isWide ? height : width;
        Point center = new Point(length / 2 + left, length * 13 / 24 + top);
        Point p1 = new Point(center.x, length / 100 + top);
        Point p2 = new Point(left + length, length * 38 / 100 + top);
        Point p3 = new Point(length * 81 / 100 + left, length * 97 / 100 + top);
        Point p4 = new Point(length * 19 / 100 + left, length * 97 / 100 + top);
        Point p5 = new Point(left, length * 38 / 100 + top);
        Point m1 = Utilities.centerPoint(p1, p2);
        Point m2 = Utilities.centerPoint(p2, p3);
        Point m3 = Utilities.centerPoint(p3, p4);
        Point m4 = Utilities.centerPoint(p4, p5);
        Point m5 = Utilities.centerPoint(p5, p1);
        this.boundaries[4][0] = p1;
        this.boundaries[4][1] = m1;
        this.boundaries[4][2] = center;
        this.boundaries[4][3] = m5;
        this.boundaries[0][0] = p2;
        this.boundaries[0][1] = m2;
        this.boundaries[0][2] = center;
        this.boundaries[0][3] = m1;
        this.boundaries[1][0] = p3;
        this.boundaries[1][1] = m3;
        this.boundaries[1][2] = center;
        this.boundaries[1][3] = m2;
        this.boundaries[2][0] = p4;
        this.boundaries[2][1] = m4;
        this.boundaries[2][2] = center;
        this.boundaries[2][3] = m3;
        this.boundaries[3][0] = p5;
        this.boundaries[3][1] = m5;
        this.boundaries[3][2] = center;
        this.boundaries[3][3] = m4;
        this.initDebugPaths();
    }

    private void initDebug() {
        this.setWillNotDraw(false);
        this.debugPaint.setColor(-65536);
        this.debugPaint.setStrokeWidth(3.0f);
        this.debugPaint.setStyle(Paint.Style.STROKE);
    }

    private void initDebugPaths() {
        for (int x = 0; x < this.boundaries.length; ++x) {
            Point[] points = this.boundaries[x];
            Path path = new Path();
            for (int i = 0; i < points.length; ++i) {
                Point point = points[i];
                if (i == 0) {
                    path.moveTo((float)point.x, (float)point.y);
                } else {
                    path.lineTo((float)point.x, (float)point.y);
                }
                if (i != points.length - 1) continue;
                path.close();
            }
            this.debugPaths[x] = path;
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (Path path : this.debugPaths) {
            canvas.drawPath(path, this.debugPaint);
        }
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
        for (int i = 0; i < 5; ++i) {
            this.stars[i].setSelected(i < rating);
        }
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public void setShowNumbers(boolean value) {
        this.showNumbers = value;
        for (AppCompatImageView number : this.numbers) {
            number.setVisibility(value ? 0 : 8);
        }
    }

    public void setListener(RateValueListener listener) {
        this.listener = listener;
    }

    public int getStarColor() {
        return this.starColor;
    }

    public void setStarColor(int starColor) {
        this.starColor = starColor;
        for (Drawable[] drawable2 : this.drawables) {
            drawable2[0].setColorFilter(starColor, PorterDuff.Mode.SRC_IN);
        }
    }

    public int getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(int highlightColor) {
        this.highlightColor = highlightColor;
        for (Drawable[] drawable2 : this.drawables) {
            drawable2[1].setColorFilter(highlightColor, PorterDuff.Mode.SRC_IN);
        }
    }

    public static interface RateValueListener {
        public void onValueChanged(int var1);
    }
}

