/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.Process;

import android.content.Context;
import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import androidx.core.content.ContextCompat;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.utils.DateAndTimeUtils;
import com.mobfox.android.dmp.Process.BaseProcess;
import org.json.JSONException;
import org.json.JSONObject;

public class WifiInfoProcess
extends BaseProcess {
    static final String TAG = "WifiInfoProcess";
    static final String JSON_ID = "WInf";

    public WifiInfoProcess(Context context) {
        super(context, TAG, JSON_ID);
    }

    @Override
    protected void collectData() {
        this.getCurrentWifiInfo(this.context);
    }

    @Override
    public void updatePermissions() {
        permitted = ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_WIFI_STATE") == 0;
    }

    void getCurrentWifiInfo(Context context) {
        NetworkInfo.DetailedState state;
        WifiInfo wifiInfo;
        WifiManager manager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (manager != null && manager.isWifiEnabled() && (wifiInfo = manager.getConnectionInfo()) != null && ((state = WifiInfo.getDetailedStateOf((SupplicantState)wifiInfo.getSupplicantState())) == NetworkInfo.DetailedState.CONNECTED || state == NetworkInfo.DetailedState.OBTAINING_IPADDR)) {
            JSONObject json = this.getJsonFromWifi(wifiInfo, manager.getDhcpInfo().gateway);
            this.dataArray.put(json);
        }
    }

    private JSONObject getJsonFromWifi(WifiInfo wifiInfo, int gateway) {
        JSONObject data = new JSONObject();
        try {
            data.put("bssid", (Object)wifiInfo.getBSSID());
            data.put("ssid", (Object)wifiInfo.getSSID());
            data.put("WStr", (Object)wifiInfo.toString());
            data.put("uTm", (Object)DateAndTimeUtils.getTimeFormat());
        }
        catch (JSONException e) {
            DLog.d(TAG, "Error : " + e.getLocalizedMessage());
        }
        return data;
    }
}

