/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.Process;

import android.content.Context;
import android.graphics.Point;
import android.media.AudioManager;
import android.os.Build;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.utils.DateAndTimeUtils;
import com.mobfox.android.dmp.Process.BaseProcess;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeviceInfoProcess
extends BaseProcess {
    static final String TAG = "DeviceInfoProcess";
    static final String JSON_ID = "DInf";

    public DeviceInfoProcess(Context context) {
        super(context, TAG, JSON_ID);
    }

    @Override
    public void collectData() {
        JSONObject data = this.getDeviceJson();
        if (data != null && !data.toString().equals("{}")) {
            this.dataArray.put(data);
        }
    }

    public JSONArray getDeviceInfo() {
        JSONArray info = new JSONArray();
        JSONObject data = this.getDeviceJson();
        if (data != null && !data.toString().equals("{}")) {
            info.put((Object)data);
        }
        return info;
    }

    private JSONObject getDeviceJson() {
        JSONObject data = new JSONObject();
        try {
            Point screen = this.getScreenSize(this.context);
            String size = screen.x + "x" + screen.y;
            data.put("scr", (Object)size);
            TelephonyManager manager = (TelephonyManager)this.context.getSystemService("phone");
            String carrierName = manager.getNetworkOperatorName();
            data.put("crr", (Object)carrierName);
            String lan = Locale.getDefault().toString();
            data.put("lang", (Object)lan);
            long upTime = SystemClock.elapsedRealtime();
            long activeTime = SystemClock.uptimeMillis();
            data.put("sUptm", upTime);
            data.put("sActm", activeTime);
            data.put("uTm", (Object)DateAndTimeUtils.getTimeFormat());
            data.put("mfcr", (Object)Build.MANUFACTURER);
            data.put("dVer", (Object)Build.VERSION.RELEASE);
            data.put("hrdw", (Object)Build.HARDWARE);
            data.put("dvNm", (Object)Build.DEVICE);
            data.put("sNm", (Object)"android");
            data.put("mdl", (Object)Build.MODEL);
            data.put("pkgn", (Object)MFXUtils.getBundleId(this.context));
            data.put("rng", (Object)this.getRingMode());
        }
        catch (Exception e) {
            DLog.d(TAG, "Error in collect data" + e.getLocalizedMessage());
        }
        return data;
    }

    @Override
    public void updatePermissions() {
        permitted = true;
    }

    private Point getScreenSize(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int width = (int)this.convertPixelToDP(size.x, context);
        int height = (int)this.convertPixelToDP(size.y, context);
        return new Point(width, height);
    }

    private float convertPixelToDP(float px, Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    private String getRingMode() {
        AudioManager audio = (AudioManager)this.context.getSystemService("audio");
        switch (audio.getRingerMode()) {
            case 2: {
                return "normal";
            }
            case 0: {
                return "silent";
            }
            case 1: {
                return "vibrate";
            }
        }
        return "unknown";
    }
}

