/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.Process;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManager;
import android.os.Build;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.utils.DateAndTimeUtils;
import com.mobfox.android.dmp.Process.BaseProcess;
import org.json.JSONException;
import org.json.JSONObject;

public class BatteryProcess
extends BaseProcess {
    static final String TAG = "BatteryProcess";
    static final String JSON_ID = "Batt";

    public BatteryProcess(Context context) {
        super(context, TAG, JSON_ID);
    }

    @Override
    public void collectData() {
        JSONObject json = new JSONObject();
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                BatteryManager bm = (BatteryManager)this.context.getApplicationContext().getSystemService("batterymanager");
                int batLevel = bm.getIntProperty(4);
                json.put("batt", batLevel);
                if (Build.VERSION.SDK_INT >= 23) {
                    json.put("chrg", bm.isCharging());
                }
            } else {
                int level = this.getBatteryPercentage();
                json.put("batt", level);
            }
            json.put("uTm", (Object)DateAndTimeUtils.getTimeFormat());
            this.dataArray.put(json);
        }
        catch (JSONException e) {
            DLog.d(TAG, "Error in collect data" + e.getLocalizedMessage());
        }
    }

    @Override
    public void updatePermissions() {
        permitted = true;
    }

    private int getBatteryPercentage() {
        IntentFilter iFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent batteryStatus = this.context.registerReceiver(null, iFilter);
        int level = batteryStatus != null ? batteryStatus.getIntExtra("level", -1) : -1;
        int scale = batteryStatus != null ? batteryStatus.getIntExtra("scale", -1) : -1;
        float batteryPct = (float)level / (float)scale;
        return (int)(batteryPct * 100.0f);
    }
}

