/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp;

import android.content.Context;
import com.mobfox.android.core.MFXConfiguration;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.logging.MobFoxReport;
import com.mobfox.android.core.networking.AsyncCallback;
import com.mobfox.android.core.networking.MobFoxRequest;
import com.mobfox.android.dmp.DMP;
import com.mobfox.android.dmp.utils.DMPUtils;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class DMPManager {
    static DMP dmpInst = DMP.getInstance();

    public static void updateDMP(Context context) {
        String ua = MobFoxReport.getUserAgent(context);
        String IPAddress = DMPUtils.getIPAddress(true);
        dmpInst.update(context, IPAddress, ua);
    }

    public static void postDMP(Context context, final DMPCallback cb) {
        if (!MobfoxSettings.getInstance(context).getAnalyticsPrefReportDMPEvents(context)) {
            return;
        }
        JSONObject u = dmpInst.getPost(context);
        if (u == null) {
            cb.onPostCompleted();
            return;
        }
        String dmpUrl = MFXConfiguration.sharedInstance(context).getUrlDMP(context);
        if (dmpUrl.length() == 0) {
            dmpUrl = "https://dmp.starbolt.io/logger.json";
        }
        MobFoxRequest req = new MobFoxRequest(dmpUrl);
        req.setTestMode(true);
        req.setData(u);
        req.setHeader("Content-Length", String.valueOf(u.toString().length()));
        req.setHeader("Content-Type", "application/json");
        req.post(new AsyncCallback(){

            @Override
            public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                if (cb != null) {
                    cb.onPostCompleted();
                }
            }

            @Override
            public void onError(Exception e) {
                if (cb != null) {
                    cb.onPostError();
                }
            }
        });
    }

    public static interface DMPCallback {
        public void onPostCompleted();

        public void onPostError();
    }
}

