/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.tags;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Base64;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.mobfox.android.JSInterface.BaseTagAPI;
import com.mobfox.android.JSInterface.StorageAPI;
import com.mobfox.android.JSInterface.SystemAPI;
import com.mobfox.android.JSInterface.TagToControllerAPI;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.core.logging.MobFoxReport;
import com.mobfox.android.core.logging.ReportsQueueManager;
import com.mobfox.android.core.utils.LayoutUtils;
import org.json.JSONObject;

public abstract class BaseTag
extends WebView {
    Context context;
    Handler mainHandler;
    boolean userInteraction = false;
    boolean ready;
    String mGuid;
    String mHtml;
    String mInvh;
    int adWidth;
    int adHeight;
    OnTagReadyCallback readyCB;

    public BaseTag(Context c, int width, int height, String html, String guid, String inv, OnTagReadyCallback cb) throws Exception {
        super(c);
        ReportsQueueManager.getInstance().initAnalyticsSession(c, inv, null);
        MobFoxReport.register(c);
        this.ready = false;
        this.mGuid = guid;
        this.mHtml = html;
        this.mInvh = inv;
        this.context = c;
        this.adWidth = width;
        this.adHeight = height;
        this.mainHandler = new Handler(this.context.getMainLooper());
        this.readyCB = cb;
        this.init();
    }

    protected void init() {
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(LayoutUtils.convertDpToPixel(this.adWidth, this.context), LayoutUtils.convertDpToPixel(this.adHeight, this.context)));
        this.setWebViewSettings(this);
    }

    private void setWebViewSettings(final BaseTag self) {
        self.setBackgroundColor(0);
        if (Build.VERSION.SDK_INT >= 19) {
            BaseTag.setWebContentsDebuggingEnabled((boolean)true);
        }
        self.getSettings().setJavaScriptEnabled(true);
        self.getSettings().setAppCacheEnabled(true);
        self.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            self.getSettings().setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            self.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT <= 19) {
            self.getSettings().setSupportMultipleWindows(true);
        }
        this.addJavascriptInterface(new BaseTagAPI(this), "Android");
        this.addJavascriptInterface(new TagToControllerAPI(this.context, this.mGuid, this.getAdType()), "MFXController");
        this.addJavascriptInterface(new SystemAPI(this.context), "MFXSystem");
        this.addJavascriptInterface(new StorageAPI(this.context), "MFXStorage");
        self.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                if (self.ready) {
                    return;
                }
                self.ready = true;
                if (BaseTag.this.readyCB != null) {
                    BaseTag.this.readyCB.onTagReady(self);
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (!self.userInteraction) {
                    return true;
                }
                ControllerEngine.callControllerFunc(BaseTag.this.context, BaseTag.this.mGuid, BaseTag.this.getAdType() + "Listener.Clicked", "url", url);
                return true;
            }
        });
        self.setWebChromeClient(new WebChromeClient(){

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                result.cancel();
                return true;
            }

            public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
                result.cancel();
                return true;
            }

            public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
                result.cancel();
                return true;
            }

            public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
                if (Build.VERSION.SDK_INT <= 19 && !isDialog && isUserGesture) {
                    WebView targetWebView = new WebView(BaseTag.this.context);
                    targetWebView.setWebViewClient(new WebViewClient(){

                        public void onPageStarted(WebView view, String url, Bitmap favicon) {
                            if (self.userInteraction) {
                                ControllerEngine.callControllerFunc(BaseTag.this.context, BaseTag.this.mGuid, BaseTag.this.getAdType() + "Listener.Clicked", "url", url);
                                self.userInteraction = false;
                            }
                            super.onPageStarted(view, url, favicon);
                        }
                    });
                    WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
                    transport.setWebView(targetWebView);
                    resultMsg.sendToTarget();
                    return true;
                }
                return super.onCreateWindow(view, isDialog, isUserGesture, resultMsg);
            }
        });
        self.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                self.userInteraction = true;
                return false;
            }
        });
        this.doLoadHtml(this.mHtml);
    }

    public void doLoadHtml(String in_html) {
        this.mHtml = in_html;
        String loadHtml = "<html><body></body></html";
        if (this.mHtml != null) {
            loadHtml = this.mHtml;
        }
        String unencodedHtml = loadHtml;
        String encodedHtml = Base64.encodeToString((byte[])unencodedHtml.getBytes(), (int)1);
        this.loadData(encodedHtml, "text/html", "base64");
    }

    public abstract JSONObject getAd();

    public abstract String getAdType();

    public abstract void onSuccess();

    public abstract void onFail(String var1);

    public abstract void onComplete();

    public abstract void onFinished();

    public abstract void onClick(String var1);

    public abstract void onClose();

    public static interface OnTagReadyCallback {
        public void onTagReady(BaseTag var1);
    }
}

