/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

public class WatermarkProvider {
    private static WatermarkProvider instance;

    private WatermarkProvider() {
    }

    public static WatermarkProvider getInstance() {
        if (instance == null) {
            instance = new WatermarkProvider();
        }
        return instance;
    }

    public ImageView getImageView(Context context, WatermarkSize size, WatermarkGravity gravity) {
        int marginY;
        int marginX;
        int height;
        int width;
        ImageView imageView = new ImageView(context);
        if (size == WatermarkSize.SMALL) {
            width = 40;
            height = 40;
            marginX = 4;
            marginY = 4;
        } else {
            width = 80;
            height = 80;
            marginX = 32;
            marginY = 32;
        }
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(width, height);
        switch (gravity) {
            case GRAVITY_TOP_LEFT: {
                params.addRule(10);
                params.addRule(9);
                params.setMargins(marginX, marginY, 0, 0);
                params.setMarginStart(marginX);
                break;
            }
            case GRAVITY_TOP_CENTER: {
                params.addRule(10);
                params.addRule(14);
                params.setMargins(0, marginY, 0, 0);
                params.setMarginStart(marginX);
                break;
            }
            case GRAVITY_TOP_RIGHT: {
                params.addRule(10);
                params.addRule(11);
                params.setMargins(0, marginY, marginX, 0);
                params.setMarginEnd(marginX);
                break;
            }
            case GRAVITY_BOTTOM_LEFT: {
                params.addRule(12);
                params.addRule(9);
                params.setMargins(marginX, 0, 0, marginY);
                params.setMarginStart(marginX);
                break;
            }
            case GRAVITY_BOTTOM_CENTER: {
                params.addRule(12);
                params.addRule(14);
                params.setMargins(0, 0, 0, marginY);
                params.setMarginStart(marginX);
                break;
            }
            case GRAVITY_BOTTOM_RIGHT: {
                params.addRule(12);
                params.addRule(11);
                params.setMargins(0, 0, marginX, marginY);
                params.setMarginEnd(marginX);
                break;
            }
            case GRAVITY_CENTER: {
                params.addRule(13);
            }
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)params);
        imageView.setImageBitmap(this.getBase64Bitmap());
        return imageView;
    }

    private Bitmap getBase64Bitmap() {
        byte[] decodedString = Base64.decode((String)this.getBase64Watermark(), (int)0);
        return BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
    }

    private String getBase64Watermark() {
        return "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";
    }

    public static enum WatermarkGravity {
        GRAVITY_TOP_LEFT,
        GRAVITY_TOP_CENTER,
        GRAVITY_TOP_RIGHT,
        GRAVITY_BOTTOM_LEFT,
        GRAVITY_BOTTOM_CENTER,
        GRAVITY_BOTTOM_RIGHT,
        GRAVITY_CENTER;

    }

    public static enum WatermarkSize {
        SMALL,
        LARGE;

    }
}

