/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.gdpr;

import android.content.Context;
import android.util.Base64;
import com.mobfox.android.core.gdpr.GDPRParams;

public class GDPRConsentString {
    private final byte[] mBytes;
    private final String mString;

    public GDPRConsentString(String src) {
        this.mString = src;
        this.mBytes = (byte[])(this.mString.length() > 1 ? Base64.decode((String)this.mString, (int)3) : null);
    }

    public GDPRConsentString(byte[] src) {
        this.mBytes = src;
        this.mString = Base64.encodeToString((byte[])this.mBytes, (int)3);
    }

    public GDPRConsentString(Context ctx) {
        this.mString = GDPRParams.getConsentString(ctx);
        this.mBytes = (byte[])(this.mString.length() > 1 && !this.mString.equalsIgnoreCase("Nil") ? Base64.decode((String)this.mString, (int)8) : null);
    }

    public String toString() {
        return this.mString;
    }

    public boolean weHaveConsent(int ourVendorId) {
        try {
            boolean res = false;
            if (this.mString == null) {
                return false;
            }
            if (this.mString.length() == 0) {
                return false;
            }
            int MaxVendorId = this.getInt(156, 16);
            if (MaxVendorId < ourVendorId) {
                return false;
            }
            boolean EncodingType = this.getBit(172);
            if (!EncodingType) {
                res = this.getBit(172 + ourVendorId);
            } else {
                boolean DefaultConsent = this.getBit(173);
                int NumEntries = this.getInt(174, 12);
                int Offset = 186;
                for (int i = 0; i < NumEntries; ++i) {
                    boolean SingleOrRange = this.getBit(Offset);
                    if (SingleOrRange) {
                        int StartVendorId = this.getInt(Offset + 1, 16);
                        int EndVendorId = this.getInt(Offset + 1 + 16, 16);
                        if (StartVendorId <= ourVendorId && ourVendorId <= EndVendorId) {
                            return !DefaultConsent;
                        }
                        Offset = Offset + 1 + 16 + 16;
                        continue;
                    }
                    int SingleVendorId = this.getInt(Offset + 1, 16);
                    if (SingleVendorId == ourVendorId) {
                        return !DefaultConsent;
                    }
                    Offset = Offset + 1 + 16;
                }
                res = DefaultConsent;
            }
            return res;
        }
        catch (Exception e) {
            return false;
        }
    }

    private byte bigEndian(int offset) {
        switch (offset % 8) {
            case 0: {
                return -128;
            }
            case 1: {
                return 64;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    public boolean getBit(int offset) {
        if (this.mBytes == null) {
            return false;
        }
        byte b = this.mBytes[offset / 8];
        byte bigEndian = this.bigEndian(offset % 8);
        return (b & bigEndian) != 0;
    }

    public void setBit(int offset) {
        if (this.mBytes == null) {
            return;
        }
        int byteIndex = offset / 8;
        int shift = (byteIndex + 1) * 8 - offset - 1;
        int n = byteIndex;
        this.mBytes[n] = (byte)(this.mBytes[n] | 1 << shift);
    }

    public void clearBit(int offset) {
        if (this.mBytes == null) {
            return;
        }
        int byteIndex = offset / 8;
        int shift = (byteIndex + 1) * 8 - offset - 1;
        int n = byteIndex;
        this.mBytes[n] = (byte)(this.mBytes[n] & ~(1 << shift));
    }

    public int getInt(int startFrom, int size) {
        int val = 0;
        int oneBit = 1;
        int hezka = size - 1;
        for (int i = 0; i < size; ++i) {
            if (this.getBit(startFrom + i)) {
                val += oneBit << hezka;
            }
            --hezka;
        }
        return val;
    }

    public long getLong(int startFrom, int size) {
        long val = 0L;
        long oneBit = 1L;
        int hezka = size - 1;
        for (int i = 0; i < size; ++i) {
            if (this.getBit(startFrom + i)) {
                val += oneBit << hezka;
            }
            --hezka;
        }
        return val;
    }

    private void setNumber(int startFrom, int size, long to) {
        if (this.mBytes == null) {
            return;
        }
        for (int i = size - 1; i >= 0; --i) {
            int index = startFrom + i;
            int byteIndex = index / 8;
            int shift = (byteIndex + 1) * 8 - index - 1;
            int n = byteIndex;
            this.mBytes[n] = (byte)((long)this.mBytes[n] | to % 2L << shift);
            to /= 2L;
        }
    }

    public void setInt(int startFrom, int size, int to) {
        this.setNumber(startFrom, size, to);
    }

    public void setLong(int startFrom, int size, long to) {
        this.setNumber(startFrom, size, to);
    }

    public String getSixBitString(int startFrom, int size) {
        int charNum = size / 6;
        StringBuilder val = new StringBuilder();
        for (int i = 0; i < charNum; ++i) {
            int charCode = this.getInt(startFrom + i * 6, 6) + 65;
            val.append((char)charCode);
        }
        return val.toString().toUpperCase();
    }

    public void setSixBitString(int startFrom, int size, String to) {
        char[] values = to.toCharArray();
        for (int i = 0; i < values.length; ++i) {
            int charCode = values[i] - 65;
            this.setInt(startFrom + i * 6, 6, charCode);
        }
    }

    public String getBinaryString() {
        if (this.mBytes == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        int size = this.mBytes.length * 8;
        for (int i = 0; i < size; ++i) {
            if (this.getBit(i)) {
                s.append("1");
                continue;
            }
            s.append("0");
        }
        return s.toString();
    }
}

