/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.util.List;
import javapns.notification.exceptions.PayloadMaxSizeExceededException;
import javapns.notification.exceptions.PayloadMaxSizeProbablyExceededException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Payload {
    static final Logger logger = LoggerFactory.getLogger(Payload.class);
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private final JSONObject payload;
    private String characterEncoding = "UTF-8";
    private int expiry = 86400;
    private boolean payloadSizeEstimatedWhenAdding = false;
    private int preSendConfiguration = 0;

    protected Payload() {
        this.payload = new JSONObject();
    }

    Payload(String rawJSON) throws JSONException {
        this.payload = new JSONObject(rawJSON);
    }

    public JSONObject getPayload() {
        return this.payload;
    }

    public void addCustomDictionary(String name, String value) throws JSONException {
        logger.debug("Adding custom Dictionary [" + name + "] = [" + value + "]");
        this.put(name, value, this.payload, false);
    }

    public void addCustomDictionary(String name, int value) throws JSONException {
        logger.debug("Adding custom Dictionary [" + name + "] = [" + value + "]");
        this.put(name, value, this.payload, false);
    }

    public void addCustomDictionary(String name, List values) throws JSONException {
        logger.debug("Adding custom Dictionary [" + name + "] = (list)");
        this.put(name, values, this.payload, false);
    }

    public void addCustomDictionary(String name, Object value) throws JSONException {
        logger.debug("Adding custom Dictionary [" + name + "] = [" + value + "]");
        this.put(name, value, this.payload, false);
    }

    public String toString() {
        return this.payload.toString();
    }

    void verifyPayloadIsNotEmpty() {
        if (this.getPreSendConfiguration() != 0) {
            return;
        }
        if (this.toString().equals("{}")) {
            throw new IllegalArgumentException("Payload cannot be empty");
        }
    }

    public byte[] getPayloadAsBytes() throws Exception {
        byte[] payload = this.getPayloadAsBytesUnchecked();
        this.validateMaximumPayloadSize(payload.length);
        return payload;
    }

    private byte[] getPayloadAsBytesUnchecked() throws Exception {
        byte[] bytes;
        try {
            bytes = this.toString().getBytes(this.characterEncoding);
        }
        catch (Exception ex) {
            bytes = this.toString().getBytes();
        }
        return bytes;
    }

    public int getPayloadSize() throws Exception {
        return this.getPayloadAsBytesUnchecked().length;
    }

    private boolean isPayloadTooLong() {
        try {
            byte[] bytes = this.getPayloadAsBytesUnchecked();
            if (bytes.length > this.getMaximumPayloadSize()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int estimatePayloadSizeAfterAdding(String propertyName, Object propertyValue) {
        try {
            int estimatedSize = this.getPayloadAsBytesUnchecked().length;
            if (propertyName != null && propertyValue != null) {
                estimatedSize += 5;
                estimatedSize += propertyName.getBytes(this.getCharacterEncoding()).length;
                int estimatedValueSize = 0;
                if (propertyValue instanceof String || propertyValue instanceof Number) {
                    estimatedValueSize = propertyValue.toString().getBytes(this.getCharacterEncoding()).length;
                }
                estimatedSize += estimatedValueSize;
            }
            return estimatedSize;
        }
        catch (Exception e) {
            try {
                return this.getPayloadSize();
            }
            catch (Exception e1) {
                return 0;
            }
        }
    }

    public boolean isEstimatedPayloadSizeAllowedAfterAdding(String propertyName, Object propertyValue) {
        int maximumPayloadSize = this.getMaximumPayloadSize();
        int estimatedPayloadSize = this.estimatePayloadSizeAfterAdding(propertyName, propertyValue);
        return estimatedPayloadSize <= maximumPayloadSize;
    }

    private void validateMaximumPayloadSize(int currentPayloadSize) throws PayloadMaxSizeExceededException {
        int maximumPayloadSize = this.getMaximumPayloadSize();
        if (currentPayloadSize > maximumPayloadSize) {
            throw new PayloadMaxSizeExceededException(maximumPayloadSize, currentPayloadSize);
        }
    }

    void put(String propertyName, Object propertyValue, JSONObject object, boolean opt) throws JSONException {
        try {
            if (this.isPayloadSizeEstimatedWhenAdding()) {
                boolean estimatedToExceed;
                int maximumPayloadSize = this.getMaximumPayloadSize();
                int estimatedPayloadSize = this.estimatePayloadSizeAfterAdding(propertyName, propertyValue);
                boolean bl = estimatedToExceed = estimatedPayloadSize > maximumPayloadSize;
                if (estimatedToExceed) {
                    throw new PayloadMaxSizeProbablyExceededException(maximumPayloadSize, estimatedPayloadSize);
                }
            }
        }
        catch (PayloadMaxSizeProbablyExceededException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (opt) {
            object.putOpt(propertyName, propertyValue);
        } else {
            object.put(propertyName, propertyValue);
        }
    }

    Object remove(String propertyName, JSONObject object) {
        return object.remove(propertyName);
    }

    public boolean isPayloadSizeEstimatedWhenAdding() {
        return this.payloadSizeEstimatedWhenAdding;
    }

    public void setPayloadSizeEstimatedWhenAdding(boolean checked) {
        this.payloadSizeEstimatedWhenAdding = checked;
    }

    int getMaximumPayloadSize() {
        return Integer.MAX_VALUE;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public int getExpiry() {
        return this.expiry;
    }

    private void setExpiry(int seconds) {
        this.expiry = seconds;
    }

    public Payload asSimulationOnly() {
        this.setExpiry(919191);
        return this;
    }

    int getPreSendConfiguration() {
        return this.preSendConfiguration;
    }

    void setPreSendConfiguration(int preSendConfiguration) {
        this.preSendConfiguration = preSendConfiguration;
    }
}

